# doN.r
	# LinePlot, diff areas

# pdf(file="out.pdf")

SACONLY = 1	# 0=std  1=saconly:cross panels,sac stacks  
		# 2=saconly format for standard or 'mix' data
		# 3:just 'cross' panels, but for *all* stacks, not just sac
MIXED2  = 0	# All 5 tasks, recorded *after* sac-only sessions (1 hemi only)

CC_INACT = 0	# Inactivation data?  1:lesion   2:control   3:both
CC_TIME  = -1	#   -1:pre 0:peri 1:post

InitPar = par(mar=c(0,2,5,0), las=1, xpd=T)

if (SACONLY) {
   par(mfrow=c(1,2), oma=c(4,2,1,1))
 } else if (CC_INACT) {
   par(mfrow=c(1,1), oma=c(5.5,4,2.5,1))
 } else
   par(mfrow=c(2,3), oma=c(5.5,4,3,2))

par(mfrow=c(1,2), oma=c(4,2,1,1), mar=c(1.5,2,5,0))		# DIAG

Plots = c("PRR","cross","crossX2","LIP", "cross","crossX2")
Units = c(  "",  "PRR",   "PRR",   "",    "LIP",  "LIP")
#  Names are hardwired elsewhere - do not change them !!

CHRONUX = F				# [F] Do not change (use ../chronux)
NEAR.OVERRIDE = 2 
YLIM.OVERRIDE = .5			# [1 if EACH.STACK  Mult by cell count
if (!exists("DOUBLE.OVERRIDE"))
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=100+"	# mix2 *****
    DIR.OVERRIDE = "GoCue_-800:0ms.N=500+"	# standard and saconly
   # DIR.OVERRIDE = "GoCue_-800:0ms"

   # Set SAC.ONLY to 1
   # DIR.OVERRIDE = "AllGoCue_-800:0ms"		# Sacade-only stacks
   # DIR.OVERRIDE = "AllGoCue_-800:0ms.N=500"	# Ditto, 500 spikes/cell
   # DIR.OVERRIDE = "AllGoCue_-800:0ms.N=1000"
   # DIR.OVERRIDE = "AllGoCue_-800:0ms.N=2000"
   # DIR.OVERRIDE = "AllGoCue_-800:0ms.N=5000"

   # DIR.OVERRIDE = "GoCue_-800:0ms.N=500+" 	# >=500 spikes/cell ******
   # Set SAC.ONLY to 0
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=0"	# All stacks, all cells
   # DIR.OVERRIDE = "All-sacGoCue_-800:0ms"
   # DIR.OVERRIDE = "All-sacGoCue_-800:0ms.N=100"
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=100"	# Can add or remove "+" from end
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=250+"
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=400"
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=500+" 	# >=500 spikes/cell ******
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=500"	# 500 spikes/cell
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=1000+"	# All stacks, >=1000 spikes/cell

   # Mixed2  -- note: no interhemispheric (only right hemisphere recordings!)
   #    So only "cross" entries
   # DIR.OVERRIDE = "AllTarget_-500:0ms"
   # DIR.OVERRIDE = "All-sacGoCue_-800:0ms"
   # DIR.OVERRIDE = "GoCue_-800:0ms"		# All stacks, all cells
   # DIR.OVERRIDE = "GoCue_-800:0ms{_shuffle}"	# with chronux = T

   # -------------------------------------------------------------------#
   # CC lesion & control
						# In control, peri block:
   # DIR.OVERRIDE = "Target_500:1250ms"	# apart22:26 both22:32 sac24:26 uni36:42
   # DIR.OVERRIDE = "Target_500:1250ms.N=100"	# apart 30,32  sac 34,40
   # DIR.OVERRIDE = "Target_500:1250ms.N=100+"	# both  22:34  sac 24:30
   # DIR.OVERRIDE = "Target_500:1250ms.N=250+"	# both  22:34  sac 24,26,30
   # DIR.OVERRIDE = "Target_500:1250ms.N=500+"	# both  22:6,30:2 sac:24,26,30
   # DIR.OVERRIDE = "Target_500:1250ms.N=750+"	# both  22:6,30:2    (n=20)

   # DIR.OVERRIDE = "Target_-500:1250ms"		# Not much - don't use

   # DIR.OVERRIDE = "AllTarget_-500:0ms.N=100"		# None even nearly sig
   # DIR.OVERRIDE = "AllTarget_-500:1250ms"		# All are sig (!)
   # DIR.OVERRIDE = "All-sacTarget_-500:1250ms"		# Ditto, but less so
   # DIR.OVERRIDE = "All-sacGoCue_-800:0ms.N=100"	# 24

   # DIR.OVERRIDE = "GoCue_-800:0ms"		# apart40:2 both22:34 uni32:6
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=100"	# apart 24
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=250"	# none
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=100+"	# both 22:34 apart 40:2 uni 32:4
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=250+"	# both 24:34 apart 40:2 uni 32:4
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=500+"	# both 22:34 apart 38:42 sac 28
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=750+"	# both 22:34 apart 38:42 (n=22)
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=1000+"	# n=4 (useless)
   # DIR.OVERRIDE = "GoCue_-800:0ms.N=1000"	# n=4 (useless)
	# %sig rises with N, til n falls too low. N=500 or 750 are good
   # -------------------------------------------------------------------#


   # DIR.OVERRIDE = "GoCue_50:450ms"
   # DIR.OVERRIDE = "SacOnlyGoCue_-800:0ms"	# Use to compare w/ (SACONLY=2)
   # DIR.OVERRIDE = "Target_500:1250ms"
   # DIR.OVERRIDE = "Target_-500:1250ms"
   # DIR.OVERRIDE = "Target_800:1300ms"
   # DIR.OVERRIDE = "AllTarget_-500:0ms"
   # DIR.OVERRIDE = "AllTarget_-500:0ms.N=100"
   # DIR.OVERRIDE = "Target_-500:0ms"		# Better to use 'All'
   # DIR.OVERRIDE = "AllTarget_-500:0ms_NoE"
   # DIR.OVERRIDE = "AllTarget_-400:0ms"
   # DIR.OVERRIDE = "AllTarget_-300:0ms"
   # DIR.OVERRIDE = "AllTarget_-500:1200ms"
   # DIR.OVERRIDE = "AllTarget_800:1300ms"
   # DIR.OVERRIDE = "AllGoCue_-500:0ms"	# Target_{0:1000,300:1300}ms
   # DIR.OVERRIDE = "AllGoCue_-1000:0ms"
					# Comment out that one line for doMany.r

# -300:0 -350:50 -500:0

LOOP = T

for (pl in 1:6) {
     if ((SACONLY|MIXED2) & (pl != 2 & pl != 5))
       next
     if (CC_INACT & (pl != 1))
       next
     if (pl != 2 & pl != 5) next			# DIAG

    AREA.OVERRIDE = Plots[pl]
    UNIT.OVERRIDE = Units[pl]
    MONK.OVERRIDE = ifelse(MIXED2, "tyr", "both")	# both, zen, tyr
    # MONK.OVERRIDE = "tyr"
    source("main.r")
    # Possble DIAG printouts:
     # print(t(MeanCounts)) # If you want to see the counts!
     # ============
     # cat("Cells with sig effects (0.05) at 36 Hz,",Units[pl],Plots[pl],"\n")
     # for (type in 62:66)
     # 	 cat("  Type", type, "  ",
     #	      data[data[,"freq"]==36 & data[,"pval"]<0.05 & data[,"type"]==type,
     #		   "unit"], "\n")
     # ============
     # print(FilesToDo)	# Confirm that they are ordered

    # This should move to the individual calls in main.r
    if (PLOT.TYPE == "SignifSync") {
       par(xpd=NA)
       if (par()$mfg[2] == 1) {	# 1st column?
          axis(2, at=YLIM*c(0,.5,1), 
	       labels=paste0(round(YLIM*c(0,.5,1)/CellCount*100,dig=1), "%"))
          save = par(mgp=c(4-4*(SACONLY>0),1,0))
          title(ylab="Coherent pairs (%)")
          par(save)
          } 
       if (par()$mfg[1] == par()$mfrow[1]) {	# bottom row?
          axis(1, at=if (par("xlog")) 2^(2:7) else (0:3)*50, labels=T)
          title(xlab="Frequency (Hz)")
          }
       par(xpd=F)
       }
    }

mtext(paste0(MONK, if (NEAR) paste0("+",NEAR," mm"), "    ",
	     ifelse(exists("MIN_FREQ"), MIN_FREQ, min(BANDS.SEQ)),
	     " to ",
	     ifelse(exists("MAX_FREQ"), MAX_FREQ, max(BANDS.SEQ)),
	     "Hz",
	     "\n",
	     directory,
	     "\n",
	     if (SACONLY == 1) "saconly ", 
	     # if (SACONLY == 2) " (sac trials only)",
	     if (MIXED2) "mixed2 ",
	     if (CC_INACT==1) "cc_lesion ",
	     if (CC_INACT==2) "cc_control ",
	     if (CC_INACT==3) "cc_lesion+control  ",
             if (CC_INACT)     c("Pre", "Peri", "Post")[2+CC_TIME]),
      side = 3, line = -2.5-             (SACONLY>0), outer = T)

LOOP = F
rm(PLOT.TYPE)
if (exists("MIN_FREQ")) rm(MIN_FREQ)
if (exists("MAX_FREQ")) rm(MAX_FREQ)
par(InitPar)

# dev.off()
if (SHUFFLE) rm(MAX_SHUFFLE)
rm(SACONLY, MIXED2, CHRONUX, SHUFFLE, InitPar, Plots, Units,
   NEAR.OVERRIDE, YLIM.OVERRIDE, DIR.OVERRIDE, LOOP, pl, AREA.OVERRIDE,
   UNIT.OVERRIDE, MONK.OVERRIDE)
