# Scale to ~40 per cell
A = matrix( c(6,4,4,19), nrow=2, ncol=2)

# 22:42 Hz
#             22 4 6 8 0 2 4 6 8 0 42
#  original data, both monks
 Both.p =    c(4,7,5,7,6,8,7,8,8,7,7) # /42	# PRR->LIP
 Both.l =    c(5,5,4,4,5,4,4,5,4,3,2) # /40	# LIP->PRR
 Both.n = c(42,40)
#  original data, tyr only
 Tyr.p =     c(1,3,1,3,3,4,4,6,6,5,5) # /24	# PRR->LIP
 Tyr.l =     c(1,1,1,1,1,2,2,2,2,2,2) # /20	# LIP->PRR
 Tyr.n = c(24,20)
#  sac only (tyrol)
 SacOnly.p = c(0,2,3,3,3,3,3,3,3,3,2) # /12	# PRR->LIP
 SacOnly.l = c(4,5,5,5,5,6,6,7,7,7,6) # /12	# LIP->PRR
 SacOnly.n = c(12,12)

Mixed = "Both"		# Both or Tyr
Hz = 36

N = c(get(paste0(Mixed,".n")), SacOnly.n)

A = matrix(   c(
		get(paste0(Mixed,".p"))[(Hz/2-10)],
    		get(paste0(Mixed,".l"))[(Hz/2-10)],
    		SacOnly.p[(Hz/2-10)],
    		SacOnly.l[(Hz/2-10)]
               ) * Scale
		, nrow=2, ncol=2, byrow=F)

A = as.table(A)

dimnames(A) = list(
	direction=c("PRR->LIP","LIP->PRR"), context=c("mixed", "saconly")) 

print(chisq.test(A, simulate.p.value=T))


# # DOES NOT WORK
# A = array( c(6,4,1,5, 36,36,9,6), dim=c(2,2,2),
#	 dimnames = list(
#		        direction=c("PRR->LIP","LIP->PRR"), 
#			context=c("mixed", "saconly"),
#			result=c("sig", "not sig"))) 
# A = as.table(A)
# print(chisq.test(A, simulate.p.value=T))

