# VectorLengthBar.r
# (-mc)

#   called by main

# Coherence vs synchrony: set below in the body of the code

YLIM = .12		# Overrides what is set 'above'
VECTOR.SUM = F		# [F] F: amplitude  T: angle
			#    For angle, use VectorAngle !
SIG.CRIT = 0.01 # .05		# 0 or P value (include only significant cells?)

PLOT.TYPE = "VectorLengthBar"

# SavePar = par(oma=c(4,3,3,2), las=1, xpd=NA)

if (!exists("LOOP")) LOOP = F

library(circular)

VectorSum = function(p) {
	p = p[!is.na(p[,1]),]
	if (length(p) == 0) return(list(0, 2))
	if (length(p) == 2) return(list(p[1], 2))
	if (VECTOR.SUM) {
	   x = mean(p[,1] * cos(p[,2]), na.rm=T)		# Vector sum
	   y = mean(p[,1] * sin(p[,2]), na.rm=T)
	   {
	   options(warn=-1)
	   ttttt = rayleigh.test(as.circular(p[,2]))$p.value
	   cat("WRONG - cannot use to test vectors, only angles!\n")
	   options(warn=0)
	   }
	   return(list(sqrt(x^2 + y^2), ttttt))
	 } else
	   return(list(mean(p[,1], na.rm=T), 2)) # Mean ampl (ignore direction)
	}



# colnames = c("freq","cohere","c_rads","sync","s_rads","pval","type","unit")

if (VECTOR.SUM) {
   Freqs = list(11, 22, 36, 97)			# Most conservative
 } else
   Freqs = list(8:14, 16:28, 30:42, 66:128)	# Cheat: freqs not independent

# Freqs = list(c(8,14), c(16,28), c(30,42), c(66,128))	# OK?

FreqBins = length(Freqs)

stacks = list(62,63:64,65,66)
signifs = lengths = matrix(NA, nrow=FreqBins, ncol=4)
colnames(lengths) = stacks
rownames(lengths) = Freqs
GroupSignif = rep(NA, FreqBins)

for (bin in 1:FreqBins) {
  for (st in 1:length(stacks)) {
      temp =
	VectorSum(data[(data[,"freq"] %in% Freqs[[bin]]) & 
		       (data[,"type"] %in% stacks[[st]]) & 
		        data[,"pval"] < ifelse(SIG.CRIT==0, 1.1, SIG.CRIT),
    				 # c("cohere","c_rads")])
    				 c("sync",  "s_rads")])
      lengths[bin, st] = temp[[1]]
      signifs[bin, st] = temp[[2]]
      }
  GroupSignif[bin] = 
	VectorSum(data[(data[,"freq"] %in% Freqs[[bin]]) & 
		        data[,"pval"] < ifelse(SIG.CRIT==0, 1.1, SIG.CRIT),
    				 # c("cohere","c_rads")])[[2]]
    				 c("sync",  "s_rads")])[[2]]
  }

par(las=2)
midpoints = barplot(t(lengths), beside=T, axes=F, border=NA,
		col=c("gray35","green","red","blue","purple")[-3],
		ylim=c(0,YLIM))
text(midpoints, t(lengths)+YLIM*.05,
			 ifelse(c(t(signifs))<.01,  "**", 
			 ifelse(c(t(signifs))<.05,  "*", "")), cex=1.5)
text(colMeans(midpoints), max(lengths)+YLIM*.1,
			 ifelse(GroupSignif<.05,  "*", ""), col="red", cex=2)
par(las=0)

par(xpd=NA)
if (par()$mfg[2] == 1) {                    # 1st column?
   axis(2, at=YLIM*c(0,.5,1))
   save = par(mgp=c(4,1,0))
   title(ylab="Vector length")
   par(save)
  } else
   axis(2, at=YLIM*c(0,.5,1), F)

if (par()$mfg[1] == 2)                     	# bottom?
   title(xlab="Frequency (Hz)")
par(xpd=F)

if (LOOP) {
   title(main = paste0("\n", AREA, if (UNIT!="") paste0(" (units:", UNIT, ")")),
	 cex.main=1.4)
   title(main = paste("\n\n\n\nn=", CellCount), cex.main=.9)
   # title(main = paste0("\n\n", AREA, "      [n=", CellCount, "]"))
 } else
   title(main = paste0(MONK, "  ", AREA, if (NEAR) paste0("+",NEAR),
                                                " (n=", CellCount, ")"))

# par(SavePar)
