# VectorLength.r
# (-mc)

#   called by main

if (!exists("OVERRIDE"))
   METHOD = 4   # [1?]  1:mean ampl -- clearly best! (coherence or sync vector)
                #         Clearest result; ignores if cells all aligned or not!
                #         That is, there can be no tuning for phase angle!!
                #       2:true vector sum
                #       3:vector sum but of direction only
                #       4:percent signif cells in #3 (always SYNC=T)
                #           (same as SignifSync(bar))
LOG = T			# [T]
SYNC = F		# [F] Use synchrony(T) or coherence(F)?
SMOOTH = .05		# [.15] [.001]
PVAL = .05		# For method 4 only
MELD.UNI = F		# stacks 63 & 64 merged
MELD.REACH = T		# stacks 63:66 merged (takes precedent over UNI)

YLIM = switch(METHOD, .13, .05, .5, 60)		# See also below!
YLOW = switch(METHOD, 0.02, 0, 0, 0)
# YLIM = switch(METHOD, 1, .1, .1, 20)		# See also below!
# YLIM = 25 # DIAG

PLOT.TYPE = "VectorLength"

# SavePar = par(oma=c(4,3,3,2), las=1, xpd=NA)

if (!exists("LOOP")) LOOP = F

library(circular)

LoX = if (LOG) 14 else 0

EffectSum = function(p) {		# Pass it an index
	if (sum(p,na.rm=T) < 6) return(NA)
	if (any(p[is.na(data[p,2])]))	# can't just set p[is.na(data[p,2])] = F
	   stop("Thought we fixed this - tricky issue; be careful!")
	if (sum(p) < 6) return(NA)

	if (METHOD == 1) {	# Scalar mean of amplitude; ignore direction
	   p = data[p, if (SYNC) "sync" else "cohere"]
	   # Don't do this, but if only wanted signif ones:
	   #   p = data[data[p,"pval"] < .05, if (SYNC) "sync" else "cohere"]
	   return(mean(p))
	   }
	if (METHOD == 2) {	# Vector sum (directions weighted by amplitude)
	   p = data[p, if (SYNC) c("sync","s_rads") else c("cohere","c_rads") ]
	   x = mean(p[,1] * cos(p[,2]), na.rm=T)
	   y = mean(p[,1] * sin(p[,2]), na.rm=T)
	   return(sqrt(x^2+y^2))
	   }
	if (METHOD == 3) {	# Vector sum of direction; ignore amplitude
	   p = data[p, ifelse(SYNC, "s_rads", "c_rads")]
	   return(sqrt(mean(sin(p))^2 + mean(cos(p))^2))
	   }
	if (METHOD == 4) {	# % significant cells
	   return(100*sum(data[p, "pval"]<PVAL) / sum(p))
	   }
	stop("Unknown METHOD")
	}

# colnames = c("freq","cohere","c_rads","sync","s_rads","pval","type","unit")

lengths = matrix(NA, nrow=length(BANDS.SEQ), ncol=5)

FreqToIndex = function(freq) return(which(BANDS.SEQ %in% freq))
IndexToFreq = function(index) return(BANDS.SEQ[index])

Stacks = sort(unique(data[,7]))		# Different types (usually stacks)

if (METHOD==4 & (length(Stacks)==1))
   YLIM = 50

for (freq in unique(data[,1]))		# Average over each site to get a single
 for (st in Stacks)			#  length for each frequency and stack
   lengths[FreqToIndex(freq),st-61] = 
	 EffectSum(data[,1]==freq & 
		   # data[,6]<SIG.CRIT & 	# No reason to use
		   !is.na(data[,2]) &
		   if (MELD.REACH & st==63) {
		      (data[,7]==63|data[,7]==64|data[,7]==65|data[,7]==66)
		    } else if (MELD.REACH & st>=63) {
		      NA
		    } else if (MELD.UNI & st==63) {
		      (data[,7]==63 | data[,7]==64)
		    } else if (MELD.UNI & st==64) {
		      NA
		    } else {
		      data[,7]==st 
		      }    
	   	    )

par(las=2)
par(xpd=NA)
plot(1,0,
     xlim=c(LoX, 150), 
     ylim=c(YLOW,YLIM),
     type='n', axes=F, if (LOG) log="x" else log="", xlab="", ylab="")

if (par()$mfg[2] == 1) {	# 1st column?
   axis(2)
   save = par(mgp=c(3,1,0))
   title(ylab=ifelse(METHOD==4, "Significant cells (%)", "Vector lengths"))
   par(save)
  } else
   axis(2, labels=F)

if (par()$mfg[1] == par()$mfrow[1]) {	# bottom row?
   axis(1, at=if (par("xlog")) 2^(4:7) else (0:3)*50, labels=T)
   title(xlab="Frequency (Hz)")
  } else
   axis(1, at=if (par("xlog")) 2^(4:7) else (0:3)*50, labels=F)
par(xpd=T)
par(las=0)

for (st in 1:length(Stacks))
     lines(lapply(lowess(BANDS.SEQ, lengths[,st], f=SMOOTH),
		   "[", FreqToIndex(14:128)),
         	col=c("black","green","red","blue","purple")[st],
	 	lwd=5)

polygon(c(20, 20, 35, 35, 20),
	c( 0, YLIM, YLIM, 0, 0),
	col=adjustcolor("gray",alpha.f=.4),
	border=NA)
segments(25, 0, 25, YLIM, 
	col=adjustcolor("gray",alpha.f=.7))
segments(30, 0, 30, YLIM, 
	col=adjustcolor("gray",alpha.f=.7))

if (METHOD==4)
   segments(LoX, PVAL*100, 150, PVAL*100, lty=2)

if (LOOP) {
   title(main = paste0("\n", AREA, if (UNIT!="") paste0(" (units:", UNIT, ")")),
	 cex.main=1.4, font.main=2)
   title(main = paste("\n\n\n\nn=", CellCount), cex.main=.9)
 } else
   title(main = paste0(MONK, "  ", AREA, if (NEAR) paste0("+",NEAR),
                                           " (n=", CellCount, ")"))

if (all(par()$mfg[1:2] == par()$mfrow[1:2])) {	# last panel?
   mtext(paste0(
     METHOD, ": ",
     switch(METHOD, "Mean amplitude", "Weighted vector sum",
	    	    "Vector sum (angle only)", "% Significant cells"),
     " of ", ifelse(SYNC, "synchrony", "'coherence'"),
     "; smoothed (", SMOOTH, ") "),
	 side=1, line=3, outer=T, adj=-.05, cex=.6, font=2)

   if (SACONLY) {
    mtext("Saccade", col=1, side=3, line=-2.3, outer=T, adj=1, cex=.8, font=2)
   } else {
    mtext("Saccade",   col=1, side=3, line=-0.2, outer=T,adj=1, cex=.8,font=2)
    mtext("Ipsi",      col=3, side=3, line=-0.9, outer=T,adj=1, cex=.8,font=2)
    mtext("Contra",    col=2, side=3, line=-1.6, outer=T,adj=1, cex=.8,font=2)
    mtext("Together",  col=4, side=3, line=-2.3, outer=T,adj=1, cex=.8,font=2)
    mtext("Apart",col="purple",side=3,line=-3.0, outer=T,adj=1, cex=.8,font=2)
    }
   }

# par(SavePar)
