# VectorLength.r
# (-mc)

#   called by main

# Coherence vs synchrony: set below in the body of the code

if (!exists("OVERRIDE"))
   METHOD = 1	# [1?]	1:mean ampl -- clearly best! (coherence or sync vector)
		#	  Clearest result; ignores if cells all aligned or not!
		#	  That is, there can be no tuning for phase angle!!
		#	  May not be what we want! (SPIKE_NUM confound?)
		#	2:true vector sum
		#	3:vector sum but of direction only
		#	4:percent signif cells in #3 (always SYNC=T) 
		#           (same as SignifSync(bar))
LOG = F			# [T]
SYNC = F		# [F] Use synchrony(T) or coherence(F)?
     		# w/ enuf spikes, sync is downscaled,noisy version of coherence
SMOOTH = .06		# [.15] [.001] [.06?]  (.03 or lower has no effect?)
PVAL = .05		# For method 4 only

if (SACONLY == 1) {
   YLOW = switch(METHOD, .02, .00, .00, 00)             # See also below!
   YLIM = switch(METHOD, .06, .03, .36, 20)             # See also below!
 } else {
   YLIM = switch(METHOD, .13, .05, .5, 40)		# See also below!
   YLOW = switch(METHOD, 0.02, 0, 0, 0)
   }

PLOT.RANGE = c(8:150)				# In Hz

PLOT.TYPE = "VectorLength"

# SavePar = par(oma=c(4,3,3,2), las=1, xpd=NA)

if (!exists("LOOP")) LOOP = F

library(circular)

LoX = if (LOG) 8 else 0		# [8 or 14]

EffectSum = function(freq, stack) {             # Pass it an index
        amp = c(amplitude[ , freq, 1, stack, ])
        ang = c(angle    [ , freq, 1, stack, ])

        if (length(amp) < 6) return(NA)

        if (METHOD == 1) {      # Scalar mean of amplitude; ignore direction
           return(mean(amp, na.rm=T))
           }
        if (METHOD == 2) {      # Vector sum of directions weighted by amplitude
           x = mean(amp * cos(ang), na.rm=T)
           y = mean(amp * sin(ang), na.rm=T)
           return(sqrt(x^2+y^2))
           }
        if (METHOD == 3) {      # Vector sum of direction; ignore amplitude
           return(sqrt(mean(sin(ang), na.rm=T)^2 + mean(cos(ang), na.rm=T)^2))
           }
        stop("Unknown METHOD")
        }

# colnames = c("freq","cohere","c_rads","sync","s_rads","pval","type","unit")

lengths = matrix(NA, nrow=length(BANDS.SEQ), ncol=5)

FreqToIndex = function(freq) return(which(BANDS.SEQ %in% freq))
IndexToFreq = function(index) return(BANDS.SEQ[index])

Stacks = sort(unique(data[,7]))		# Different types (usually stacks)

if (METHOD==4 & (length(Stacks)==1))
   YLIM = 50

for (freq in unique(data[,1]))		# Average over each site to get a single
 for (st in Stacks)			#  length for each frequency and stack
   lengths[FreqToIndex(freq),st-61] = 
	 EffectSum(data[,1]==freq & 
		   # data[,6]<SIG.CRIT & 	# No reason to use
		   data[,7]==st & 
		   !is.na(data[,2]))

par(las=2)
par(xpd=NA)
plot(1,0,
     xlim=c(LoX, 150), 
     ylim=c(YLOW,YLIM),
     type='n', axes=F, if (LOG) log="x" else log="", xlab="", ylab="")

if (par()$mfg[2] == 1) {	# 1st column?
   axis(2)
   save = par(mgp=c(4,1,0))
   title(ylab=ifelse(METHOD==4, "Significant cells (%)", "Vector lengths"))
   par(save)
  } else
   axis(2)

if (par()$mfg[1] == par()$mfrow[1]) {	# bottom row?
   axis(1, at=if (par("xlog")) 2^(4:7) else (0:3)*50, labels=T)
   title(xlab="Frequency (Hz)")
  } else
   axis(1, at=if (par("xlog")) 2^(4:7) else (0:3)*50, labels=F)
par(xpd=F)
par(las=0)

for (st in 1:length(Stacks))
     lines(lapply(lowess(BANDS.SEQ, lengths[,st], f=SMOOTH),
		   "[", FreqToIndex(PLOT.RANGE)),
         	col=c("black","green","red","blue","purple")[st],
	 	lwd=5)

if (SHUFFLE) {
   cat("Take code from chronux version\n")
 } else
   polygon(c(20, 20, 38, 38, 20),
	c( 0, YLIM, YLIM, 0, 0),
	col=adjustcolor("gray",alpha.f=.4),
	border=NA)


if (LOOP) {
   title(main = paste0("\n", AREA, if (UNIT!="") paste0(" (units:", UNIT, ")")),
	 cex.main=1.4, font.main=2)
   title(main = paste("\n\n\n\nn=", CellCount), cex.main=.9)
 } else
   title(main = paste0(MONK, "  ", AREA, if (NEAR) paste0("+",NEAR),
                                           " (n=", CellCount, ")"))

if (all(par()$mfg[1:2] == par()$mfrow[1:2])) {	# last panel?
   mtext(paste0(
     METHOD, ": ",
     switch(METHOD, "Mean amplitude", "Weighted vector sum",
	    	    "Vector sum (angle only)", "% Significant cells"),
     " of ", ifelse(SYNC, "synchrony", "'coherence'"),
     "; smoothed (", SMOOTH, "); "),
	 side=1, line=3, outer=T, adj=1, cex=.6, font=2)
   if (SACONLY) {
    mtext("Saccade", col=1, side=3, line=-2.3, outer=T, adj=1, cex=.8, font=2)
   } else {
    mtext("Saccade",   col=1, side=3, line= 1.7, outer=T,adj=1, cex=.8,font=2)
    mtext("Ipsi",      col=3, side=3, line= 0.7, outer=T,adj=1, cex=.8,font=2)
    mtext("Contra",    col=2, side=3, line=-0.3, outer=T,adj=1, cex=.8,font=2)
    mtext("Together",  col=4, side=3, line=-1.3, outer=T,adj=1, cex=.8,font=2)
    mtext("Apart",col="purple",side=3,line=-2.3, outer=T,adj=1, cex=.8,font=2)
    }
   }

# par(SavePar)
