# VectorAngleBar.r
# (-mc)

#   called by main

# Coherence vs synchrony: set below in the body of the code

WEIGHTED = T		# [T] Weight each angle by amplitude(T) or no (F) ?
SIG.CRIT = 1.1 		# [1.1] P value (include only significant cells?)
			#     If '1.1', means accept all !!
LENGTH_CRIT = 10	# If weighted, criterion for including angle in sig test
LOG = T			# [T]
SYNC = F		# [F] Use synchrony(T) or coherence(F)?
SMOOTH = .08		# [.0] Bypass if SIG.CRIT < .5

BOTTOM = -pi/2 - pi/16
TOP = 3*pi/2

PLOT.TYPE = "VectorAngleBar"


if (SYNC == F & SIG.CRIT != 1)
   warning("No P value for coherence!  Using sync p value")

if (!exists("LOOP")) LOOP = F

library(circular)

VectorSum = function(p) {
	p = p[!is.na(p)]
	if (length(p) < 2) return(list(NA,NA))
	{
	options(warn=-1)
	ttttt = rayleigh.test(as.circular(p))$p.value
	options(warn=0)
	}
	return(list(atan2(mean(sin(p)), mean(cos(p))), ttttt))
	}

WeightedSum = function(p) {
	if (length(p) < 6) return(list(NA,NA))
	p = p[!is.na(p[,2]),]
	if (length(p) < 6) return(list(NA,NA))

	x = mean(p[,1] * cos(p[,2]), na.rm=T)		# Vector sum
	y = mean(p[,1] * sin(p[,2]), na.rm=T)
	{
	options(warn=-1)
	ttttt = rayleigh.test(as.circular(p[p[,1]>LENGTH_CRIT,2]))$p.value
	options(warn=0)
	}
	return(list(atan2(y,x), ttttt))
	}

# colnames = c("freq","cohere","c_rads","sync","s_rads","pval","type","unit")

angle.sig =
angles = matrix(NA, nrow=length(BANDS.SEQ), ncol=5)

FreqToIndex = function(freq) return(which(BANDS.SEQ %in% freq))
IndexToFreq = function(index) return(BANDS.SEQ[index])

for (freq in unique(data[,1]))	# Average over each site to get a single
 for (st in 62:66) {		#  angle for each frequency and stack
   VectorSumList = 
     if (WEIGHTED) {
	 WeightedSum(
	   data[data[,1]==freq & data[,6]<SIG.CRIT & data[,7]==st,
		if (SYNC) c("sync","s_rads") else c("cohere","c_rads") ])
	} else
	 VectorSum(data[data[,1]==freq & data[,6]<SIG.CRIT & data[,7]==st,
		ifelse(SYNC, "s_rads", "c_rads")])
   angles[FreqToIndex(freq),st-61] = VectorSumList[[1]]
   angle.sig[FreqToIndex(freq),st-61] = VectorSumList[[2]]
   }

---------------------

# Freqs = list(8:14, 16:28, 30:42, 66:128)	# Cheat: freqs not independent
# Freqs = list(8:14, 20:36, 66:150)	# Cheat: freqs not independent
Freqs = list(8:22, 24:46, 54:66, 70:150 )	# Cheat: freqs not independent
FreqBins = length(Freqs)

GroupAngle = rep(NA, FreqBins)
---------------------

par(las=2)
par(xpd=NA)
plot(0,0, xlim=c(0,FreqBins*(length(stacks)+2)), ylim=1.1*c(-pi,pi), type='n',
     axes=F, xlab="", ylab="")

text(0:(FreqBins-1)*(length(stacks)+2)+length(stacks)/2,
      -pi-.5, 
	Freqs, adj=.5)

for (bin in 1:FreqBins) {
  segments((bin-1)*(length(stacks)+2) - 1, -pi+.5,
           (bin-1)*(length(stacks)+2) - 1,  pi-.5, lwd=1, col="gray")
  for (st in 1:length(stacks)) {
      temp =
	VectorSum(data[(data[,"freq"] %in% Freqs[[bin]]) & 
		       (data[,"type"] %in% stacks[[st]]) & 
		        data[,"pval"] < .05,
    				 # c("cohere","c_rads")])
    				 c("sync",  "s_rads")])
      angles[bin, st] = temp[[1]]
      signifs[bin, st] = temp[[2]]
      points((bin-1)*(length(stacks)+2) + st, temp[[1]],
	        bg = if (temp[[2]] < 0.05)
		        c("gray35","green","red","blue","purple")[st]
		      else
			NA,
		col = c("gray35","green","red","blue","purple")[st],
		pch=21, lwd=2, cex=2)
      }
  GroupAngle[bin] = 
	VectorSum(data[(data[,"freq"] %in% Freqs[[bin]]) & 
		        data[,"pval"] < ifelse(SIG.CRIT==0, 1.1, SIG.CRIT),
    				 # c("cohere","c_rads")])[[2]]
    				 c("sync",  "s_rads")])[[2]]
  }



# midpoints = barplot(t(angles), beside=T, axes=F, border=NA,
#		col=c("gray35","green","red","blue","purple")[-3],
#		ylim=c(0,YLIM))
#text(midpoints, t(angles)+YLIM*.05,
#			 ifelse(c(t(signifs))<.01,  "**", 
#			 ifelse(c(t(signifs))<.05,  "*", "")), cex=1.5)
#text(colMeans(midpoints), max(angles)+YLIM*.1,
#			 ifelse(GroupSignif<.05,  "*", ""), col="red", cex=2)
if (par()$mfg[2] == 1) {                    # 1st column?
   axis(2, at=c(-pi,0,pi), labels=c("-180","0","180"))
   save = par(mgp=c(4,1,0))
   title(ylab="Vector angles")
   par(save)
  } else
   axis(2, at=c(-pi,0,pi), labels=F)

if (par()$mfg[1] == 2)                     	# bottom?
   title(xlab="Frequency (Hz)")
par(xpd=F)
par(las=0)


if (LOOP) {
   title(main = paste0("\n", AREA, if (UNIT!="") paste0(" (units:", UNIT, ")")),
	 cex.main=1.4)
   title(main = paste("\n\n\n\nn=", CellCount), cex.main=.9)
   # title(main = paste0("\n\n", AREA, "      [n=", CellCount, "]"))
 } else
   title(main = paste0(MONK, "  ", AREA, if (NEAR) paste0("+",NEAR),
                                                " (n=", CellCount, ")"))

# par(SavePar)
===================================================================

angles = matrix(NA, nrow=length(BANDS.SEQ), ncol=5)

FreqToIndex = function(freq) return(which(BANDS.SEQ %in% freq))
IndexToFreq = function(index) return(BANDS.SEQ[index])

for (freq in unique(data[,1]))	# Average over each site to get a single
 for (st in 62:66)		#  angle for each frequency and stack
   angles[FreqToIndex(freq),st-61] = 
     if (WEIGHTED) {
	 WeightedSum(
	   data[data[,1]==freq & data[,6]<SIG.CRIT & data[,7]==st,
		if (SYNC) c("sync","s_rads") else c("cohere","c_rads") ])
	} else
	 VectorSum(data[data[,1]==freq & data[,6]<SIG.CRIT & data[,7]==st,
		ifelse(SYNC, "s_rads", "c_rads")])

{
options(warn=-1)
cat("\t\t", AREA, round(rayleigh.test(as.circular(
		apply(angles[FreqToIndex(30):FreqToIndex(34), 2:5], 2, mean)
		# angles[FreqToIndex(32), 2:5]
		))$p.value, dig=3), "\n")
options(warn=0)
}

for (fr in 2:length(angles[,1])) {		# Skip 1st one
  for (st in 1:5)				# Remove discontinuities
      if (!is.na(angles[fr,st]) & !is.na(angles[fr-1,st])) {
         while ((angles[fr,st] - angles[fr-1,st]) >  pi)
            angles[fr,st] = angles[fr,st] - 2*pi
         while ((angles[fr,st] - angles[fr-1,st]) < -pi)
            angles[fr,st] = angles[fr,st] + 2*pi
         }
  }

par(las=2)
par(xpd=NA)
plot(1,0, xlim=c(LoX, 150), ylim=c(BOTTOM-pi/8,TOP), type='n',
        axes=F, if (LOG) log="x" else log="", xlab="", ylab="")

Xlab = seq(-.5,1.5,.5)
if (par()$mfg[2] == 1) {	# 1st column?
   axis(2, at=pi*Xlab, labels=180*Xlab)
   save = par(mgp=c(4,1,0))
   title(ylab="Vector angles")
   par(save)
  } else
   axis(2, at=pi*Xlab, labels=F)

if (par()$mfg[1] == par()$mfrow[1]) {	# bottom row?
   axis(1, at=if (par("xlog")) 2^(4:7) else (0:3)*50, labels=T)
   title(xlab="Frequency (Hz)")
  } else
   axis(1, at=if (par("xlog")) 2^(4:7) else (0:3)*50, labels=F)
par(xpd=F)
par(las=0)

for (st in 62:66)
   for (pies in -2:2)
      if ((max(angles[,st-61] + 2*pi*pies,na.rm=T) > BOTTOM) &&
          (min(angles[,st-61] + 2*pi*pies,na.rm=T) < TOP))
	if (SIG.CRIT < .5) {		# Do not smooth if eliminating segments
	   lines( BANDS.SEQ, angles[,st-61] + 2*pi*pies,
         	col=c("black","green","red","blue","purple")[st-61],
	 	lwd=5)
	  } else
	   lines(
	     lapply(lowess(BANDS.SEQ, angles[,st-61] + 2*pi*pies,
		    	   f=SMOOTH),
		   "[", FreqToIndex(14:128)),
         	col=c("black","green","red","blue","purple")[st-61],
	 	lwd=5)


polygon(c(20, 20, 38, 38, 20),
	c( BOTTOM,  TOP,  TOP,  BOTTOM,  BOTTOM),
	col=adjustcolor("gray",alpha.f=.4),
	border=NA)


if (LOOP) {
   title(main = paste0("\n", AREA, if (UNIT!="") paste0(" (units:", UNIT, ")")),
	 cex.main=1.4)
   title(main = paste("\n\n\n\nn=", CellCount), cex.main=.9)
 } else
   title(main = paste0(MONK, "  ", AREA, if (NEAR) paste0("+",NEAR),
                                                " (n=", CellCount, ")"))

if (all(par()$mfg[1:2] == par()$mfrow[1:2]))	# last panel?
   mtext(paste("Weighted / Smooth / Pvalue / Log / Sync:",
	   WEIGHTED, SMOOTH, ifelse(SIG.CRIT>=1, "all", SIG.CRIT), LOG, SYNC),
	 side=1, line=3, outer=T, adj=1, cex=.6)

# par(SavePar)
