# VectorAngleBar.r
# (-mc)

#   called by main

# Coherence vs synchrony: set below in the body of the code

WEIGHTED = T			# [T] Weight each angle by amplitude?
SIG.CRIT = 1.1 # 0.3 or .4	# P value (include only significant cells?)
COHERENCE = T			# [T] Coherence(T) or Synchrony (F)
PLOT.ARROWS = T

PLOT.TYPE = "VectorAngleBar"

# SavePar = par(oma=c(4,3,3,2), las=1, xpd=NA)

if (!exists("LOOP")) LOOP = F

library(circular)

VectorSum = function(p) {
	if (length(p) == 0) return(list(NA, 2))
	if (length(p) == 2) return(list(p[2], 2))
	p = p[!is.na(p[,1]),]
	if (length(p) == 0) return(list(NA, 2))
	if (length(p) == 2) return(list(p[2], 2))

	if (WEIGHTED) {
	   x = mean(p[,1] * cos(p[,2]), na.rm=T)		# Vector sum
	   y = mean(p[,1] * sin(p[,2]), na.rm=T)
	  } else {
	   x = mean(cos(p[,2]), na.rm=T)		# Vector sum
	   y = mean(sin(p[,2]), na.rm=T)
	   }
	{
	options(warn=-1)
	ttttt = rayleigh.test(as.circular(p[,2]))$p.value
	options(warn=0)
	if (PLOT.ARROWS)
	   ttttt = sqrt(x^2 + y^2)
	}
	return(list(atan2(y,x), ttttt))
	}



# colnames = c("freq","cohere","c_rads","sync","s_rads","pval","type","unit")

# Freqs = list(8:14, 16:28, 30:42, 66:128)	# Cheat: freqs not independent
# Freqs = list(8:14, 20:36, 66:150)	# Cheat: freqs not independent
# Freqs = list(8:22, 24:46, 54:66, 70:150 )	# Cheat: freqs not independent
Freqs = list(c(16,22,32), c(18,26,36))
FreqBins = length(Freqs)

stacks = list(62,63,64,65,66)
angles = matrix(NA, nrow=FreqBins, ncol=5)
colnames(angles) = stacks
rownames(angles) = Freqs

par(las=2)
par(xpd=NA)
plot(0,0, xlim=c(0,FreqBins*(length(stacks)+2)), ylim=1.1*c(-pi,pi), type='n',
     axes=F, xlab="", ylab="")

text(0:(FreqBins-1)*(length(stacks)+2)+length(stacks)/2,
      -pi-.5, 
	Freqs, adj=.5)

for (bin in 1:FreqBins) {
  segments((bin-1)*(length(stacks)+2) - 1, -pi+.5,
           (bin-1)*(length(stacks)+2) - 1,  pi-.5, lwd=1, col="gray")
  for (st in 1:length(stacks)) {
      temp =
	VectorSum(data[(data[,"freq"] %in% Freqs[[bin]]) & 
		       (data[,"type"] %in% stacks[[st]]) & 
		        data[,"pval"] < SIG.CRIT,
			if (COHERENCE) {
    			    c("cohere","c_rads")
			  } else
    			    c("sync",  "s_rads")])
      angles[bin, st] = temp[[1]]
      points((bin-1)*(length(stacks)+2) + st, temp[[1]],
	        bg = if (temp[[2]] < 0.05)
		        c("gray35","green","red","blue","purple")[st]
		      else
			NA,
		col = c("gray35","green","red","blue","purple")[st],
		pch=21, lwd=2, cex=2)

      if (PLOT.ARROWS) {
         XX  = (bin-1)*(length(stacks)+2) + st
         YY  = temp[[1]]
         XXX = temp[[2]] * cos(temp[[1]])
         YYY = temp[[2]] * sin(temp[[1]])
         arrows(XX + XXX, YY + YYY,
         	XX - XXX, YY - YYY)
         }
      }
  }

# midpoints = barplot(t(angles), beside=T, axes=F, border=NA,
#		col=c("gray35","green","red","blue","purple")[-3],
#		ylim=c(0,YLIM))
#text(midpoints, t(angles)+YLIM*.05,
#			 ifelse(c(t(signifs))<.01,  "**", 
#			 ifelse(c(t(signifs))<.05,  "*", "")), cex=1.5)
#text(colMeans(midpoints), max(angles)+YLIM*.1,
#			 ifelse(GroupSignif<.05,  "*", ""), col="red", cex=2)
if (par()$mfg[2] == 1) {                    # 1st column?
   axis(2, at=c(-pi,0,pi), labels=c("-180","0","180"))
   save = par(mgp=c(4,1,0))
   title(ylab="Vector angles")
   par(save)
  } else
   axis(2, at=c(-pi,0,pi), labels=F)

if (par()$mfg[1] == 2)                     	# bottom?
   title(xlab="Frequency (Hz)")
par(xpd=F)
par(las=0)


if (LOOP) {
   title(main = paste0("\n", AREA, if (UNIT!="") paste0(" (units:", UNIT, ")")),
	 cex.main=1.4)
   title(main = paste("\n\n\n\nn=", CellCount), cex.main=.9)
   # title(main = paste0("\n\n", AREA, "      [n=", CellCount, "]"))
 } else
   title(main = paste0(MONK, "  ", AREA, if (NEAR) paste0("+",NEAR),
                                                " (n=", CellCount, ")"))
# par(SavePar)
