# VectorAngleArrow.r
# (-mc)

#   called by main

# Coherence vs synchrony: set below in the body of the code

WEIGHTED = T			# [T] Weight each angle by amplitude?
SIG.CRIT = 1.1 # 0.3 or .4	# [1.1] P value (include only sig cells?)
COHERENCE = T			# [T] Coherence(T) or Synchrony (F)
SCALE = 30 			# [30]

PLOT.TYPE = "VectorAngleTarget"

if (!exists("LOOP")) LOOP = F

library(circular)

VectorSum = function(p) {
	if (length(p) == 0) return(list(NA, 2))
	if (length(p) == 2) return(list(p[2], 2))
	p = p[!is.na(p[,1]),]
	if (length(p) == 0) return(list(NA, 2))
	if (length(p) == 2) return(list(p[2], 2))

	if (WEIGHTED) {
	   x = mean(p[,1] * cos(p[,2]), na.rm=T)		# Vector sum
	   y = mean(p[,1] * sin(p[,2]), na.rm=T)
	  } else {
	   x = mean(cos(p[,2]), na.rm=T)		# Vector sum
	   y = mean(sin(p[,2]), na.rm=T)
	   }
	return(list(atan2(y,x), sqrt(x^2+y^2)))
	}



# colnames = c("freq","cohere","c_rads","sync","s_rads","pval","type","unit")

Freqs = c(16,22,32)		# just one band of them

stacks = list(62,63,64,65,66)

plot(0,0, xlim=c(-1,1), ylim=c(-1,1), type='n', pty='s',
     axes=F, xlab="", ylab="")

for (st in 1:length(stacks)) {
      temp = VectorSum(data[(data[,"freq"] %in% Freqs) & 
		            (data[,"type"] %in% stacks[[st]]) & 
		             data[,"pval"] < SIG.CRIT,
			if (COHERENCE) {
    			    c("cohere","c_rads")
			  } else
    			    c("sync",  "s_rads")])

      XXX = SCALE * temp[[2]] * cos(temp[[1]])
      YYY = SCALE * temp[[2]] * sin(temp[[1]])
      arrows( XXX,  YYY,
         	-XXX, -YYY,
		col = c("gray35","green","red","blue","purple")[st],
		length=.07, lwd=4)
      }


if (LOOP) {
   title(main = paste0("\n", AREA, if (UNIT!="") paste0(" (units:", UNIT, ")")),
	 cex.main=1.4)
   title(main = paste("\n\n\n\nn=", CellCount), cex.main=.9)
   # title(main = paste0("\n\n", AREA, "      [n=", CellCount, "]"))
 } else
   title(main = paste0(MONK, "  ", AREA, if (NEAR) paste0("+",NEAR),
                                                " (n=", CellCount, ")"))
mtext(paste(if (WEIGHTED) "weighted",
	    if (COHERENCE) "coherence" else "synchrony",
	    if (SCALE) paste0("Scale=", SCALE),
	    if (SIG.CRIT < 1.05) paste0("Sig=",SIG.CRIT)),
      	side=1, line=3, outer=T, adj=1)
