# VectorAngle.r
# (-mc)

#   called by main

# Coherence vs synchrony: set below in the body of the code

WEIGHTED = T		# [T] Weight each angle by amplitude(T) or no (F) ?
SIG.CRIT = 1 		# [1] P value (include only significant cells?)
			#     If '1', means accept all !!
LOG = T			# [T]
SYNC = F		# [F] Use synchrony(T) or coherence(F)?
SMOOTH = .08		# [.0] Bypass if SIG.CRIT < .5

BOTTOM = -pi/2 - pi/16
TOP = 3*pi/2

PLOT.TYPE = "VectorAngle"

# SavePar = par(oma=c(4,3,3,2), las=1, xpd=NA)

if (SYNC == F & SIG.CRIT != 1)
   warning("No P value for coherence!  Using sync p value")

if (!exists("LOOP")) LOOP = F

library(circular)

LoX = if (LOG) 14 else 0

VectorSum = function(p) {
	p = p[!is.na(p)]
	if (length(p) < 2) return(NA)
	return(atan2(mean(sin(p)), mean(cos(p))))
	}

WeightedSum = function(p) {
	if (length(p) < 6) return(NA)
	p = p[!is.na(p[,2]),]
	if (length(p) < 6) return(NA)

	x = mean(p[,1] * cos(p[,2]), na.rm=T)		# Vector sum
	y = mean(p[,1] * sin(p[,2]), na.rm=T)
	return(atan2(y,x))
	}

# colnames = c("freq","cohere","c_rads","sync","s_rads","pval","type","unit")

angles = matrix(NA, nrow=length(BANDS.SEQ), ncol=5)

FreqToIndex = function(freq) return(which(BANDS.SEQ %in% freq))
IndexToFreq = function(index) return(BANDS.SEQ[index])

for (freq in unique(data[,1]))	# Average over each site to get a single
 for (st in 62:66)		#  angle for each frequency and stack
   angles[FreqToIndex(freq),st-61] = 
     if (WEIGHTED) {
	 WeightedSum(
	   data[data[,1]==freq & data[,6]<SIG.CRIT & data[,7]==st,
		if (SYNC) c("sync","s_rads") else c("cohere","c_rads") ])
	} else
	 VectorSum(data[data[,1]==freq & data[,6]<SIG.CRIT & data[,7]==st,
		ifelse(SYNC, "s_rads", "c_rads")])

{
options(warn=-1)
cat("\t\t", AREA, round(rayleigh.test(as.circular(
		apply(angles[FreqToIndex(30):FreqToIndex(34), 2:5], 2, mean)
		# angles[FreqToIndex(32), 2:5]
		))$p.value, dig=3), "\n")
options(warn=0)
}

for (fr in 2:length(angles[,1])) {		# Skip 1st one
  for (st in 1:5)				# Remove discontinuities
      if (!is.na(angles[fr,st]) & !is.na(angles[fr-1,st])) {
         while ((angles[fr,st] - angles[fr-1,st]) >  pi)
            angles[fr,st] = angles[fr,st] - 2*pi
         while ((angles[fr,st] - angles[fr-1,st]) < -pi)
            angles[fr,st] = angles[fr,st] + 2*pi
         }
  }

par(las=2)
par(xpd=NA)
plot(1,0, xlim=c(LoX, 150), ylim=c(BOTTOM-pi/8,TOP), type='n',
        axes=F, if (LOG) log="x" else log="", xlab="", ylab="")

Xlab = seq(-.5,1.5,.5)
if (par()$mfg[2] == 1) {	# 1st column?
   axis(2, at=pi*Xlab, labels=180*Xlab)
   save = par(mgp=c(4,1,0))
   title(ylab="Vector angles")
   par(save)
  } else
   axis(2, at=pi*Xlab, labels=F)

if (par()$mfg[1] == par()$mfrow[1]) {	# bottom row?
   axis(1, at=if (par("xlog")) 2^(4:7) else (0:3)*50, labels=T)
   title(xlab="Frequency (Hz)")
  } else
   axis(1, at=if (par("xlog")) 2^(4:7) else (0:3)*50, labels=F)
par(xpd=F)
par(las=0)

for (st in 62:66)
   for (pies in -2:2)
      if ((max(angles[,st-61] + 2*pi*pies,na.rm=T) > BOTTOM) &&
          (min(angles[,st-61] + 2*pi*pies,na.rm=T) < TOP))
	if (SIG.CRIT < .5) {		# Do not smooth if eliminating segments
	   lines( BANDS.SEQ, angles[,st-61] + 2*pi*pies,
         	col=c("black","green","red","blue","purple")[st-61],
	 	lwd=5)
	  } else
	   lines(
	     lapply(lowess(BANDS.SEQ, angles[,st-61] + 2*pi*pies,
		    	   f=SMOOTH),
		   "[", FreqToIndex(14:128)),
         	col=c("black","green","red","blue","purple")[st-61],
	 	lwd=5)


polygon(c(20, 20, 38, 38, 20),
	c( BOTTOM,  TOP,  TOP,  BOTTOM,  BOTTOM),
	col=adjustcolor("gray",alpha.f=.4),
	border=NA)


if (LOOP) {
   title(main = paste0("\n", AREA, if (UNIT!="") paste0(" (units:", UNIT, ")")),
	 cex.main=1.4)
   title(main = paste("\n\n\n\nn=", CellCount), cex.main=.9)
 } else
   title(main = paste0(MONK, "  ", AREA, if (NEAR) paste0("+",NEAR),
                                                " (n=", CellCount, ")"))

if (all(par()$mfg[1:2] == par()$mfrow[1:2]))	# last panel?
   mtext(paste("Weighted / Smooth / Pvalue / Log / Sync:",
	   WEIGHTED, SMOOTH, ifelse(SIG.CRIT>=1, "all", SIG.CRIT), LOG, SYNC),
	 side=1, line=3, outer=T, adj=1, cex=.6)

# par(SavePar)
