# SyncVsFreqPlot.r

#   Specify AREA here or on the command line!

# AREA = 2		# 1:P-P  2:P*-L  3:P*-L(X)  4:L-L  5:L*-P  6:L*-P(X)
TYPE = 62		# 62:Saccade  63:Ipsi  64:Contra  65:Same  66:Apart
YLIM = 50
LOWESS = 0.16		# [.16] Defeat with small non-zero value (e.g. 0.001)
MELD.UNI = F

PAIRED_COMPARISONS = F	# Special case (e.g., std vs remove evoked response)

coherent = Coherent
if (MELD.UNI==T) {	# Directory, area, frequency, type
   coherent[,,,2] = (coherent[,,,2]+coherent[,,,3])/2
   coherent[,,,3] = NA
   }

if (TYPE > 61)
   TYPE = TYPE - 61

X = as.numeric(dimnames(coherent)$Freq)

AREA.NAMES =	c("PRR", "PRR* - LIP (one side)", "PRR* - LIP (crossed X2)", 
	          "LIP", "LIP* - PRR (one side)", "LIP* - PRR (crossed X2)")

par(las=1)
plot(X, coherent[1,2,,1], log="x", ylim=c(0,YLIM), type='n', 
     xlab="Freq (Hz)",
     ylab="Coherent cells (%)")

if (PAIRED_COMPARISONS) {
   for (i in 1:(DirL/2))
    # for (j in 1:6) {
    for (j in 2) {
       lines(X, 100*coherent[2*i,j,,]/TotalCells[2*i,j], lwd=1,lty=2, col=i)
       lines(X, 100*coherent[2*i-1,  j,,]/TotalCells[2*i-1,j], lwd=3, col=i)
       }
   title(main=paste("Compare using", AREA.NAMES[AREA]))
   legend("topright",
	  legend = Directories,
	  col=rep(1:DirL, each=2),
	  lty = ifelse((1:DirL)%%2, "solid", "dotted"),
	  cex = ifelse(DirL > 6, .6, .8),
	  lwd = ifelse(DirL > 6,  3,  2))
} else
if (DirL==1 & TypeL==1) {		# All{GoCue,Target} and ONE directory
   for (A in 1:6)
       lines(lowess(X, 100*coherent[1,A,,1]/TotalCells[1,A], f=LOWESS), 
	     	col = c("black", "green", "red", "blue", "purple", "orange")[A],
	        lwd = 3)
   title(main=Directories)
   legend("topright",
	  legend = AREA.NAMES,
	  col = c("black", "green", "red", "blue", "purple", "orange"),
	  lwd=3)
} else
if (DirL>1 & TypeL==1) {		# All{GoCue,AllTarget}, many dirs
   for (i in 1:DirL)
      lines(lowess(X, 100*coherent[i,AREA,,1]/TotalCells[i,AREA], f=LOWESS), 
	 col=c("black","green","red","blue","purple","orange","cyan")
	 		[ 1 + ((i-1)%%7)],
	    lty = 1 + 2*(i-1) %/% 7,
	    lwd = 3)
   title(main=paste(AREA, AREA.NAMES[AREA]))
   legend("topright",
	  legend = 
	      Directories,			# General case; specials follow
	      # c("Pre-target", "Target", "Delay", "Movement", "Longest"),
	  col=c("black","green","red","blue","purple","orange","cyan"),
	  lty = rep(c(1,3,5,7), each=7),
	  cex = ifelse(DirL > 6, .6, .8),
	  lwd = c(rep(3,7), rep(1,50)))		# 7 thick, the rest thin
} else
if (DirL==1 & TypeL>1) {		# One directory, many types
   for (ty in 1:TypeL)
      lines(lowess(X, 100*coherent[1,AREA,,ty]/TotalCells[1,AREA], f=LOWESS), 
	     	col = c("black", "green", "red", "blue", "purple")[ty],
	        lwd = 3)
   title(main=paste(Directories, AREA.NAMES[AREA]))
   legend("topright",
	  legend = c("Saccade", "Ipsi", "Contra", "Same", "Apart")[
				   if (MELD.UNI==T) -3 else T],
	  col = c("black", "green", "red", "blue", "purple")[
				   if (MELD.UNI==T) -3 else T],
	  lwd=3)
} else
if (DirL>1 & TypeL>1) {			# GoCue or AllTarget, one or many dirs
   for (i in 1:DirL)
      lines(lowess(X, 100*coherent[i,AREA,,TYPE]/TotalCells[i,AREA], f=LOWESS), 
	    col = c("black","green","red","blue","purple","orange","cyan")[i],
	    lty = ifelse(i>7, 2, 1),
	    lwd = 3)
   title(main= paste0(
	AREA, ": ", AREA.NAMES[AREA],
	"     ",
	c("Saccade", "Ipsi", "Contra", "Same", "Apart")[TYPE]
	))
   legend("topright",
	  legend = 
	      Directories,			# General case; specials follow
	      # c("Pre-target", "Target", "Delay", "Movement", "Longest"),
	  col = c("black","green","red","blue","purple","orange","cyan"),
	  # if more directories, use dashed line (see 'lines')
	  lwd=3)
} else
   stop("Should never see this")


segments(6, 1, 150, 1, lwd=2, lty="dotted", col="gray")

mtext(paste("Pvalue is", PVAL, "Minimum sync/cohere is", 
	    MINIMUM_SYNC, MINIMUM_COHERE),
      side = 1, line=-1.5, outer=T, adj=0.03, cex=.7) # , font=2)



if (names(dev.cur()) == "pdf") {
   dev.off()
   system(paste0("mv Rplots.pdf SyncVsFreq",
       if (TypeL>1) "Stacks",
       if (DirL>1 | TypeL>1)
	c("_PRR", "_PRRcross", "_PRRcrossX2",
	  "_LIP", "_LIPcross", "_LIPcrossX2")[AREA], ".pdf"))
  } else

dev.copy2pdf(file=paste0("SyncVsFreq",
       if (TypeL>1) "Stacks",
       if (DirL>1 | TypeL>1)
	c("_PRR", "_PRRcross", "_PRRcrossX2",
	  "_LIP", "_LIPcross", "_LIPcrossX2")[AREA], ".pdf"))
