# SyncVsFreq.r

PVAL = .01			# applies to synchrony
MINIMUM_SYNC = 0		# minimum effect size?
MINIMUM_COHERE = 0

PLOT = T			# T: call SyncVsFreqPlot.r
PLOT.AREA = 2

# Single directory
Directories = c("GoCue_-800:0ms")

if (1==2) {			# SHIFT set
   tcsh(
     "cd /data/coord/grab/spike-lfp/data/cohSpikeLFP;
     ls -d AllGoCue_-500:0ms_shift/shift_{-,}{30,25,20,15,10,5,0}",
     intern=T)

   ordr = as.numeric(sub(".*shift_", "", Directories))
   Directories = Directories[order(ordr)]
   }

# Testing effect of excluding evoked potential
if (1==2)			# Standard intervals
Directories = 
  c("AllTarget_-500:0ms", "AllTarget_-500:0ms_NoE",
    "AllGoCue_-1000:0ms", "AllGoCue_-1000:0ms_NoE",
    "AllGoCue_50:450ms",  "AllGoCue_50:450ms_NoE")

# Time series:
if (1==2)			# Standard intervals
Directories = c(
 "AllTarget_-500:0ms"		# AllTarget_-400:0ms
,"AllTarget_50:550ms"		# AllTarget_50:450ms
,"AllGoCue_-500:0ms"		# AllTarget_800:1200ms _800:1300ms
				# AllGoCue_-1600:0ms _-1000:0ms _-400:0ms
,"AllGoCue_50:450ms"		# AllGoCue_0:500ms
,"AllTarget_-500:1600ms"	# AllTarget_-500:1200ms AllGoCue_-1200:400ms
				# AllGoCue_-1600:400ms
)

if (1==2)
Directories = c(		# Short intervals
  "GoCue_-400:-200ms"   	# -300
 ,"GoCue_-300:-100ms"   	# -200
 ,"GoCue_-200:0ms"      	# -100
 ,"GoCue_-100:100ms"	   	#    0
 ,"GoCue_0:200ms"        	#  100
 ,"GoCue_100:300ms"        	#  200
 ,"GoCue_200:400ms"        	#  300
 ,"GoCue_200:400ms"        	#  300
 )
if (1==2)
Directories = c(		# Short intervals
"AllGoCue_-500:-350ms", 
"AllGoCue_-450:-300ms","AllGoCue_-400:-250ms","AllGoCue_-350:-200ms",
"AllGoCue_-300:-150ms","AllGoCue_-250:-100ms","AllGoCue_-200:-50ms", 
"AllGoCue_-150:0ms",   "AllGoCue_-100:50ms",  "AllGoCue_-50:100ms",  
"AllGoCue_0:150ms",    "AllGoCue_50:200ms",   "AllGoCue_100:250ms",  
"AllGoCue_150:300ms",  "AllGoCue_200:350ms",  "AllGoCue_250:400ms",  
"AllGoCue_300:450ms",  "AllGoCue_350:500ms",  "AllGoCue_400:550ms")

# *** STACK-SPECIFIC EFFECTS ***
#	PRR*-LIP: strong, splay out at diff freq 
#	     (lowest: sac, then contra, ipsi, bimanuals)
#	LIP*-PRR: weaker effects in saccade!
#	PRR-PRR: weak effects

#  Directories = "GoCue_-1000:0ms"	# BEST: Nicer stack-specific effects
#  Directories = "Target_-500:0ms"	# Pre-targ control: non-specific

### "Target_50:1450ms"			  # Stronger overall, less specific
### "Target_50:1300ms"			  # bad

# *** AREA-SPECIFIC EFFECTS ***
#		PRR*-LIP strong; also 1:PRR; even 5:LIP*-PRR at lower freq!
#  Directories =  "AllTarget_-500:1600ms"	  # Use for clearest effects
#  Directories = "AllTarget_250:1250ms"		  # Use for DELAY period 
### Directories = "AllTarget_50:1450ms"		  # Similar
### Directories = "AllGoCue_-1000:0ms"		  # Weaker

### "AllGoCue_-500:0ms"		  # Still weaker
### "AllTarget_-500:1200ms"		  # Similar - not quite as good
### "AllGoCue_-1600:400ms"		  # Similar, but not as good
### "AllGoCue_-1000:0ms"		  # Similar, but even worse
### "AllGoCue_-1200:400ms"		  # Not too good


 # system(
 # "cd /data/coord/grab/spike-lfp/data/cohSpikeLFP;
 # ls -d AllGoCue_-1000:0_shuffle*",
 # intern=T)

			
NEAR = NEAR.OVERRIDE =  2
MONK = MONK.OVERRIDE = "both"		# both, zen, tyr
#################################################################

Areas = c("PRR","cross","crossX2","LIP", "cross","crossX2")
Units = c(  "",  "PRR",   "PRR",   "",    "LIP",  "LIP")

# Never do these - just inherited
NORMALIZE = F			# [F] Any normalization?
NORMALIZE.TO.BASELINE = F	# [F] specific to non-target alignment

DirL = length(Directories)

FirstTime = T

for (dir in 1:DirL) {
   DIR.OVERRIDE = Directories[dir]

   for (area in 1:6) {
      AREA = AREA.OVERRIDE = Areas[area]
      UNIT = UNIT.OVERRIDE = Units[area]
 
      FilesToDo = NULL		# Ensure these are global variables
      MonksToDo = NULL
      source("Select.r")
      MonksToDo = MonksToDo[!grepl("_96[78]", FilesToDo)]
      FilesToDo = FilesToDo[!grepl("_96[78]", FilesToDo)]
         # Maybe should also get 870.1, 871.1, 919.2
      source("ReadAll.r")
      
      if (FirstTime) {
         Types = sort(unique(data[,"type"]))
         TypeL = length(Types)
	 Freqs = sort(unique(data[,"freq"]))
         FreqL = length(Freqs)

	 Coherent = array(NA, dim=c(DirL,  6, FreqL,    TypeL),
     	   dimnames=list(Dirs=Directories, Area=Areas, Freq=Freqs, Type=Types))
	 # Type is stacks or classes; might be only one type (if -mc -ms)
	 # Areas is PRR, cross, cross2, LIP, cross, cross2
	 TotalCells = matrix(NA, nrow=DirL, ncol=6)
	 rownames(TotalCells) = Directories
	 colnames(TotalCells) = Areas

	 FirstTime = F
         }

      TotalCells[dir, area] = CellCount

      for (freq in 1:FreqL)
        for (type in 1:TypeL)		# Usually stacks, but could be classes
           Coherent[dir,area,freq,type] = 
		sum(data[,"freq"]==Freqs[freq] & 
		    data[,"pval"] < PVAL & 
		    data[,"sync"] > MINIMUM_SYNC &	# Minimum effect size?
		    data[,"cohere"] > MINIMUM_COHERE &
		    data[,"type"]==Types[type])
      }
   }

CoherentMeans = apply(Coherent, c(2,3,4), mean)

if (PLOT) {
    AREA = PLOT.AREA
    source("SyncVsFreqPlot.r")
    }
