# SyncTimePlot_grant.r 

PVAL = .01 
YLIM =  50 
LOWESS = 0				# 0 or F == off

REREAD = T			# [T]  F: Much faster if just changing plot
AVERAGE_OVER_PAIRING = F	# [F]  T: 1 line/task, avg'd over all pairs
JUST_ONE_PAIRING = 0		# [0]  2: 1 line/task, for just specified pair
				#      ("pair" means PRR-PRR, PRR-LIP, etc)
SACONLY = 1
MIXED2 = 0

DO_LINES = c(2,5)		# F, c(1,3:4,6), 1:6

#	With 150 ms of data, can do 34 Hz
# Freqs = list(4:6, 8:14, 16:28, 30:42, 66:128)	# Test diff frequencies

Lowess = function(x, y, f) if (f > 0) lowess(x,y,f) else return(list(x=x,y=y))
if (DO_LINES[1] == F)
    DO_LINES = 1:6


if (REREAD) {

# May be overwritten below!
X = c(-125,-25,75,125,175,225,275,325,375)
Freqs = list(36:46)
Freqs = list(34:38)
OFFSET = 0

if (1==1) {					# Standard time range (500 ms)
 Directories = c( 
		 # "Target_-500:0ms",
		 "Target_50:550ms",
		 "Target_800:1300ms",
		 "",
		 "GoCue_-500:0ms",
		 "Saccade_-500:0ms_NoE",
		 "Saccade_-50:450ms_NoE"
		 )
  Empty = Directories == ""
  Directories = paste0(ifelse(SACONLY, "All", "All-sac"), Directories)
  Directories[Empty] = ""
     
  OFFSET = 2000
  X = c(# -250,
	300,1050, NA, OFFSET-500, OFFSET-250, OFFSET+225)	#    Uses both alignments
  Freqs = list(30:36, 50:70)			# Good for -mc
  Freqs = list(32:36)
  Freqs = list(28:32, 62:80)			# Good for -mc
  Freqs = list(34:36)				# Highest for SACONLY
  Freqs = list(32:40)				# Better for saconly than 28:32
  Freqs = list(28:32)				# Used generally (for grant!)

} else if (1==2) {				# Alternate time range (400 ms)
 Directories = c("AllTarget_-400:0ms",
		"AllTarget_50:450ms",
		"AllTarget_800:1200ms",
		"",
		"AllGoCue_-400:0ms",
		"AllGoCue_50:450ms"
		)
  OFFSET = 1500
  X = c(-200,250,1000, NA, OFFSET-200, OFFSET+250)	#    Uses both alignments
  Freqs = list(30:36, 50:70)			# Good for -mc
  Freqs = list(32:36)

} else if (1==2) {				# Movement time (all, 150 ms)
 Directories = c(
		 "AllGoCue_-500:-350ms",# -425
		 "AllGoCue_-450:-300ms",# -375
		 "AllGoCue_-400:-250ms",# -325
		 "AllGoCue_-350:-200ms",# -275
		 "AllGoCue_-300:-150ms",# -225
		 "AllGoCue_-250:-100ms",# -175
		 "AllGoCue_-200:-50ms",	# -125
		 "AllGoCue_-150:0ms",	# -75
		 "AllGoCue_-100:50ms",	# -25
		 "AllGoCue_-50:100ms",	#  25
		 "AllGoCue_0:150ms",	#  75
		 "AllGoCue_50:200ms",	# 125
		 "AllGoCue_100:250ms",	# 175
		 "AllGoCue_150:300ms",	# 225
		 "AllGoCue_200:350ms",	# 275
		 "AllGoCue_250:400ms",	# 325
		 "AllGoCue_300:450ms",	# 375
		 "AllGoCue_350:500ms",	# 425
		 "AllGoCue_400:550ms"	# 475
		)
  X = c(-425,-375,-325,-275,-225,-175,-125,-75,-25,
	  25,75,125,175,225,275,325,375,425,475)
  LOWESS = 0.25				# Set to 0.0001 to turn off (not 0)

} else if (1==2) {				# Movement time (200 ms)
 Directories = c(
		 "GoCue_-400:-200ms",	# -300
		 "GoCue_-300:-100ms",	# -200
		 "GoCue_-200:0ms",	# -100
		 "GoCue_-100:100ms",	#    0
		 "GoCue_0:200ms",	#  100
		 "GoCue_100:300ms",	#  200
		 "GoCue_200:400ms",	#  300
		 "GoCue_300:500ms",	#  400
		 "GoCue_400:600ms"	#  500
		)
  X = c(-300,-200,-100, 0, 100, 200, 300, 400, 500)
  LOWESS = 0.25				# Set to 0.0001 to turn off (not 0)

} else if (1==2) {			# Movement: saccade aligned, each task
 Directories = c(
		 "Saccade_-800:-500ms",
		 "Saccade_-700:-400ms",
		 "Saccade_-600:-300ms",
		 "Saccade_-500:-200ms",
		 "Saccade_-400:-100ms",
		 "Saccade_-300:0ms",
		 "Saccade_-200:100ms",
		 "Saccade_-100:200ms",
		 "Saccade_0:300ms",
		 "Saccade_100:400ms",
		 "Saccade_200:500ms",
		 "Saccade_300:600ms"
		 )
  X = c(-650,-550,-450, -350, -250, -150, -50, 50, 150, 250, 350, 450)

} else if (1==2) {			# Movement: sac aligned, avg over tasks
 Directories = c(
		 "AllSaccade_-800:-500ms",
		 "AllSaccade_-700:-400ms",
		 "AllSaccade_-600:-300ms",
		 "AllSaccade_-500:-200ms",
		 "AllSaccade_-400:-100ms",
		 "AllSaccade_-300:0ms",
		 "AllSaccade_-200:100ms",
		 "AllSaccade_-100:200ms",
		 "AllSaccade_0:300ms",
		 "AllSaccade_100:400ms",
		 "AllSaccade_200:500ms",
		 "AllSaccade_300:600ms"
		 )
  X = c(-650,-550,-450, -350, -250, -150, -50, 50, 150, 250, 350, 450)

} else if (1==2) {				# Split by side - no effect
 Directories = c("AllTarget_-500:0ms_RL",
		"AllTarget_50:550ms_RL",
		"AllTarget_800:1300ms_RL",
		"",
		"AllGoCue_-500:0ms_RL",
		"AllGoCue_0:500ms_RL"
		)
  OFFSET = 1600
  X = c(-250,300,1500, OFFSET-250, OFFSET+250)
  Freqs = list(30:36)				# Good for "RL" data

} else if (1==2) {				# Kluge: compare a bunch
 Directories = c("AllTarget_-500:1200ms"
		, "AllTarget_-500:1600ms"
		, ""
		, "AllGoCue_-1000:0ms"
		, "AllGoCue_-1600:0ms"
		, "AllGoCue_-1200:400ms"
		, "AllGoCue_-1600:400ms"
		)
 OFFSET = 1600
 X = c(-350, 200 , NA, 600, 1050, 1500, 1950)
 }

NEAR = NEAR.OVERRIDE =  2
MONK = MONK.OVERRIDE = "both"		# both, zen, tyr
if (SACONLY)
MONK = MONK.OVERRIDE = "tyr"
#################################################################


Pairs = c("PRR","cross","crossX2","LIP", "cross","crossX2")
Units = c(  "",  "PRR",   "PRR",   "",    "LIP",  "LIP")

# Never do these - just inherited
NORMALIZE = F			# [F] Any normalization?
NORMALIZE.TO.BASELINE = F	# [F] specific to non-target alignment

FreqL = length(Freqs)
DirL = length(Directories)

FirstTime = T

for (dir in 1:length(Directories)) {
   if (Directories[dir] == "")			# Insert line break?
       next
   DIR.OVERRIDE = Directories[dir]

   for (pair in DO_LINES) {
      if (SACONLY & (pair!=2 & pair!=5))
	 next
      AREA = AREA.OVERRIDE = Pairs[pair]	# 'AREA' used by Select.r
      UNIT = UNIT.OVERRIDE = Units[pair]	# Not used?
 
      FilesToDo = NULL		# Ensure these are global variables
      MonksToDo = NULL
      source("Select.r")
      MonksToDo = MonksToDo[!grepl("_96[78]", FilesToDo)]
      FilesToDo = FilesToDo[!grepl("_96[78]", FilesToDo)]
         # Maybe should also get 870.1, 871.1, 919.2
      source("ReadAll.r")
      if (length(data) < 300) next      

      if (FirstTime) {
         Types = sort(unique(data[,7]))	# Should do this only once, really!
         TypeL = length(Types)

	 MeanCoherent = array(0, dim=c(DirL,  6,          FreqL,      TypeL),
     	 dimnames=list(Dirs=Directories, Pair=Pairs, Freq=Freqs, Type=Types))
	 # Type is stacks or classes; might be only one type (if -mc -ms)
	 # Pairs is PRR, cross, cross2, LIP, cross, cross2
	 TotalCells = matrix(NA, nrow=DirL, ncol=6)
	 rownames(TotalCells) = Directories
	 colnames(TotalCells) = Pairs

	 FirstTime = F
         }

      TotalCells[dir, pair] = CellCount

      counts = matrix(NA, nrow=75, ncol=TypeL)

      for (freq in unique(data[,1]))
        for (type in 1:TypeL)		# Usually stacks, but could be classes
          counts[freq/2,type] = 
		sum(data[,1]==freq & data[,6]<PVAL & data[,7]==Types[type])

      if (TypeL==1) {
         for (fr in 1:FreqL)
            MeanCoherent[dir,pair,fr,1] = mean(counts[Freqs[[fr]]/2,], na.rm=T)
       } else {
         for (fr in 1:FreqL)
            MeanCoherent[dir,pair,fr,] = 
       				apply(counts[Freqs[[fr]]/2,], 2, mean,na.rm=T)
         }
      }
   }
}			# End of REREAD !!

Xlim = range(X, na.rm=T)
if (!any(X[!is.na(X)]<=0))
   Xlim = range(c(0,X), na.rm=T)

extend = (Xlim[2] - Xlim[1]) * .075
Xlim[2] = Xlim [2] + 50

par(las=1, xpd=T, mgp=c(2.7,1,0), oma=c(0,.5,0,0))
plot(1,1, xlim=Xlim, ylim=c(0,YLIM), xlab="Time (ms)",
     	ylab="Coherent pairs (%)", type="n", bty="n", axes=F,
	cex.axis=2, cex.lab=1.8, cex.main=2)

segments(0,0, 0, 20, lwd=2, lty="solid")
segments(0,1, OFFSET+250, 1, lwd=1, lty="dotted")
segments(OFFSET,0, OFFSET, 20, lwd=2, lty="solid")
Start = as.numeric(sub(":0ms", "", 
	    sub(".*_", "", 
		Directories[grepl(":0ms", Directories)])))
segments(Start,0, Start, 100, col="gray")

if (OFFSET != 0) {
   axis(1, at=c(0,X[X<(OFFSET-600)]), cex.axis=1.5, cex.lab=1.5)
   axis(1, at=X[X>(OFFSET-600)], labels=X[X>(OFFSET-600)]-OFFSET, cex.axis=1.5, cex.lab=1.5)
   axis(1, at=OFFSET, label=0, cex.axis=1.5, cex.lab=1.5)
   mtext("Target aligned", side=1, line=2.5, at=300, cex=1.5)
   mtext("Move aligned", side=1, line=2.5, at=OFFSET, cex=1.5)
 } else {
   axis(1, at=X)
   }

axis(2, at=c(0,YLIM/2,YLIM), cex.lab=1.5, cex.axis=1.5)


 for (ppp in DO_LINES)			# Pair
  for (fr in 1:FreqL)
   for (ttt in 1:TypeL) {		# more than one type?
      coherent = c(MeanCoherent[,ppp,fr,ttt])
      if (any(!is.na(coherent))) {
	 Sig = rep(0, DirL)
         options(warn=-1)
         for (ddd in 1:DirL)
	     if (!is.na(coherent[ddd]) & coherent[ddd] > 0)
	        Sig[ddd] = prop.test(coherent[ddd], 
				  TotalCells[ddd,ppp], p=.01)$p.value < .01
         options(warn=0)
	 if (JUST_ONE_PAIRING) {
	    if (ppp == JUST_ONE_PAIRING)
             lines(Lowess(X, coherent/TotalCells[,ppp]*100, f=LOWESS),
	       type='b', lwd=2,
	       col=ttt,				# Color: 'Pair'
	       bg = ifelse(Sig, ttt, NA),	# Fill if sig
	       pch=20+ttt, 			# Symbol: stack/class
	       lty=c(1,3,2,4:8)[fr])	# line type: frequency
	  } else
	 if (AVERAGE_OVER_PAIRING) {
            lines(Lowess(
	         X, 100*apply(MeanCoherent[,1:6,fr,ttt] / TotalCells, 1, mean),
		 f = LOWESS),
	       type='b', lwd=2,
	       col=ppp,				# Color: 'Pair'
	       pch=20+ttt, 			# Symbol: stack/class
	       lty=c(1,3,2,4:8)[fr])	# line type: frequency
	  } else
            lines(Lowess(X, coherent/TotalCells[,ppp]*100, f=LOWESS),
	       type='b', lwd=12,
	       col=ppp,				# Color: 'Pair'
	       bg = ppp,			# Fill if sig
	       pch=20+ttt, 			# Symbol: stack/class
	       lty=c(1,3,2,4:8)[fr])	# line type: frequency
	 }
      }

Pairs = c(  "PRR -> PRR (crossed)",    "PRR -> LIP  (same side)", 
	     "PRR -> LIP  (crossed)",   "LIP -> LIP   (crossed)", 
	     "LIP -> PRR (same side)", "LIP -> PRR (crossed)")

segments(min(X),PVAL*100, max(X),PVAL*100, lty="dotted")

mtext(paste(paste(range(Freqs[[1]]), collapse="-"), "Hz"),
      side=1, line=4, adj=1, cex=.8)

for (i in DO_LINES)
   text(OFFSET-530,   51-2.5*i,   Pairs[i], adj=0, cex=1.3, 
	col=switch(i, 1,2,3,4,"cyan", "magenta"))


title(main="Incidence of coherent spike-LFP pairs", cex.main=1.5)
# if (JUST_ONE_PAIRING == F)
#    title(main="\n\nCollapsed over tasks", cex.main=.7)


par(las=0, xpd=F)

mtext(paste0("PVAL:", PVAL, "   Lowess:", LOWESS,
	     if (AVERAGE_OVER_PAIRING) "  AVERAGE_OVER_PAIRING",
	     if (JUST_ONE_PAIRING) paste("  Just one pairing:", JUST_ONE_PAIRING)
      ), side=1, line=4, adj=0, cex=.6)
