# SyncTimePlot.r 

PVAL = .01 
YLIM =   8
LOWESS = 0			# 0 or F == off.  Does not like gaps in data!

REREAD = T			# [T]  F: Much faster if just changing plot
AVERAGE_OVER_AREAS = F		# [F]  T: 1 line/task, avg'd over all areas
JUST_ONE_AREA = 0		# [0]  2: 1 line/task, for just specified area
				#      ("area" means PRR-PRR, PRR-LIP, etc)
SACONLY = T

#	With 150 ms of data, can do 34 Hz
# Freqs = list(4:6, 8:14, 16:28, 30:42, 66:128)	# Test diff frequencies
# Freqs = list(30:42)	# used elsewhere
Freqs = list(32:38)


Lowess = function(x, y, f) if (f > 0) lowess(x,y,f) else return(list(x=x,y=y))


if (REREAD) {

# May be overwritten below!
X = c(-125,-25,75,125,175,225,275,325,375)
OFFSET = 0
OFFSET2 = 0

if (1==2) {					# Standard time range (500 ms)
 Directories = c( "AllTarget_-500:0ms",
		"AllTarget_50:550ms",
		"AllTarget_800:1300ms",
		"",
		"AllGoCue_-500:0ms",
		"AllGoCue_0:500ms"
		)
  OFFSET = 1500
  X = c(-250,
	300,1050, NA, OFFSET-250, OFFSET+250)	#    Uses both alignments
  Freqs = list(30:36, 50:70)			# Good for -mc
  Freqs = list(32:36)
  Freqs = list(28:32, 50:70)			# Good for -mc

} else if (1==2) {				# Alternate time range (400 ms)
 Directories = c("AllTarget_-400:0ms",
		"AllTarget_50:450ms",
		"AllTarget_800:1200ms",
		"",
		"AllGoCue_-400:0ms",
		"AllGoCue_50:450ms"
		)
  OFFSET = 1500
  X = c(-200,250,1000, NA, OFFSET-200, OFFSET+250)	#    Uses both alignments
  Freqs = list(30:36, 50:70)			# Good for -mc
  Freqs = list(32:36)

} else if (1==2) {				# Movement time (all, 150 ms)
 Directories = c(
		 "AllGoCue_-500:-350ms",# -425
		 "AllGoCue_-450:-300ms",# -375
		 "AllGoCue_-400:-250ms",# -325
		 "AllGoCue_-350:-200ms",# -275
		 "AllGoCue_-300:-150ms",# -225
		 "AllGoCue_-250:-100ms",# -175
		 "AllGoCue_-200:-50ms",	# -125
		 "AllGoCue_-150:0ms",	# -75
		 "AllGoCue_-100:50ms",	# -25
		 "AllGoCue_-50:100ms",	#  25
		 "AllGoCue_0:150ms",	#  75
		 "AllGoCue_50:200ms",	# 125
		 "AllGoCue_100:250ms",	# 175
		 "AllGoCue_150:300ms",	# 225
		 "AllGoCue_200:350ms",	# 275
		 "AllGoCue_250:400ms",	# 325
		 "AllGoCue_300:450ms",	# 375
		 "AllGoCue_350:500ms",	# 425
		 "AllGoCue_400:550ms"	# 475
		)
  X = c(-425,-375,-325,-275,-225,-175,-125,-75,-25,
	  25,75,125,175,225,275,325,375,425,475)
  LOWESS = 0.25				# Set to 0.0001 to turn off (not 0)

} else if (1==2) {				# Movement time (200 ms)
 Directories = c(
		 "GoCue_-400:-200ms",	# -300
		 "GoCue_-300:-100ms",	# -200
		 "GoCue_-200:0ms",	# -100
		 "GoCue_-100:100ms",	#    0
		 "GoCue_0:200ms",	#  100
		 "GoCue_100:300ms",	#  200
		 "GoCue_200:400ms",	#  300
		 "GoCue_300:500ms",	#  400
		 "GoCue_400:600ms"	#  500
		)
  X = c(-300,-200,-100, 0, 100, 200, 300, 400, 500)
  LOWESS = 0.25				# Set to 0.0001 to turn off (not 0)

} else if (1==2) {			# Movement: saccade aligned, each task
 Directories = c(
		 "Saccade_-800:-500ms",
		 "Saccade_-700:-400ms",
		 "Saccade_-600:-300ms",
		 "Saccade_-500:-200ms",
		 "Saccade_-400:-100ms",
		 "Saccade_-300:0ms",
		 "Saccade_-200:100ms",
		 "Saccade_-100:200ms",
		 "Saccade_0:300ms",
		 "Saccade_100:400ms",
		 "Saccade_200:500ms",
		 "Saccade_300:600ms"
		 )
  X = c(-650,-550,-450, -350, -250, -150, -50, 50, 150, 250, 350, 450)

} else if (1==1) {			# Movement: sac aligned, avg over tasks

 OFFSET = 1600
 OFFSET2 = 2500
 Directories = c(
		 "AllTarget_-300:0ms",
		 "AllTarget_100:400ms",
		 "AllTarget_500:800ms",
		 "AllTarget_900:1200ms")
  X = c(-150,250,650,1050)

  if (OFFSET) {
     Directories = c(Directories,
		 "",
		 "AllGoCue_-300:0ms"
		 # "AllGoCue_0:300ms",		# 150
		 # "AllGoCue_200:500ms")	# 350
		 )
     X = c(X, NA, OFFSET + c(-150))
     }

  if (OFFSET2) {
     Directories = c(Directories,
		 "",
		 "AllSaccade_-500:-200ms",
		 "AllSaccade_-300:0ms",
		 "AllSaccade_0:300ms",
		 "AllSaccade_100:400ms"
		 # "AllSaccade_200:500ms"		# 350
		 )
     X = c(X, NA, OFFSET2 + c(-350, -150, 150, 250))
     }

} else if (1==2) {			# Movement: sac aligned, avg over tasks
 Directories = c(
		 "AllSaccade_-800:-500ms",
		 "AllSaccade_-700:-400ms",
		 "AllSaccade_-600:-300ms",
		 "AllSaccade_-500:-200ms",
		 "AllSaccade_-400:-100ms",
		 "AllSaccade_-300:0ms",
		 "AllSaccade_-200:100ms",
		 "AllSaccade_-100:200ms",
		 "AllSaccade_0:300ms",
		 "AllSaccade_100:400ms",
		 "AllSaccade_200:500ms",
		 "AllSaccade_300:600ms"
		 )
  X = c(-650,-550,-450, -350, -250, -150, -50, 50, 150, 250, 350, 450)

} else if (1==2) {				# Split by side - no effect
 Directories = c("AllTarget_-500:0ms_RL",
		"AllTarget_50:550ms_RL",
		"AllTarget_800:1300ms_RL",
		"",
		"AllGoCue_-500:0ms_RL",
		"AllGoCue_0:500ms_RL"
		)
  OFFSET = 1600
  X = c(-250,300,1500, OFFSET-250, OFFSET+250)
  Freqs = list(30:36)				# Good for "RL" data

} else if (1==2) {				# Kluge: compare a bunch
 Directories = c("AllTarget_-500:1200ms"
		, "AllTarget_-500:1600ms"
		, ""
		, "AllGoCue_-1000:0ms"
		, "AllGoCue_-1600:0ms"
		, "AllGoCue_-1200:400ms"
		, "AllGoCue_-1600:400ms"
		)
 OFFSET = 1600
 X = c(-350, 200 , NA, 600, 1050, 1500, 1950)
 }

NEAR = NEAR.OVERRIDE =  2
MONK = MONK.OVERRIDE = "both"		# both, zen, tyr
#################################################################


Areas = c("PRR","cross","crossX2","LIP", "cross","crossX2")
Units = c(  "",  "PRR",   "PRR",   "",    "LIP",  "LIP")

# Never do these - just inherited
NORMALIZE = F			# [F] Any normalization?
NORMALIZE.TO.BASELINE = F	# [F] specific to non-target alignment

FreqL = length(Freqs)
DirL = length(Directories)

FirstTime = T

for (dir in 1:length(Directories)) {
   if (Directories[dir] == "")			# Insert line break?
       next
   DIR.OVERRIDE = Directories[dir]

   for (area in 1:6) {
      AREA = AREA.OVERRIDE = Areas[area]
      UNIT = UNIT.OVERRIDE = Units[area]
 
      FilesToDo = NULL		# Ensure these are global variables
      MonksToDo = NULL
      source("Select.r")
      MonksToDo = MonksToDo[!grepl("_96[78]", FilesToDo)]
      FilesToDo = FilesToDo[!grepl("_96[78]", FilesToDo)]
         # Maybe should also get 870.1, 871.1, 919.2
      source("ReadAll.r")
      if (length(data) < 300) next      

      if (FirstTime) {
         Types = sort(unique(data[,7]))	# Should do this only once, really!
         TypeL = length(Types)

	 MeanCoherent = array(0, dim=c(DirL,  6,          FreqL,      TypeL),
     	 dimnames=list(Dirs=Directories, Area=Areas, Freq=Freqs, Type=Types))
	 # Type is stacks or classes; might be only one type (if -mc -ms)
	 # Areas is PRR, cross, cross2, LIP, cross, cross2
	 TotalCells = matrix(NA, nrow=DirL, ncol=6)
	 rownames(TotalCells) = Directories
	 colnames(TotalCells) = Areas

	 FirstTime = F
         }

      TotalCells[dir, area] = CellCount

      counts = matrix(NA, nrow=75, ncol=TypeL)

      for (freq in unique(data[,1]))
        for (type in 1:TypeL)		# Usually stacks, but could be classes
          counts[freq/2,type] = 
		sum(data[,1]==freq & data[,6]<PVAL & data[,7]==Types[type])

      if (TypeL==1) {
         for (fr in 1:FreqL)
            MeanCoherent[dir,area,fr,1] = mean(counts[Freqs[[fr]]/2,], na.rm=T)
       } else {
         for (fr in 1:FreqL)
            MeanCoherent[dir,area,fr,] = 
       				apply(counts[Freqs[[fr]]/2,], 2, mean,na.rm=T)
         }
      }
   }
}			# End of REREAD !!

Xlim = range(X, na.rm=T)
if (!any(X[!is.na(X)]<=0))
   Xlim = range(c(0,X), na.rm=T)

extend = (Xlim[2] - Xlim[1]) * .075
Xlim = Xlim + c(-extend, extend/3)

par(las=1, xpd=T, mgp=c(3,1,0))
plot(1,1, xlim=Xlim, ylim=c(0,YLIM), xlab="Time (ms)",
     	ylab="", type="n", bty="n", axes=F, font.lab=2)

par(las=1, xpd=T, mgp=c(2.5,1,0), font.lab=2)
title(ylab="Coherent pairs (%)")

segments(0,0, 0, YLIM/2, lwd=2, lty="solid")
if (OFFSET)
   segments(OFFSET,0, OFFSET, YLIM/2, lwd=2, lty="solid")
if (OFFSET2)
   segments(OFFSET2,0, OFFSET2, YLIM/2, lwd=2, lty="solid")
# Start = as.numeric(sub(":0ms", "", 
#	    sub(".*_", "", 
#		Directories[grepl(":0ms", Directories)])))
# segments(Start,0, Start, 100, col="gray")

if (OFFSET2 != 0) {
   axis(1, at=OFFSET2, label=0)			# Zero point
   axis(1, at=X[X>(OFFSET2-400)], 
       labels=X[X>(OFFSET2-400)]-OFFSET2)

   temp.x = X[(X>(OFFSET -350)) & (X<(OFFSET2-400)) & (!is.na(X))]
   if (min(temp.x) > OFFSET)
      temp.x = c(OFFSET, temp.x)
   if (max(temp.x) < OFFSET)
      temp.x = c(temp.x, OFFSET)
   axis(1, at=temp.x,
       labels=temp.x-OFFSET)
   axis(1, at=OFFSET, label=0)			# Zero point

   axis(1, at=c(0,X[X<(OFFSET-300)]))		# In case no points < 0
   mtext("Target aligned", side=1, line=2, at=300)
   mtext("Go cue aligned", side=1, line=2, at=OFFSET)
   mtext("Saccade aligned", side=1, line=2, at=OFFSET2)
 } else if (OFFSET != 0) {
   axis(1, at=c(0,X[X<(OFFSET-300)]))
   axis(1, at=X[X>(OFFSET-350)], labels=X[X>(OFFSET-350)]-OFFSET)
   axis(1, at=OFFSET, label=0)
   mtext("Target aligned", side=1, line=2.5, at=300)
   mtext("Go cue aligned", side=1, line=2.5, at=OFFSET)
 } else {
   axis(1, at=X)
   }

axis(2, at=c(0,YLIM/2,YLIM))


 for (aaa in 1:6)			# Area
  for (fr in 1:FreqL)
   for (ttt in 1:TypeL) {		# more than one type?
      coherent = c(MeanCoherent[,aaa,fr,ttt])
      if (any(!is.na(coherent))) {
	 Sig = rep(0, DirL)
         options(warn=-1)
         for (ddd in 1:DirL)
	     if (!is.na(coherent[ddd]) & coherent[ddd] > 0)
	        Sig[ddd] = prop.test(coherent[ddd], 
				  TotalCells[ddd,aaa], p=.01)$p.value < .01
         options(warn=0)
	 if (JUST_ONE_AREA) {
	    if (aaa == JUST_ONE_AREA)
             lines(Lowess(X, coherent/TotalCells[,aaa]*100, f=LOWESS),
	       type='b', lwd=2,
	       col=aaa,				# Color: 'area'
	       bg = ifelse(Sig, ttt, NA),	# Fill if sig
	       pch=20+ttt, cex=1.5,		# Symbol: stack/class
	       lty=c(1,3,2,4:8)[fr])	# line type: frequency
	  } else
	 if (AVERAGE_OVER_AREAS) {
            lines(Lowess(
	         X, 100*apply(MeanCoherent[,1:6,fr,ttt] / TotalCells, 1, mean),
		 f = LOWESS),
	       type='b', lwd=2,
	       col=aaa,				# Color: 'area'
	       pch=20+ttt, cex=1.5,		# Symbol: stack/class
	       lty=c(1,3,2,4:8)[fr])	# line type: frequency
	  } else
            lines(Lowess(X, coherent/TotalCells[,aaa]*100, f=LOWESS),
	       type='b', lwd=5,
	       col=aaa,				# Color: 'area'
	       bg = ifelse(Sig, aaa, NA),	# Fill if sig
	       pch=20+ttt, cex=1.5,		# Symbol: stack/class
	       lty=c(1,3,2,4:8)[fr])	# line type: frequency
	 }
      }

 Areas = c(  "PRR  - PRR (crossed)",    "PRR* - LIP  (same side)", 
	     "PRR* - LIP  (crossed)",   "LIP    - LIP   (crossed)", 
	     "LIP*   - PRR (same side)", "LIP*   - PRR (crossed)")

 segments(min(X,na.rm=T),PVAL*100, max(X,na.rm=T),PVAL*100, lty="dotted")

 atX = max(X, na.rm=T) * .8		# Fails if max(X) is negative!
 if (JUST_ONE_AREA & TypeL > 2) {
    bottom = 
     legend("topright",
        paste(Types, c("sac","uni L?","uni R?","both","apart")[Types-61]),
	lwd=3, cex=.8, pch=21:25, bty='n', col=1:5)$text$y[length(Types)]
    text(atX, bottom-YLIM*.15, Areas[JUST_ONE_AREA], adj=.5)
  } else if (JUST_ONE_AREA == F) {
    bottom =
     legend("topright", Areas, inset=-0.07,
	col=1:6, cex=1, lty=1, lwd=2, bty='n')$text$y[length(Areas)]
  } else {
    bottom = YLIM
    text(atX, YLIM, Areas[JUST_ONE_AREA], adj=.5)
    }

 if (FreqL > 1) {
   legend(atX, bottom-YLIM*.05, paste(Freqs, "Hz"),  
	lty=c(1,3,2,4:8)[1:FreqL],	# line type: frequency
	inset=-0.1,
	cex=1, col="red", lwd=3, bty='n')$text$y[length(Freqs)]
  } else
   text(atX, bottom-YLIM*.08, paste(Freqs, "Hz"), adj=.5)

 if (TypeL == 2) {
    legend("topleft", legend=c("Contra field", "Ipsi field"),
			col="red", pch=21:22, bty='n')
   } else if (TypeL > 2 & (JUST_ONE_AREA == F))
    legend("topleft", 
        paste(Types, c("sac","uni L?","uni R?","both","apart")[Types-61]),
	cex=.6, pch=21:25, bty='n', col="red")

title(main="Incidence of coherent spike-LFP pairs")
if (JUST_ONE_AREA == F)
   title(main="\n\nCollapsed over tasks", cex.main=.7)
if (length(JUST_ONE_AREA == 1))
   title(main=paste("\n\nJust ", Areas[JUST_ONE_AREA]), cex.main=.7)


par(las=0, xpd=F)

mtext(paste0("PVAL:", PVAL, "   Lowess:", LOWESS,
	     if (AVERAGE_OVER_AREAS) "  AVERAGE_OVER_AREAS",
	     if (JUST_ONE_AREA) paste("  Just one area:", JUST_ONE_AREA)
      ), side=1, line=3.5, adj=0, cex=.6)


if (1 == 2) {
cat("Compare PRR*-LIP(same) with LIP*-PRR(same), low freq, at baseline:",
    	#   Time,  area,  frequency (1st is 'lo'),  type (unused- just 1)
    round(prop.test(MeanCoherent[1,c(2,5),1,1], TotalCells[1,c(2,5)])$p.value,
	  dig=3),
    "\n")
cat("Compare PRR*-LIP(same) with LIP*-PRR(same), low freq, at target present:",
    round(prop.test(MeanCoherent[2,c(2,5),1,1], TotalCells[2,c(2,5)])$p.value,
	  dig=3),
    "\n")
cat("Compare PRR*-LIP(same) with LIP*-PRR(same), low freq, at delay:",
    round(prop.test(MeanCoherent[5,c(2,5),1,1], TotalCells[5,c(2,5)])$p.value,
	  dig=3),		# could do time 3 (targ-align) or 5 (go-align)
    "\n")
cat("\n")
cat("Compare PRR*-LIP(same) at start with delay:",
    round(prop.test(MeanCoherent[c(1,5),2,1,1], TotalCells[c(1,5),2])$p.value,
	  dig=3),		# could do 3 or 4
    "\n")
cat("Compare PRR*-LIP(same) at start with during movement:",
    round(prop.test(MeanCoherent[c(1,6),2,1,1], TotalCells[c(1,6),2])$p.value,
	  dig=3),		# could do 3 or 4
    "\n")
}
