# counts = matrix(scan("~/counts.temp", skip=1), byrow=T, ncol=4)
# colnames(counts) = c("unit", "stack", "class", "rate")

counts = matrix(scan("~/counts.temp", skip=1), byrow=T, ncol=6)
colnames(counts) = c("unit", "stack", "class", "rate", "SEM", "N")

args = scan("~/counts.temp", nlines=1, what="character")	# ARGS

args = strsplit(args, " ")				# Split into options
args = args[sapply(args, function(a) grepl("-i", a))]	# Get interval

args = substring(args, 3)				# strip "-i"
Interval = as.numeric(unlist(strsplit(args, ":")))	# get start, end in ms

spikes = counts[,4] * ((Interval[2] - Interval[1])/1000)	# rate -> spikes
spikes = spikes * counts[,"N"]				# across all trials

# plot(ecdf(spikes))

H = hist(spikes, breaks=0:(max(spikes)+1), plot=F)
plot(cumsum(H$counts))

print(quantile(spikes, c(10,15,20,25,33,50)/100))  # quantiles
