# VectorLength.r
# (-mc)

#   called by main

# Coherence vs synchrony: set below in the body of the code

METHOD = 1	# [1]	1:mean ampl -- clearly best!
		#	2:ampl-weighted vector sum  
		#	3:vector sum  -- very messy; no pattern (with SIG=1)
		#	4:percent signif cells
SIG.CRIT = 0		# [0] DO NOT USE! P value (include only sig cells?)
LOG = F			# [T]
SYNC = T		# [F] Use synchrony(T) or coherence(F)?
SMOOTH = .15		# [.15] Bypass if SIG.CRIT < .5

YLIM = switch(METHOD, .14, .05, .5, 20)		# See also below!
if (SIG.CRIT == 0 | SIG.CRIT == 1)		# Accept all?
    SIG.CRIT = 1.1
if (SIG.CRIT < .5)
   YLIM = YLIM * 3

PLOT.TYPE = "VectorLength"

# SavePar = par(oma=c(4,3,3,2), las=1, xpd=NA)

if (!exists("LOOP")) LOOP = F

library(circular)

LoX = if (LOG) 14 else 0

EffectSum = function(p, METHOD=METHOD) {		# Pass it an index
	if (sum(p,na.rm=T) < 6) return(NA)
	if (any(p[is.na(data[p,2])]))	# can't just set p[is.na(data[p,2])] = F
	   stop("Thought we fixed this - tricky issue; be careful!")
	if (sum(p) < 6) return(NA)

	if (METHOD == 1) {	# Scalar mean of amplitude; ignore direction
	   p = data[p, if (SYNC) "sync" else "cohere"]
	   return(mean(p))
	   }
	if (METHOD == 2) {	# Vector sum of directions weighted by amplitude
	   p = data[p, if (SYNC) c("sync","s_rads") else c("cohere","c_rads") ]
	   x = mean(p[,1] * cos(p[,2]), na.rm=T)
	   y = mean(p[,1] * sin(p[,2]), na.rm=T)
	   return(sqrt(x^2+y^2))
	   }
	if (METHOD == 3) {	# Vector sum of direction; ignore amplitude
	   p = data[p, ifelse(SYNC, "s_rads", "c_rads")]
	   return(sqrt(mean(sin(p))^2 + mean(cos(p))^2))
	   }
	if (METHOD == 4) {	# % significant cells
	   return(100*sum(data[p, "pval"]<.01) / sum(p))
	   }
	if (METHOD == 5) {	# pvalue
	   return(data[p, "pval"])
	   }
	stop("Unknown METHOD")
	}

# colnames = c("freq","cohere","c_rads","sync","s_rads","pval","type","unit")

lengths = matrix(NA, nrow=length(BANDS.SEQ), ncol=5)
lengths2 = matrix(NA, nrow=length(BANDS.SEQ), ncol=5)

FreqToIndex = function(freq) return(which(BANDS.SEQ %in% freq))
IndexToFreq = function(index) return(BANDS.SEQ[index])

Stacks = sort(unique(data[,7]))		# Different types (usually stacks)

par(las=2)
par(xpd=NA)
plot(0,0, xlim=c(0,1), ylim=c(0,8),
     xlab="coherence", ylab="-log(pvalue)")

par(xpd=F)
par(las=0)

for (st in 1:length(Stacks)) {
    Index = data[,1]==30 & 
	    data[,7]==Stacks[st] & 
    	    !is.na(data[,2])
     points(     data[Index, "cohere"],
	    -log(data[Index, "pval"]),
        	col=c("black","green","red","blue","purple")[st])
     }
segments(0,4.6,1,4.6)


if (LOOP) {
   title(main = paste0("\n", AREA, if (UNIT!="") paste0(" (units:", UNIT, ")")),
	 cex.main=1.4, font.main=2)
   title(main = paste("\n\n\n\nn=", CellCount), cex.main=.9)
 } else
   title(main = paste0(MONK, "  ", AREA, if (NEAR) paste0("+",NEAR),
                                           " (n=", CellCount, ")"))

if (all(par()$mfg[1:2] == par()$mfrow[1:2])) {	# last panel?
   mtext(paste0(
     METHOD, ": ",
     switch(METHOD, "Mean amplitude", "Weighted vector sum",
	    	    "Vector sum", "% Significant cells"),
     " of ", ifelse(SYNC, "synchrony", "'coherence'"),
     "; smoothed (", SMOOTH, "); ",
     ifelse(SIG.CRIT>=1, "all data", paste("just P>", SIG.CRIT))),
	 side=1, line=3, outer=T, adj=1, cex=.6, font=2)
   mtext("Saccade", col=1, side=3, line= 1.7, outer=T, adj=1, cex=.8, font=2)
   mtext("Ipsi",    col=2, side=3, line= 0.7, outer=T, adj=1, cex=.8, font=2)
   mtext("Contra",  col=3, side=3, line=-0.3, outer=T, adj=1, cex=.8, font=2)
   mtext("Together", col=4,side=3, line=-1.3, outer=T, adj=1, cex=.8, font=2)
   mtext("Apart", col="purple", side=3,line=-2.3,outer=T,adj=1,cex=.8,font=2)
         	# col=c("black","green","red","blue","purple")[st-61],
   }

# par(SavePar)
