# SignifSyncBar.r
# (-mc)

# Each frequency is treated separately, so even if there are only 10 cells,
# if there are 10 freq bands for the bar, there will be 100 gradiations in
# bar heights.

# SavePar = par(oma=c(4,3,3,2), las=1, xpd=NA)

SIG.GROUPED = 2	 # Asterisks = [1]sig per whole group  [0]indi stacks  [2]both
PVAL = .05
YLIM = 0.60*CellCount	# Does not use override; change if change Pvalue
MELD.UNI = T		# average together left & right arms (63 & 64) ?
Verbose = F		# Show time sequence for particular freq

Types = unique(data[,7])
TypeL = length(Types)

if (TypeL < 5)
   MELD.UNI = F

PLOT.TYPE = "SignifSyncBar"

if (!exists("LOOP")) LOOP = F

if (MELD.UNI & TypeL != 5)
    stop("Not written")

counts = matrix(NA, nrow=75, ncol=TypeL)
for (freq in unique(data[,1]))
  for (type in 1:TypeL) {	# Usually stacks, but could be classes
     counts[freq/2,type] = 
		sum(data[,1]==freq & data[,6]<PVAL & data[,7]==Types[type])
     if (Verbose)
      if (freq == 32) 
          cat("(", counts[freq/2,type], "): ",
              ifelse(data[data[,1]==32,6] < PVAL,"+","-")[order(files)], "\n",
	      sep="")	# Print row of +/- in chronological order
     }

# Average ipsi and contra arms (unimanual)?
if (MELD.UNI)
 for (freq in unique(data[,1])) {
    counts[freq/2,64-61] = mean(counts[freq/2,c(63-61,64-61)])
    counts[freq/2,63-61] = NA
    }

# Freqs = list(6:12, 8:16, 12:24, 16:32, 24:48, 32:64, 64:128)
# Freqs = list(6:16, 30:40, 64:128)
# Freqs = list(6:14, 16:28, 30:40, 66:128)
# Freqs = list(8:14, 16:30, 32:54, 66:128)		# octaves (skip 60±4)
# Freqs = list(8:10,12:16,18:22,24:32,34:46,48:62,64:90,92:128,128:150) # halves

Freqs = list(18:22,24:32,34:46,64:90,92:128) # halves

# WHAT WE USED FOR THE GRANT: (shifted from octaves)
# Freqs = list(c(8,14), c(16,28), c(30,42), c(66,128))	# more conservative
# Freqs = list(8, 16, 32, 64, 128)			# Most conservative
# Freqs = list(4:6, 8:14, 16:28, 30:42, 66:128)		# add low freq
# Freqs = list(8:14, 16:28, 30:42, 70:128)		# add low freq
# Freqs = list(16:28, 30:42, 70:128)
# Freqs = list(12:18,20:28, 30:40, 40:50, 70:110)	# Not bad ...

# Freqs = list(30,32,34,36,38,40,42)
# Freqs = list(34)
# Freqs = list(30:42)
#  single frequencies fail in multiple ways!
# Freqs = list(c(32,32))
# if (SACONLY)
#  Freqs = list(c(22,22), c(24,24), c(26,26), c(28,28), c(30,30), c(32,32),
#  	       c(34,34), c(36,36), c(38,38), c(40,40), c(42,42))
#Freqs = list(c(20,22), c(24,26), c(28,30), c(32,34), c(36,40), c(42,44))


Bins = length(Freqs)
MeanCounts = matrix(0, nrow=Bins, ncol=TypeL)
colnames(MeanCounts) = Types
rownames(MeanCounts) = Freqs

if (TypeL==1) {
   for (bin in 1:Bins)
      MeanCounts[bin] = mean(counts[Freqs[[bin]]/2,], na.rm=T)
				# Does not preserve matrix structure!
   if (is.na(MeanCounts[1])) {		# Drop the lowest bin if empty
      Freqs = Freqs[-1]			# You'd think [[-1]], but that fails!
      MeanCounts = MeanCounts[-1]
      }
   if (is.na(MeanCounts[1])) {		# Drop the 2nd-lowest bin if empty
      Freqs = Freqs[-1]
      MeanCounts = MeanCounts[-1]
      }
   MeanCounts = matrix(MeanCounts, ncol=1, byrow=T)	# Restore matrix
   Bins = length(Freqs)
   colnames(MeanCounts) = Types
   rownames(MeanCounts) = Freqs
 } else {
   for (bin in 1:Bins)
      MeanCounts[bin,] = apply(counts[Freqs[[bin]]/2,], 2, mean, na.rm=T)
   if (all(is.na(MeanCounts[1,]))) {	# Drop the lowest bin if empty
      Freqs = Freqs[-1]			# You'd think [[-1]], but that fails!
      Bins = length(Freqs)
      MeanCounts = MeanCounts[-1,]
      }
   if (all(is.na(MeanCounts[1,]))) {	# Drop the 2nd-lowest bin if empty
      Freqs = Freqs[-1]			# You'd think [[-1]], but that fails!
      Bins = length(Freqs)
      MeanCounts = MeanCounts[-1,]
      }
   }


if (MELD.UNI)
   MeanCounts = MeanCounts[,-2, drop=F]		# Keep 2nd dimension

Colors = if (MELD.UNI) {
	    c("gray35","green","blue","purple")
	    } else if (SACONLY>0 && SACONLY<3) { # 1 type->only uses 1st color
	     c("green","red", "blue","purple")
	   } else
	    c("gray35","green","red", "blue","purple")
StarColors = Colors
StarColors[StarColors=="gray35"] = "black"

if (!MELD.UNI) 
   StarColors[StarColors=="green"] = "green3"

if (SACONLY == 2) {
   MeanCounts = MeanCounts[,1, drop=F]
   TypeL = 1
   }

if (TypeL==1) {
   onefreq = substr(rownames(MeanCounts), 3, 4) == 
	     substr(rownames(MeanCounts), 7, 8)
   if (all(onefreq))
      if (TypeL==1)
          rownames(MeanCounts) =
                   substr(rownames(MeanCounts), 3, 4)
   }

par(las=2)
AtX = barplot(t(MeanCounts),
	beside=T, ylim=c(0,YLIM), axes=F, border=NA, 
	cex.names=ifelse(TypeL<3,.75,1),
	col = Colors)
par(las=1)

if (TypeL == 2)
   mtext("red is unit on contra side", side=1, line=3, outer=T, adj=0, cex=.7)

par(xpd=NA)
if (par()$mfg[2] == 1) {                    # 1st column?
   axis(2, at=YLIM*c(0,.5,1), labels=round(100*YLIM/CellCount*c(0,.5,1)))
   save = par(mgp=c(4-1.4*(SACONLY>0),1,0))
   title(ylab="Coherent pairs (%)")
   par(save)
  } else
   axis(2, at=YLIM*c(0,.5,1), F)

if (par()$mfg[1] == 2)                    	# 1st column?
   title(xlab="Frequency (Hz)")
par(xpd=F)

if (LOOP) {
   title(main = paste("\n", AREA), cex.main=1.4)
   title(main = paste("\n\n\n\nn=", CellCount), cex.main=.9)
   # title(main = paste0("\n\n", AREA, "      [n=", CellCount, "]"))
 } else
   title(main = paste0(MONK, "  ", AREA, if (NEAR) paste0("+",NEAR),
				                " (n=", CellCount, ")"))

# Show Pval% and area of non-sig counts
# abline(h=PVAL*CellCount, lty="dashed", lwd=2)
segments(0, PVAL*CellCount, 100, PVAL*CellCount, lty="dashed", lwd=2)

low  = 
high = CellCount * PVAL		# to use binom test, round to int

OptSave = options(warn=-1)
if (CellCount > 1) {
while (prop.test(high,CellCount,p=PVAL,alt="g")$p.value >= PVAL)
   high = high + .25	# prop test can be fractional - binom cannot
while (prop.test(low,CellCount,p=PVAL,alt="g")$p.value >= PVAL) {
   low = low - .25
   if (low <= 0) break
   }
}
options(OptSave)

polygon(c(0,150,150,0),
	c(low,low,high,high), 
	border=F,
	col=adjustcolor("gray", alpha.f=.3))
segments(0,high, 150,high, lwd=.5)


mtext(paste("P=",PVAL), side=3, outer=T, line=-(SACONLY>0), adj=1, cex=.8)
par(xpd=NA)
if (SIG.GROUPED) {
   options(warn=-1)
   for (bin in 1:Bins) {
     if (!any(is.na(MeanCounts[bin,])))
      if (CellCount > 3)
       if (prop.test(sum(MeanCounts[bin,]), # binom.test won't take fractions
		    TypeL*CellCount,	# mean counts can be fractional
		    p=PVAL, alt='g')$p.value<PVAL)
           text(mean(AtX[,bin]), max(MeanCounts[bin,])+2*YLIM/15,"*",cex=2)
     #cat(prop.test(sum(MeanCounts[bin,]), # binom.test won't take fractions
     #		    TypeL*CellCount,	# mean counts can be fractional
     #		    p=PVAL, alt='g')$p.value, "\n")
     }
   options(OptSave)
   }
if (SIG.GROUPED != 1) {
   for (bin in 1:Bins) {
      text(AtX[,bin], max(MeanCounts[bin,])+YLIM/15,
	   ifelse(MeanCounts[bin,]>high,"*",""),
	   cex=2, 
	   col = if (SACONLY>0 && SACONLY<3) StarColors[bin] else StarColors)
    if (any(MeanCounts[bin,] < low))
       cat("Wow - others are significantly LESS than expected!\n")
    }
   }
par(xpd=F)

# par(SavePar)
