# SignifSync.r
#   How many individual cells (fraction) show signif coherence?
# (-mc)

#   called by main

# DIAG: On 2/16/2018, added 'STACKS' and 'STACKS.OFFSET' so sac_only data
#  will show up; didn't test on full stack dataset!

# SavePar = par(oma=c(4,3,3,2), las=1, xpd=NA)

PVAL = .05
YLIM = if (exists("YLIM.OVERRIDE")) YLIM.OVERRIDE*CellCount else CellCount/4
MELD.UNI = F				# Combine left & right arms?
LOG = T

PLOT.TYPE = "SignifSync"

if (!exists("LOOP")) LOOP = F

LoX = if (LOG) 4 else 0

plot(1,0, xlim=c(LoX,150), ylim=c(0,YLIM), if (LOG) log="x",
        ylab=ifelse(LOOP,"","cells"), xlab=ifelse(LOOP,"","Freq (Hz)"),
     	type='n', axes=F)

if (LOOP) {
   title(main = paste0("\n", AREA, 
		      if (UNIT!="") paste0("  (units:", UNIT, ")"),
		      "  [n=", CellCount, "]"))
 } else
   title(main = paste0(MONK, "  ", UNIT, AREA, if (NEAR) paste0("+",NEAR),
		" (n=", CellCount, ")"))

axis(1, at=if (par("xlog")) 2^(2:7) else (0:3)*50, labels=!LOOP)
axis(2, at=YLIM*c(0,.5,1), labels=!LOOP)

STACKS = sort(unique(data[,"type"]))
STACK.OFFSET = min(STACKS)-1

counts = matrix(NA, nrow=75, ncol=5)
for (freq in unique(data[,1]))
  for (st in STACKS)
      counts[freq/2,st-STACK.OFFSET] = 
		sum(data[,1]==freq & data[,6]<PVAL & data[,7]==st)

# Average ipsi and contra arms (unimanual) -- assumes all stacks are there!
if (MELD.UNI) {
   for (freq in unique(data[,1])) {
      counts[freq/2,64-61] = mean(counts[freq/2,c(63-61,64-61)])
      counts[freq/2,63-61] = NA
      }
   }

for (st in STACKS) {
   lines( lowess(BANDS.SEQ,	# f=.1: bad edge effects esp for log version
   	         counts[BANDS.SEQ/2,st-STACK.OFFSET], f=0.07), #.1 or .15),
	 col=c("black","green","red","blue","purple")[st-STACK.OFFSET],
	 lwd=5)
   }

# Show Pval% and area of non-sig counts
abline(h=PVAL*CellCount, lty="dashed", lwd=2)

high = round(CellCount * PVAL)

options(warn=-1)
while (prop.test(high,CellCount,p=PVAL)$p.value >= PVAL)
   high = high + 1
options(warn=0)

low = ifelse(CellCount < 92,  0, 
      ifelse(CellCount < 126, 1,
      ifelse(CellCount < 157, 2,
      ifelse(CellCount < 186, 3,
      ifelse(CellCount < 215, 4,
      ifelse(CellCount < 242, 5, 6))))))

polygon(c(LoX,150,150,LoX),
	c(low,low,high,high), 
	border=F,
	col=adjustcolor("gray", alpha.f=.4))

# par(SavePar)
