# ReadAll.r   Read in all the data

#  Called by main.r

verbose = F
directory = "Target_550:1300ms"	# "Target_0:1000ms","Target_550:1300ms"

if (exists("DIR.OVERRIDE"))
   directory = DIR.OVERRIDE
if (!exists("SACONLY"))
   SACONLY = F
if (!exists("MIXED2"))
   MIXED2 = F

# For LFP-LFP, PRR-PRR and crossX2, the class distinction depends on which
# For cross, do standard flip (written).

FLIP = 1	# 0: do not  1: by spike  2: by LFP  (2 is not used?)
	# Stacks: started recording on LEFT so left (stk 63) = ipsi arm
	#	  Flip STACKS if recorded on right
	# Classes named for RIGHT arm, so flip CLASSES if record on RIGHT

# if (MONK=="both")		# Try this!
    # MONK = "{tyr,zen}"

System = function(command) system(paste("tcsh -c '", command, "'"), intern=T)
Scan = function(...) scan(..., quiet=!verbose)

files = paste0("/data/coord/grab/spike-lfp/data/data/wavelet/",
	       if (SACONLY==1) "saconly",
	       if (MIXED2==1) "mixed2",
	       if ((SACONLY|MIXED2) & CC_INACT) ".",
	       if (CC_INACT==1) "cc_lesion",
	       if (CC_INACT==2||CC_INACT==3) "cc_control", # 2 or 3
	       if (CC_INACT==11) "cc_lesion_LIP",
	       if (CC_INACT==12||CC_INACT==13) "cc_control_LIP",
	       "/",			# double slashes will not hurt
		directory,
		 "/",
		 MonksToDo,
		"/data_",
		 FilesToDo, sep="")

if (CC_INACT==3)
   files = c(files,
            paste0("/data/coord/grab/spike-lfp/data/data/wavelet/cc_lesion",
	       "/", directory, "/", MonksToDo, "/data_", FilesToDo, sep=""))
if (CC_INACT==13)
   files = c(files,
            paste0("/data/coord/grab/spike-lfp/data/data/savelet/cc_lesion_LIP",
	       "/", directory, "/", MonksToDo, "/data_", FilesToDo, sep=""))

# DIAG: begin backward compatibiliy
filefound = F
for (file in files)
  if (file.exists(file)) {
     filefound = 1
     break
     }
if (filefound == F)
  files = paste0("/data/coord/grab/spike-lfp/data/data/wavelet/",
	       if (SACONLY==1) "saconly",
	       if (MIXED2==1) "mixed2",
	       if (CC_INACT==1) "cc_lesion",
	       if (CC_INACT==2) "cc_control",
	       if (CC_INACT==11) "cc_lesion_LIP",
	       if (CC_INACT==12) "cc_control_LIP",
	       if (CC_INACT==3) "cc_*",
	       "/",
		directory,
		 "/",
		 MonksToDo,
		"/CohSpikeLFPData_",
		 FilesToDo, sep="")
# END backward compatibility

data = NULL
UsedFiles = NULL		# rarely, files are skipped
CellCount = 0
SkipCount = CannotFindCount = 0

for (file in files) {
   if (!file.exists(file)) {
      if (CannotFindCount < 3)
         cat("Missing:", sub("/.*/data/data/", "", file), "\n")
      CannotFindCount = CannotFindCount + 1
      next
      }

   if (grepl("_919.2", file)) {
      cat("Skip (10", substring(file, 43), "\n")
      next
      }

   if (verbose)
      cat("file", file, "\n")


   command = Scan(file, nlines=1, what="character")
   params  = Scan(file, skip=2, nlines=1)
   # 1: version         
   # 2: interval_begin  3: interval_end
   # 4: time start      5: time end             
   # 6: filter
   # 7: UnitOrLFP       8: UnitOrLFP2
   # 9: start freq      10: end freq    11: freq step size
   # 12: file type 
   # 13: LFP hemisphere
   # 14: start high freq 15: end hi freq  16: step size
   # 17: evoked flag
   # 18: spike limits (all, exactly mimimum)  19: spike N   20: random seed
   # 21: use chronux flag

   if (length(params) == 0) {		# OLD VERSION !!!
      # OLD VERSION:
      #   # Some of what follows is inherited but not used:
      #   params = Scan(file, skip=1, nlines=1, what="character")
      #   params = as.numeric(params[4:14])	# Toss final 3, unused params
      #   params = list(duration=params[1], window=params[2], freq1=params[7],
      #		 freq2=params[8], freq3=params[9], filter=params[4],
      #		 lfp.hemi=params[11])
      #   WINDOW = params$window
      #   DURATION = params$duration
      #   BANDS = (params$freq2 - params$freq1) / params$freq3 + 1
      #   BANDS.SEQ = seq(params$freq1, params$freq2, by=params$freq3)
      #
      cat("OLD VERSION OF DATA FILE\n")
      params = Scan(file, skip=1, nlines=1, what="character")
      params = as.numeric(params[4:14])	# Throw out final 3, unused params
      params = list(duration=params[1], window=params[2], freq1=params[7],
   		 freq2=params[8], freq3=params[9], filter=params[4],
   		 lfp.hemi=params[11])
      WINDOW = params$window
      DURATION = params$duration
      BANDS = (params$freq2 - params$freq1) / params$freq3 + 1
      BANDS.SEQ = seq(params$freq1, params$freq2, by=params$freq3)
      CompatabilitySkip = 1
      one = matrix(scan(file,skip=4,quiet=T),ncol=7,byrow=T)
      LFP.HEMI = params$lfp.hemi
    } else {					# NEW VERSION  !!!
      FROM = params[2]
      TO   = params[3]
      DURATION = TO - FROM + 1
      ZERO = -FROM

      if (params[9] == -1) {			# -1 means not set!
	 BANDS = -1
       } else {					# shifted by 1 for chronux!
         BANDS = (params[10] - params[9]) / params[11] + 1
         BANDS.SEQ = seq(params[9], params[10], by=params[11])
         }

      LFP.HEMI = params[13]
      
      if (CHRONUX) {
	 } else
           one = matrix(scan(file,skip=5,quiet=T),ncol=7,byrow=T)

      if (abs(TO - FROM - 1 - DURATION) > 10)      # some tolerance!
         cat("Extracted 'zero' may be wrong because bounds were redone\n")
      }

   # rm(FROM, TO)


   if (length(one) == 0) {
      cat("No data in ", sub(".*Data_","",file), "\n")
      next
      }

   # mirror image if SPIKE recorded on right hemisphere
   # Only relevant if plotting two hands, or something like that.
   #   'UNIT' specifies which AREA the spike was in
   	#    spike LFP
   	# 2: left  left		# This is done in the matlab code
   	# 3: right left
   	# 4: left  right
   	# 5: right right
   if (((FLIP == 1) & (LFP.HEMI==3 || LFP.HEMI==5)) ||
       ((FLIP == 2) & (LFP.HEMI==4 || LFP.HEMI==5))
       ) {
      if (verbose)
         cat("Mirror data on right\n")

      if (max(one[,7],0,na.rm=T) > 60) { # Codes stacks, not classes
         save.temp = (one[,7] == 64)		# Save the 64s (index #'s)
         one[ one[,7] == 63, 7] = 64		# Turn 63s into 64s
         one[ save.temp,      7] = 63		# Using saved, turn 64s into 63s
        } else
      if (max(one[,7],0,na.rm=T) == 5) { # Codes two classes (left & right)
         save.temp = (one[,7]==5)
         one[ one[,7]==1, 7] = 5
         one[ save.temp,7] = 1
	 }
      }
  #  if (SPLIT & (LFP.HEMI==2 || LFP.HEMI==5)) {
  #     }


   if (is.nan(one[3,2])) {
      if (SkipCount < 5)
         cat("Skip (2)", sub(".*Data_","",file), "\n")
      SkipCount = SkipCount + 1
      next
      }
      
   CellCount = CellCount + 1
   data = rbind(data, cbind(one, CellCount))

   UsedFiles = c(UsedFiles, file)	# Note which files are used
   }

if (CannotFindCount > 3)
   cat(" and", CannotFindCount-3, "more\n")

if (is.null(UsedFiles))
   stop("Could not find any data files.")

if (length(data) > 1600/(2*(SACONLY>0)+1)) {		# 200 X 8
   colnames(data)= 
       c("freq","cohere","c_rads","sync","s_rads","pval","type","unit")
   if (length(BANDS < 2)) {			# Not set (often true)
       BANDS.SEQ = unique(sort(data[1:(200/(2*(SACONLY>0)+1)),"freq"]))
       BANDS = length(BANDS.SEQ)
       }	
 } else {
   cat("No (or not enough) data to read!\n")
   if (length(data) > 0) {
      cat("  Length of data is", length(data), " -- nulling it out\n")
      data = NULL		# else bytes us down the line (may not help)
      }
   }


if (verbose)
   cat("Done with read\n")
