# PairedPulseBar.r
# (-mc)

#   called by main

DIFF = F
YLIM = if (DIFF) c(-0.005,.1) else c(0, .5)
RELATIVE = F	# Must be DIFF, too
FreqBars = list(8:16, 18:28, 30:60, 66:128)
FreqBars = list(18:28, 66:150)

if ((DIFF == F) & (min(FreqBars[[1]]) >= 14))
   YLIM = c(0, .2)

if (RELATIVE)
   YLIM = c(-.4,1)

PLOT.TYPE = "PairedPulseBar"

if (!exists("LOOP")) LOOP = F

Freqs = unique(data[,1])
BarCount = length(FreqBars)

SE = 
vectors = matrix(NA, nrow=150, ncol=5)

Base = 0			# If not diff, no subtraction

for (freq in Freqs) {
  if (DIFF)
      Base = data[data[,"freq"]==freq & data[,"type"]==62, "sync"]
  for (st in 62:66) {
      vectors[freq,st-61] = 
	   mean(data[data[,"freq"]==freq & data[,"type"]==st, "sync"] - Base)
      SE[freq,st-61] =
	    SEM(data[data[,"freq"]==freq & data[,"type"]==st, "sync"] - Base)
      }
  if (RELATIVE) {
      vectors[freq,] = vectors[freq,] / mean(Base)
      SE[freq,]      = SE[freq,]      / mean(Base)
      }
  }

FreqBarValues = 
FreqBarErrors = matrix(NA, nrow=BarCount, ncol=5)
colnames(FreqBarValues) = 62:66
rownames(FreqBarValues) = FreqBars

for (st in 66:62)
  for (bar in 1:BarCount) {
    FreqBarValues[bar, st-61] = mean(
		vectors[Freqs[Freqs %in% FreqBars[[bar]]], st-61], na.rm=T)
    FreqBarErrors[bar, st-61] = mean(
		SE[Freqs[Freqs %in% FreqBars[[bar]]], st-61], na.rm=T)
    }

if (DIFF) {
    FreqBarValues = FreqBarValues[, -1]
    FreqBarErrors = FreqBarErrors[, -1]
    }

if (BarCount > 3)			# Not much space for freq labels?
   par(las=2)				#  Draw vertically
midpoints = barplot(t(FreqBarValues), beside=T, axes=F, border=NA,
		col=c(if(!DIFF)"gray35","green","red","blue","purple"),
		ylim=YLIM, cex.axis=1.5, cex.names=1.5)
segments(midpoints, t(FreqBarValues) + t(FreqBarErrors),
         midpoints, t(FreqBarValues))
par(las=1)

par(xpd=NA)
if (par()$mfg[2] == 1) {                    # 1st column?
   axis(2, at=c(0,.5,1)*max(YLIM), cex.axis=1.5, cex.lab=1.5)
   save = par(mgp=c(4,1,0))
   title(ylab="Synchrony index (0 to 1)", cex.lab=1.5)
   par(save)
 } else
   axis(2, at=c(0,.5,1)*max(YLIM), label=F, cex.axis=1.5, cex.lab=1.5)

if (par()$mfg[1] == 2)                          # bottom?
      title(xlab="Frequency (Hz)", cex.lab=1.5)
par(xpd=F)

if (LOOP) {
   title(main = paste0(AREA, if (UNIT!="") paste0(" (units:", UNIT, ")")),
			         cex.main=1.4)
   title(main = paste("\n\n\nn=", CellCount), cex.main=.9)
   # title(main = paste0("\n\n", AREA, "      [n=", CellCount, "]"))
 } else
   title(main = paste0(MONK, "  ", AREA, if (NEAR) paste0("+",NEAR),
						" (n=", CellCount, ")"))
