# PairedPulse.r
# (-mc)

#   called by main

# Coherence vs synchrony: set below in the body of the code

DIFF = T		# [T,F] Deviation from 'saccade'
MIN_FREQ = 8		# [0,14]  Not recommended for 'diff' when smooth is on
MAX_FREQ = 48		# [48,150]  (Go no higher than 150?)
ERR_BARS = T

YLIM = ifelse(DIFF, .1, .5)		# [.1, .5]
SMOOTH = ifelse(MAX_FREQ==150, .15, .3)	# [.15, .3 or .4]  'f' of lowess

PLOT.TYPE = "PairedPulse"

if (!exists("LOOP")) LOOP = F

plot(0,0, xlim=c(MIN_FREQ,MAX_FREQ),ylim=c(-0.03,YLIM), 
     			xlab="",ylab="",type='n',axes=F)

par(xpd=NA)
if (par()$mfg[2] == 1) {                    # 1st column?
   axis(2, at=YLIM*c(0,.5,1), cex.axis=1.5)
   save = par(mgp=c(4,1,0))
   title(ylab="Paired pulse length", cex.lab=1.5)
   par(save)
  }# else
   #axis(2, at=YLIM*c(0,.5,1), labels=F, cex.axis=1.5)

if (par()$mfg[1] == par()$mfrow[1]) {      # bottom row?
   axis(1, at=c(if(MIN_FREQ==0) 0,
		if (MIN_FREQ <= MAX_FREQ/3) 1/3, 
		2/3,1)*MAX_FREQ, labels=T, cex.axis=1.5)
   title(xlab="Frequency (Hz)", cex.lab=1.5)
  } else
   axis(1, at=c(if(MIN_FREQ==0) 0,
		if (MIN_FREQ <= MAX_FREQ/3) 1/3, 
		2/3,1)*MAX_FREQ, labels=F, cex.axis=1.5)

par(xpd=F)
#

if (LOOP) {
   title(main = paste0("\n", AREA, 
		      if (UNIT!="") paste0("  (units:", UNIT, ")"),
		      "  [n=", CellCount, "]"))
 } else
   title(main = paste0(MONK, "  ", UNIT, AREA, if (NEAR) paste0("+",NEAR),
		" (n=", CellCount, ")"))

# colnames = c("freq","cohere","c_rads","sync","s_rads","pval","type","unit")
# colnames = c("freq",                  "sync",                "type","unit")

SE = 
vectors = matrix(NA, nrow=150, ncol=5)

Base = 0	# If not diff, remains a zero (no subtraction)
EVERY = 3	# Err bars how often?

Freqs = BANDS.SEQ[BANDS.SEQ <= MAX_FREQ]
if (SMOOTH == 0)		# If smooth, keep low end to avoid edge effects
   Freqs = BANDS.SEQ[BANDS.SEQ >= MIN_FREQ]

for (freq in Freqs) {		 # in unique(data[,1]) if you want ALL freqs
  if (DIFF)
     Base = data[data[,"freq"]==freq & data[,"type"]==62, "sync"]
  for (st in 62:66) {
      vectors[freq,st-61] = 
	   mean(data[data[,"freq"]==freq & data[,"type"]==st, "sync"] - Base)
      if ((freq %% EVERY == (st-62) %% EVERY) && ERR_BARS)
	      			# Set SE only every 4th or 5th opportunity
        SE[freq,st-61] = 	# -> err bar for just 1 stack per Hz
	  SEM(data[data[,"freq"]==freq & data[,"type"]==st, "sync"] - Base)
      }
   }

Freqs.save = Freqs
for (st in 62:66) {
    LineCol = c("black","green","red","blue","purple")[st-61]
    if (SMOOTH) {
       Freqs = Freqs.save			# reset within stack loop
       SAVE = lowess(Freqs, vectors[Freqs,st-61], f=SMOOTH)
       if (MIN_FREQ > 0) {
          SAVE$y = SAVE$y[SAVE$x >= MIN_FREQ]
          SAVE$x = SAVE$x[SAVE$x >= MIN_FREQ]
          Freqs  = Freqs [Freqs  >= MIN_FREQ]
          }
       lines(SAVE, col=LineCol, lwd=4)
       if (ERR_BARS)			# Offset each err bar by 1/4 Hz
         segments(Freqs+(st-62)/4, SAVE$y + SE[Freqs, st-61],
                  Freqs+(st-62)/4, SAVE$y - SE[Freqs, st-61], 
		  col=LineCol)
     } else {
       lines( Freqs, vectors[Freqs,st-61], col=LineCol, lwd=4)
       segments(Freqs+(st-62)/4, vectors[Freqs,st-61] + SE[Freqs,st-61],
                Freqs+(st-62)/4, vectors[Freqs,st-61] - SE[Freqs,st-61],
	       	col=LineCol)
     }
   }
