# CoherenceVsLag.r

# All-sacGoCue_-800:0ms_NoE
# DIRECTORY = "GoCue_-800:0ms_NoE_shift/shift_"
#  DIRECTORY = "AllGoCue_-500:0ms_shift/shift_"
# DIRECTORY = "AllGoCue_-800:0ms_shift/shift_"
DIRECTORY = "All-sacGoCue_-800:0ms_NoE_shift/shift_"
# DIRECTORY = "GoCue_-500:0ms_shift/shift_"

REREAD = T

NEAR =  2
MONK = "both"		# both, zen, tyr
SACONLY = F

PAIRS.TO.SHOW = c(2,5) # 1:6 # c(1,2)	# c(1,2) or 1:6, usually
Freq  = 34
Stack = 62:66 	# [62:66] 66  62:66       (if running 'All',is set to 1)
SIG.COUNT = T	# [T]  # of signif cells (overrides 'SYNC')
  PVAL = .01
SYNC  = F	# [F] if not SIG.COUNT, do synchrony (T) or coherence (F)
KEEP  = 80	# [50] Max abs shift to show
LOWESS = .00025	# [.33] or [.5]

if (grepl("All", DIRECTORY))		# If 'All', indi stacks are not there
    Stack = 1


if (REREAD | !exists("Shifts")) {			# REREAD

Pairs = c("PRR","cross","crossX2","LIP", "cross","crossX2")
Units = c(  "",  "PRR",   "PRR",   "",    "LIP",  "LIP")

Names =	c("PRR-PRR", "PRR*-LIP", "PRR*~~LIP",
	  "LIP-LIP", "LIP*-PRR", "LIP*~~PRR")

DIRECTORIES = paste0(
       "ls -d /data/coord/grab/spike-lfp/data/cohSpikeLFP/",
        DIRECTORY, "*")

Directories = system(DIRECTORIES, intern=T)
if (length(Directories) == 0)
   stop("Cannot find the data")

Shifts = as.numeric(sub(".*shift_", "", Directories))	# get shifts
Directories = Directories[order(Shifts)]		# order directories
Shifts = sort(Shifts)					# sort  shifts
Directories = sub(".*cohSpikeLFP/", "", Directories)	# strip path

CellCounts = matrix(0, ncol=6, nrow=length(Shifts),	# For each 'pl'ot
		    dimnames=list(Shifts, Names))

FIRST.PASS = T

for (shift in 1:length(Shifts)) {
  DIR.OVERRIDE = Directories[shift]
  for (pl in 1:6) {
    AREA = Pairs[pl]		# Kind of a misnomer; should be PAIRS
    UNIT = Units[pl]		# Which area(s) were the units in? For Select

    FilesToDo = NULL		# Ensure these are global variables
    MonksToDo = NULL
    source("Select.r")

    MonksToDo = MonksToDo[!grepl("96[78]", FilesToDo)]
    FilesToDo = FilesToDo[!grepl("96[78]", FilesToDo)]
    # Maybe should also get 870.1, 871.1, 919.2

    source("ReadAll.r")
    if (is.null(data))
	next

    CellCounts[shift,pl] = CellCount

    if (FIRST.PASS) {
       Types = sort(unique(data[,"type"]))
       TypeL = length(Types)
       Freqs = sort(unique(data[,"freq"]))
       FreqL = length(Freqs)
       CoherenceAll = array(NA, dim=c(length(Shifts), TypeL, 6, FreqL),
		   dimnames=list(Shifts, Types, Names, Freqs))
       FIRST.PASS = F
       }

    for (st in 1:TypeL)
      for (fr in 1:FreqL)
        if (SIG.COUNT) {
           CoherenceAll[shift, st, pl, fr] = sum(
     		data[data[,1]==Freqs[fr] & data[,7]==Types[st], "pval"] < PVAL,
		      na.rm=T)
         } else
           CoherenceAll[shift, st, pl, fr] = mean(
     		data[data[,1]==Freqs[fr] & data[,7]==Types[st],
		      if (SYNC) "sync" else "cohere"],
		      na.rm=T)
    }
 }

if (any(is.na(CoherenceAll))) {
   out = is.na(apply(CoherenceAll, 1, sum))	# quick way to find any NA's
   CoherenceAll = CoherenceAll[!out,,,, drop=F]
   Shifts = Shifts[!out]
   }

}
#################################################################

keep = (abs(Shifts) <= KEEP)
shifts = Shifts[keep]			# local copy for printing

par(las=1)
if (length(Stack) > 1) {
   par(mfrow=c(2,3), mar=c(3,2,1,1)+.1, oma=c(8,5,3,0))
   # Stack = unique(data[,7])
 } else
   par(mfrow=c(1,1), mar=c(6,6,3,1)+.1, oma=c(0,0,0,0))

MaxFound = max(CoherenceAll[keep,,PAIRS.TO.SHOW,as.character(Freq)])

for (stack in Stack) {
   ToPlot = CoherenceAll[keep, as.character(stack),,as.character(Freq)]

   # cat("THIS IS NOT YET RIGHT. ORIGINALLY PLOTTED CELLS; CONVERT TO %!!\n")
   if (SIG.COUNT) {
      MaxPercent = ceiling(MaxFound/CellCounts[1,st]*10) * 10
      Tics = seq(0, MaxPercent, 10)
      Ylim = c(0, CellCounts[st] * MaxPercent / 100)
    } else
      Ylim = c(0, MaxFound)


   plot(0, xlim=max(abs(shifts))*c(-1,1), ylim=Ylim, bty='n',
     xlab = "", ylab = "",
     axes = F,
     type = 'n', col=1:6)


   par(xpd=NA)
   if (par()$mfg[2] == 1) {        # 1st column?
      if (SIG.COUNT) {
         axis(2, at=Tics/100*CellCount, labels=Tics)
       } else
         axis(2, at=c(0.03, 0.04, 0.05, 0.06), cex.axis=1.5)
      save = par(mgp=c(4,1,0))
      title(ylab=ifelse(SIG.COUNT, "Coherent pairs (%)",
		 ifelse(SYNC, "Synchrony", "Coherence"))
	    , font.lab=2, cex.lab=1.5 		# DIAG
	    )
      par(save)
    } else
     axis(2, labels=F)

   if (par()$mfg[1] == par()$mfrow[1]) {   # bottom row?
      axis(1, at=seq(-KEEP, KEEP, KEEP/4), 
	      labels= c(-KEEP, "", -KEEP/2, "", 0, "", KEEP/2, "", KEEP) 
            , cex.axis=1.5	# DIAG
	    )
      title(xlab="Shift in spike times re: LFP (ms)"
            , cex.lab=1.5, font.lab=2		# DIAG
	    )
    } else
      axis(1, labels=F)

   par(xpd=F)
   ##############

   segments(0, min(ToPlot), 0, max(ToPlot)*.95, lty="dashed", lwd=2)

   for (i in PAIRS.TO.SHOW) {
      lines(lowess(shifts, 
		ToPlot[,i], 
		f=LOWESS),
		lwd= ifelse(length(PAIRS.TO.SHOW) > 3, 3, 8),
	  	col=i)
      }
   if (Stack[1] != 1)
      title(paste("   Stack ", stack))
   }

# segments( 13, min(ToPlot),  13, max(ToPlot), lty="dotted")
# segments(-13, min(ToPlot), -13, max(ToPlot), lty="dotted")

if (length(Stack) > 1)
   plot(0,0, type='n', xlab="", ylab="", axes=F)

# legend("topright", Names, col=1:6, lwd=2)	# DIAG
legend("topleft", Names[PAIRS.TO.SHOW],col=PAIRS.TO.SHOW,lwd=5,cex=1.5,bty='n')
# text(-38, 0.06, "PRR - PRR", col=1, cex=1.5, adj=0, font=2)
# text(-38, 0.057, "PRR - LIP", col=2, cex=1.5, adj=0, font=2)

mtext(paste(ifelse(SYNC, "Synchrony", "Coherence"), "at", Freq, "Hz"),
     	     outer=T, side=1, line=1-2.5*(TypeL==1), adj=0.9555, cex=.8)
mtext(paste0(gsub("/shift_","",DIRECTORY),
	     "   Lowess:", LOWESS), 
     	     outer=T, side=1, line=1-2.5*(TypeL==1), adj=0.05, cex=.6)

title("\nLagged coherence", cex.main=1.5)	# DIAG
