# CoherenceHisto.r
# (-mc)

# Distribution of coherence or synchrony values for a single frequency

Freq  = 32
Stack = 66		# 0: all stacks  ('1' for AllStacks data files)
SYNC  = T		# Use synchrony (T) or coherence (F) (sync has Pvals!)
XLIM  = 0.33
YLIM  = 0.4

PLOT = T


if (!exists("LOOP")) LOOP = F

PLOT.TYPE = "CoherenceHisto"

index = data[,1] == Freq
if (length(unique(data[,7])) == 1) {		# one stack only (merged)
   Lstacks = 1
 } else if (Stack) {
   index = index & (data[,7] %in% Stack)
   Lstacks = length(Stack)
 } else {
   Lstacks = 5
   }

YLIM = Lstacks * CellCount * YLIM

XLIM = (1+round(40*XLIM))/40

origData = Data = data[index, if (SYNC) "sync" else "cohere"]

Data[Data > XLIM] = XLIM

cat(ifelse(SYNC, "Synchrony", "Coherence"),
	   "at", Freq, "Hz:  ", 
	   round(mean(origData, na.rm=T), dig=4), "\n")

if (PLOT) {
hist(Data, xlim=c(-.02,XLIM), main="", axes=F,
    ylim=c(0,YLIM),
    breaks=1/80+(-1:(40*XLIM))/40)

if (SYNC) {		# Can only get stats with SYNC
   par(new=T)
   hist(Data[data[index,6] < .01],
	   axes=F, main="",
  	   breaks=1/80+(-1:(40*XLIM))/40,
	   xlim=c(-0.02,XLIM),
     	   ylim=c(0,YLIM), 
	   col=2)
   SigMean = mean(origData[data[index,6]<.01], na.rm=T)
   arrows(SigMean, YLIM*.95, 
          SigMean, YLIM*.8, 
       lwd=4, col="red", length = 0.13)
   text(XLIM, YLIM*.85, round(SigMean, dig=3), col="red", adj=1)
   }

arrows(mean(origData, na.rm=T), YLIM, 
       mean(origData, na.rm=T), YLIM*.85, 
       lwd=4, col="green", length = 0.13)
text(XLIM, YLIM*.95, round(mean(origData, na.rm=T), dig=3), col="green", adj=1)


par(xpd=NA)

axis(2, at=YLIM*c(0,.5,1), 
   labels= if (par()$mfg[2] == 1) {
	      paste0(c(0, 25, 50), "%")
	      } else
	      F)
if (par()$mfg[2] == 1)
   title(ylab="Cells")

axis(1, labels=(par()$mfg[1] == par()$mfrow[1]))     # bottom row?

#if (par()$mfg[1] == par()$mfrow[1])
#   title(xlab=if (SYNC) "Synchrony" else "Coherence")

par(xpd=F)

if (LOOP) {
   title(main = paste0("\n", AREA, 
		      if (UNIT!="") paste0("  (units:", UNIT, ")"),
		      "  [n=", CellCount, "]"))
 } else
   title(main = paste0(MONK, "  ", UNIT, AREA, if (NEAR) paste0("+",NEAR),
		" (n=", CellCount, ")"))

# par(SavePar)

if (all(par()$mfg[1:2] == par()$mfrow[1:2])) {
  mtext(paste0(
	       ifelse(SYNC, " Synchrony", " Coherence"),
	       " at ", Freq, " Hz, ", 
	       if (Stack > 1) paste0("Stack ", Stack) else "all stacks"), 
	side=1, outer=T, line=3, adj=.5)
  mtext(paste("Mean of all", if (SYNC) "/ significant"),
	side=1, outer=T, line=3, adj=1, cex=.7, col="green")
  }
}    # end of PLOT
