import argparse
import io
import os
import shutil
import subprocess
import sys

import numpy as np
import pandas as pd


def main():

    database = '/data/coord/zen/zenunits'
    df = pd.read_csv(database, delim_whitespace=True, comment='/')

    import pdb
    pdb.set_trace()



def main2():

    # Parse input
    args = parse_input()
    args.output = ('/data/memory/grab/power/python/results/{}.{}'
            .format(__file__.split('.')[0], args.arg_code))

    # Make a blank output directory
    if os.path.exists(args.output) :
        shutil.rmtree(args.output)
    os.makedirs(args.output)

    # Prep to run macro
    df_sites = lfp_select.select_lfp_data(rew=args.rew)
    grab_args, df_sites['grab_args'] = build_grab_args(df_sites, 
            args.macro_num, args.arg_code, args.file_args)

    # Run the macro for each site
    run_macro(df_sites, args.macro_num, grab_args, args.output)


def parse_input() :
    
    # Build parser
    parser = argparse.ArgumentParser(description=__doc__,
            formatter_class=argparse.RawDescriptionHelpFormatter)

    # Arguments
    parser.add_argument(
            'macro_num',
            choices=(11, 15),
            help=('Macro number (11 = mean spectrogram, 15 = trial-wise'
                ' power.)'),
            type=int)
    parser.add_argument(
            'arg_code',
            help='The argument code (defining saved arguments.)')
    parser.add_argument(
            '-f', '--file_args',
            help='File containing arguments to apply by file.',
            default=None)
    parser.add_argument(
            '-r', '--rew',
            help='Reward regime to include.',
            nargs='+',
            default=[1, 2, 3, 4],
            type=int)

    return parser.parse_args()


def build_grab_args(df_sites, macro_num, arg_code, file_args_file) :

    # Select saved arguments by code (index)
    if (macro_num == 11) and (arg_code == '625_5s') :
        global_args = ('-od -at2 -Xc1:16 -xc5 -xc13 -mc1:4,14:16 -mc2,6:12'
                ' -of4:128:2 -ot625 -Xs111:115 -xs113:114 -ms -i-1500:5300')

    elif (macro_num == 11) and (arg_code == '625_7.5s') :
        global_args = ('-od -at2 -Xc1:16 -xc5 -xc13 -mc1:4,14:16 -mc2,6:12'
                ' -of4:128:2 -ot625 -Xs111:115 -xs113:114 -ms -i-1500:7800')

    elif (macro_num == 11) and (arg_code == '625_15s') :
        global_args = ('-od -at2 -Xc1:16 -xc5 -xc13 -mc1:4,14:16 -mc2,6:12'
                ' -of4:128:2 -ot625 -Xs115 -ms -i-1500:15300')

    elif (macro_num == 11) and (arg_code == '1250_5s') :
        global_args = ('-od -at2 -Xc1:16 -xc5 -xc13 -mc1:4,14:16 -mc2,6:12'
                ' -of4:128:2 -ot1250 -Xs111:115 -xs113:114 -ms -i-1500:5300')

    elif (macro_num == 11) and (arg_code == '1250_7.5s') :
        global_args = ('-od -at2 -Xc1:16 -xc5 -xc13 -mc1:4,14:16 -mc2,6:12'
                ' -of4:128:2 -ot1250 -Xs111:115 -xs113:114 -ms -i-1500:7800')

    elif (macro_num == 11) and (arg_code == '1250_15s') :
        global_args = ('-od -at2 -Xc1:16 -xc5 -xc13 -mc1:4,14:16 -mc2,6:12'
                ' -of4:128:2 -ot1250 -Xs115 -ms -i-1500:15300')

    elif (macro_num == 15) and (arg_code == 'theta_stim') :
        global_args = ('-od -at2 -ot1250 -Xs111:115 -xs113:114 -ms'
                ' -of6:6:2 -i-200:1050')

    elif (macro_num == 15) and (arg_code == 'theta_stim_7.5s') :
        global_args = '-od -at2 -ot1250 -Xs111:112 -ms -of6:6:2 -i-200:1050'

    elif (macro_num == 15) and (arg_code == 'theta_mem') :
        global_args = ('-od -at2 -ot1250 -Xs111:115 -xs113:114 -ms'
                ' -of6:6:2 -i2000:5300')

    elif (macro_num == 15) and (arg_code == 'theta_end') :
        global_args = '-od -abt1 -ot1250 -Xs111:112 -ms -of6:6:2 -i-2000:0'

    elif (macro_num == 15) and (arg_code == 'alpha_stim') :
        global_args = ('-od -at2 -ot625 -Xs111:115 -xs113:114 -ms'
                ' -of12:12:2 -i0:1000')

    elif (macro_num == 15) and (arg_code == 'alpha_stim_7.5s') :
        global_args = '-od -abt1 -ot625 -Xs111:112 -ms -of12:12:2 -i0:1000'

    elif (macro_num == 15) and (arg_code == 'alpha_mem') :
        global_args = ('-od -at2 -ot625 -Xs111:115 -xs113:114 -ms'
                ' -of12:12:2 -i2000:5300')

    elif (macro_num == 15) and (arg_code == 'alpha_end') :
        global_args = '-od -abt1 -ot625 -Xs111:112 -ms -of12:12:2 -i-2000:0'

    elif (macro_num == 15) and (arg_code == 'beta_stim') :
        global_args = ('-od -at2 -ot625 -Xs111:115 -xs113:114 -ms'
                ' -of20:28:2 -i0:1000')

    elif (macro_num == 15) and (arg_code == 'beta_stim_7.5s') :
        global_args = ('-od -at2 -ot625 -Xs111:112 -ms -of20:28:2 -i0:1000')

    elif (macro_num == 15) and (arg_code == 'beta_mem_early_7.5s') :
        global_args = ('-od -at2 -ot625 -Xs111:112 -ms -of20:28:2 -i2000:4000')

    elif (macro_num == 15) and (arg_code == 'beta_mem') :
        global_args = ('-od -at2 -ot625 -Xs111:115 -xs113:114 -ms'
                ' -of20:28:2 -i2000:5300')

    elif (macro_num == 15) and (arg_code == 'beta_end') :
        global_args = '-od -abt1 -ot625 -Xs111:112 -ms -of20:28:2 -i-2000:0'

    elif (macro_num == 15) and (arg_code == 'beta_end_3s') :
        global_args = '-od -abt1 -ot625 -Xs111:112 -ms -of20:28:2 -i-3000:0'

    elif (macro_num == 15) and (arg_code == 'gamma_stim') :
        global_args = ('-od -at2 -ot625 -Xs111:115 -xs113:114 -ms'
                ' -of36:60:2 -i0:1000')

    elif (macro_num == 15) and (arg_code == 'gamma_stim_7.5s') :
        global_args = ('-od -at2 -ot625 -Xs111:115 -of36:60:2 -i0:1000')

    elif (macro_num == 15) and (arg_code == 'gamma_mem_early_7.5s') :
        global_args = ('-od -at2 -ot625 -Xs111:115 -of36:60:2 -i2000:4000')

    elif (macro_num == 15) and (arg_code == 'gamma_mem') :
        global_args = ('-od -at2 -ot625 -Xs111:115 -xs113:114 -ms'
                ' -of36:60:2 -i2000:5300')

    elif (macro_num == 15) and (arg_code == 'gamma_end') :
        global_args = '-od -abt1 -ot625 -Xs111:112 -ms -of36:60:2 -i-2000:0'

    elif (macro_num == 15) and (arg_code == 'gamma_end_3s') :
        global_args = '-od -abt1 -ot625 -Xs111:112 -ms -of36:60:2 -i-3000:0'

    elif (macro_num == 15) and (arg_code == 'high-gamma_stim') :
        global_args = ('-od -at2 -ot625 -Xs111:115 -xs113:114 -ms'
                ' -of68:124:2 -i0:1000')

    elif (macro_num == 15) and (arg_code == 'high-gamma_stim_7.5s') :
        global_args = ('-od -at2 -ot625 -Xs111:115 -ms -of68:124:2 -i0:1000')

    elif (macro_num == 15) and (arg_code == 'high-gamma_mem_early_7.5s') :
        global_args = ('-od -at2 -ot625 -Xs111:115 -ms -of68:124:2 -i2000:4000')

    elif (macro_num == 15) and (arg_code == 'high-gamma_mem') :
        global_args = ('-od -at2 -ot625 -Xs111:115 -xs113:114 -ms'
                ' -of68:124:2 -i2000:5300')

    elif (macro_num == 15) and (arg_code == 'high-gamma_end') :
        global_args = '-od -abt1 -ot625 -Xs111:112 -ms -of68:124:2 -i-2000:0'

    elif (macro_num == 15) and (arg_code == 'high-gamma_end_3s') :
        global_args = '-od -abt1 -ot625 -Xs111:112 -ms -of68:124:2 -i-3000:0'

    else :
        raise Exception('ARGUMENT CODE not recognized!!')

    if file_args_file :

        # Load file args dataframe
        df_file_args = pd.read_csv(file_args_file, index_col='file')

        # Loop through each site, finding its specific grab args
        for idx, site_data in df_sites.iterrows() :
            file_args = df_file_args.loc[site_data['file'], 'args'] 
            df_sites.loc[idx, 'grab_args'] = file_args

    else :
        df_sites['grab_args'] = ''

    return global_args, df_sites['grab_args']


def run_macro(df_sites, macro_num, grab_args, output) :
    '''
    Main function for running the power macro on each site.
    '''

    # Make an empty dataframe to keep track of things
    results_agg = []

    # Make a progress bar
    prog = progbar.Bar('Running macro...', max=df_sites.index.shape[0],
                    suffix='%(index)d/%(max)d (%(percent)d%%), %(eta_td)s')

    # Loop through all sites, running the power macro
    for _, site_data in prog.iter(df_sites.iterrows()) :
       
        # Step into the data directory
        init_dir = os.getcwd()
        os.chdir(os.path.dirname(site_data['file']))

        # Define the data file for this iteration and where it will go after. 
        s_file = site_data['file']
        data_file = 'data_{}_{}'.format(os.path.basename(s_file)[1:], 
                site_data['electrode'])
        data_file_dest = '{}/{}'.format(output, 
                data_file.replace('data', site_data['monk']))

        # Remove the data file if it already exists
        if os.path.exists(data_file) :
            os.remove(data_file)

        # Run grab's power macro
        grab_cmd = 'grab -o{} {} {} -d{} {}'.format(macro_num, grab_args, 
                site_data['grab_args'], site_data['electrode'], s_file)
        subprocess.call(grab_cmd, shell=True)

        # Check if the file exists now
        if not os.path.exists(data_file) :
            raise Exception('Macro output file was not made!')

        # Use grab to check if any trials are missing
        cmd = 'grab {} {} -R1 {} | wc -l'.format(grab_args, 
                site_data['grab_args'], s_file)
        n_trials = int(subprocess.check_output(cmd, shell=True))
        with open(data_file, 'r') as file :
            lines = file.readlines()
            if macro_num == 11 :
                n_trials_output = np.sum(np.loadtxt(io.StringIO(lines[3])))
            else :
                n_trials_output = len(lines) - 4
        results_agg.append({
                'file' : s_file, 
                'electrode' : site_data['electrode'],
                'trials_missing' : n_trials - n_trials_output})

        # Move the data file to the output directory. 
        shutil.move(data_file, data_file_dest)

        # Go back to the initial directory
        os.chdir(init_dir)

    # Compile results, but only include data that are missing trials.
    df_results = pd.DataFrame(results_agg)
    df_results = df_results[df_results['trials_missing'] > 0]

    # Output results
    with open('{}/missing_trials.pd'.format(output), 'w') as fid :
        fid.write('{}\n'.format(df_results.to_string()))


# Call main function
if __name__ == '__main__' :
    main()
