close all; clear all; clc
addpath(genpath('/data/code/matlab'));
prepOutput;


%%%% PARAMETERS %%%%

% Database
database{1} = '/data/coord/tyr/tyrunits';
database{2} = '/data/coord/zen/zenunits';

% Data files
dataDir = '../data/DFTphasePairSpikeLFP/Target_300:1300ms_FakeSpikesAndLFP';

% Display
linProp.col   = {'k','g','r','b','m'};
linProp.width = 2;

% Save params
save('output/params.mat');


%%%% LOAD AND SELECT DATA %%%%

% Select data
DataList   = listLfpData(dataDir,'DFTphasePairSpikeLFPData','spike-lfp');
SiteParams = listSiteParams(DataList,database,'coord');
writeDataList(DataList,'output/DataList','spike-lfp');


%%%% LOAD DATA %%%%

% Load data
Data = loadLfpData(dataDir,DataList,214);

% Get mean ppc array
for iData = 1:length(Data)
    ppcArrayAll(:,:,iData) = Data(iData).ppcArray;
end
ppcSmooth = smoothGauss(ppcArrayAll,3,2); 
ppcMean   = nanmean(ppcSmooth,3);

% Extract time and freq - verify they match across sites.
freq = Data(1).freq;

% Make figure. Define a constant
hfig = makeFig(5,4);

% Plot first spectrogram
plot(freq,ppcMean(1,:),'k', ...
     freq,ppcMean(2,:),'g', ...
     freq,ppcMean(3,:),'r', ...
     freq,ppcMean(4,:),'b', ...
     freq,ppcMean(5,:),'m');
xlim(freq([1,end]));
xlabel('Freq. (Hz)');
ylabel('PPC');

% Print figure
print(hfig,'-dtiff','output/PPC.tiff');
print(hfig,'-depsc','-loose','output/PPC.eps');
close(hfig);
