close all; clear all; clc
addpath(genpath('/data/code/matlab'));
prepOutput;


%%%% PARAMETERS %%%%

% Database
database{1} = '/data/coord/tyr/tyrunits';
database{2} = '/data/coord/zen/zenunits';

% Data files
dataDir = '../data/cohSpikeLFP/Target_300:1300ms';

% Display
linProp.col   = {'k','g','r','b','m'};
linProp.width = 2;

% Save params
save('output/params.mat');


%%%% LOAD AND SELECT DATA %%%%

% Select data
DataList   = listLfpData(dataDir,'CohSpikeLFPData','spike-lfp');
SiteParams = listSiteParams(DataList,database,'coord');
writeDataList(DataList,'output/DataList','spike-lfp');


%%%% LOAD DATA %%%%

% Load data
Data = loadLfpData(dataDir,DataList,13);

% Get mean ppc array
for iData = 1:length(Data)
    cohAll(:,:,iData)  = abs(Data(iData).coh);
    syncAll(:,:,iData) = abs(Data(iData).sync);
    pAll(:,:,iData) = abs(Data(iData).p);
end
cohMean  = nanmean(cohAll,3);
cohErr   = nansem(cohAll,3); 
syncMean = nanmean(syncAll,3);
syncErr  = nanmean(syncAll,3);
nSignif  = mean(pAll<0.05,3);

% Extract time and freq - verify they match across sites.
freq = Data(1).freq;

% Make figure. Define a constant
lineProp.col   = {'k','g','r','b','m'};
lineProp.width = 2;

% Plot coh
hfig = makeFig(5,4);
mseb(freq,cohMean,cohErr,lineProp);
xlim(freq([1,end]));
xlabel('Freq (Hz)');
ylabel('Coherence');
print(hfig,'-dtiff','output/Coh.tiff');
print(hfig,'-depsc','-loose','output/Coh.eps');
close(hfig);

% Plot coh
hfig = makeFig(5,4);
mseb(freq,syncMean,syncErr,lineProp);
xlim(freq([1,end]));
xlabel('Freq (Hz)');
ylabel('Synchrony');
print(hfig,'-dtiff','output/Sync.tiff');
print(hfig,'-depsc','-loose','output/Sync.eps');
close(hfig);

% Plot p
hfig = makeFig(5,4);
plot(freq,nSignif(1,:),'k', ...
     freq,nSignif(2,:),'g', ...
     freq,nSignif(3,:),'r', ...
     freq,nSignif(4,:),'b', ...
     freq,nSignif(5,:),'m');
xlim(freq([1,end]));
xlabel('Freq (Hz)');
ylabel('Synchrony');
print(hfig,'-dtiff','output/Sync.tiff');
print(hfig,'-depsc','-loose','output/Sync.eps');
close(hfig);
