# DoAll 

OVERRIDE = T

for (e in c("ALIGN.S", "INTERVAL.S", "MERGE_STACK.S", 
	    "EXCLUDE_SACS.S", "NUM_SPIKES.S", "TW.S", "TIME_SHIFT.S",
            "ALIGN",   "INTERVAL",   "MERGE_STACK",
	    "EXCLUDE_SACS",   "NUM_SPIKES",   "TW",   "TIME_SHIFT")
	    )
    if (exists(e)) rm(e)		# Get rid of all the old stuff!

# Set *either* the plural (ends with s) or singular for each value
#  (Can mix, but need one of each)

# ALIGN.S = c("GoCue", "GoCue", "GoCue", "Target", "Target")
# ALIGN = "GoCue"			# [GoCue]
 ALIGN = "Target"

# INTERVAL.S =  c("50:350", "50:250", "0:300", "0:200")
# INTERVAL =  "-800:0"		# Delay, large as possible (cue-align)
# INTERVAL =  "-1000:0"		# Delay, large as possible (cue-align)
# INTERVAL =  "-650:-150"	# Delay, match targ & ITI lengths (cue-aligned)
# INTERVAL =  "-500:0"		# Baseline or ITI (target-aligned)
 INTERVAL =  "50:350"		# Target
# INTERVAL =  "50:450"		# Target, shorter interval
# INTERVAL =  "50:350"		# Target, very short interval

# MERGE_STACK.S = c(1,3,5)		# [F] 1:all 2:all-sac 3:all-apart 5:2&3
MERGE_STACK = 0			# [F] 1:all 2:all-sac 3:all-apart 5:2&3

# NUM_SPIKES.S = c(rep(c(0, -100, -300),3), -200)
# Negative means "or more"
# NUM_SPIKES = -500 		# [-500] (-100 or 0 for PPC)
# NUM_SPIKES = -400
# NUM_SPIKES = -100
NUM_SPIKES = -100
# NUM_SPIKES = -100
# NUM_SPIKES = 0

# TW.S = c(rep(6,6), rep(8,6), rep(12,6))
# TW.S = c(2.5, 12, 4, 6, 5, 2, 16)
TW = 1  # c(1,2,3,5)

# TIME_SHIFT.S = c(seq(2,20,by=2), seq(24,40,by=4), 48, 56, seq(64,128,by=16))
# TIME_SHIFT.S = c(seq(2,16,by=2), seq(20,40,by=4), 48)
# TIME_SHIFT.S = c(TIME_SHIFT.S, -TIME_SHIFT.S)

#TIME_SHIFT.S = c(4, 8, 12, -4, 16, -8, 20, 24, -12, 28, -16, 36, -20, 2, -24, 6, -32, -2, 10, -6, 14, -10, 40, 18, -14, 28, -18, 32, -36, -40, 48, -48, 56, -56, 64, -64, 80, -80, 96, -96, 112, -112, 128, -128)


 # TIME_SHIFT.S = c(56, seq(64,128,by=16))
 TIME_SHIFT = 0		# positive times mean use earlier spikes


# --------------------------------------------------------------- #

CHRONUX = -1		# -1:PPC(macro 14)   0:Wavelet/13   1:Chronux/213

SHUFFLE = F		# used in RunMacro.r  1: "-os-1" best   2: pass shuffle#
			# method 2 is old and not as good as method 1

SACONLY = T		# session block with only saccades (see also EXCLUSIVE_SACS)
MIXED2  = F
MEMORY =  F
CC_INACT = 0		#  0:std  1:lesion callosum  2: control_cc  (for PRR)
			#     11: for lesion/memory/PRR+LIP  12: control 11
CC_TIME_COMBINE = F	# Merge pre and post together

if (CC_INACT==13) cat("Something wrong - should be the weighted average of 11 & 12, but it is not!\n")

MERGE_CLASS = 1        #  1:-mc  10:PrefOnly  11:NullOnly  12:Nulls 13:HalfNull
RM_EVOKED = F
EXCLUSIVE_SACS = F	# Take only sac trials from a mixed block (see also SACONLY)

###############################################
# CHECK THAT YOU SET IT UP CORRECTLY:
L  = function(x) { if (exists(x)) return(length(get(x))) else return(0) }

PluralMax = c(
        L("ALIGN.S"), L("INTERVAL.S"), L("MERGE_STACK.S"),
        L("EXCLUDE_SACS.S"), L("NUM_SPIKES.S"), L("TW.S"),
        L("TIME_SHIFT.S")
        )
rm(L)

PluralMax = unique(PluralMax)
if (length(PluralMax) > 2)              # 1: none or all exist  2: some exist
   stop("Mismatch in plural lengths")   # >2 means some lengths are mismatched

PluralMax = max(c(1,PluralMax))         # if none exist (all 0's), make it 1
###############################################

for (i in 1:PluralMax) {
	if (exists("ALIGN.S"))
	   ALIGN = ALIGN.S[i]
	if (exists("INTERVAL.S"))	# If no plural version exists,
	   INTERVAL = INTERVAL.S[i]	#  we assume singulars are already set
	if (exists("NUM_SPIKES.S"))
	   NUM_SPIKES = NUM_SPIKES.S[i]
	if (exists("MERGE_STACK.S"))
	   MERGE_STACK = MERGE_STACK.S[i]
	if (exists("TW.S"))
	   TW = TW.S[i]
	if (exists("EXCLUDE_SACS.S"))
	   EXCLUDE_SACS = EXCLUDE_SACS.S[i]
	if (exists("TIME_SHIFT.S"))
	   TIME_SHIFT = TIME_SHIFT.S[i]

	source("RunMacro13.r")
	}


rm(OVERRIDE)
for (e in c("ALIGN.S", "INTERVAL.S", "MERGE_STACK.S", 
	    "EXCLUDE_SACS.S", "NUM_SPIKES.S", "TW.S",
	    "TIME.SHIFT.S",
            "ALIGN", "INTERVAL", "MERGE_STACK", 
	    "EXCLUDE_SACS", "NUM_SPIKES")
	    )
    if (exists(e)) rm(e)		# Get rid of all the old stuff!
