# RunMacro13.r

# Call with doAll.r or doOne.r
# To call directly, uncomment (and perhaps change!) the next two lines

verbose = 0	# 0: execute only   1: print & execute   -1: print only
			# higher numbers (e.g., -2) give more info

if (!exists("OVERRIDE")) {
   CHRONUX = 0			# 1:chronux/macro213  0:in-house/13 -1:PPC/14
   INTERVAL = "-800:0"
   ALIGN = "GoCue"
   RM_EVOKED = F
   MERGE_CLASS = T		# T or 1: -mc   10:pref  11:null  12:non-prefs
   MERGE_STACK = F		# "All"
   EXCLUSIVE_SACS = F
   TIME_SHIFT = 0
   SACONLY = F
   MEMORY = F
   CC_INACT = 1
   CC_TIME_COMBINE = T		# Combine all runs (.1, .2, etc) with "-mf"
   MIXED2 = F
   SHUFFLE = F
   TW = 2.5
   }

if (EXCLUSIVE_SACS)
    MERGE_STACK = F

ARGS = paste0(
     switch(ALIGN, target="-at2", Target="-at2",
	       	   gocue="-abt1", Gocue="-abt1", GoCue="-abt1",
		   saccade="-avb1", Saccade="-avb1",
		   "Unknown"),
	" -i", INTERVAL,
	if (EXCLUSIVE_SACS) " -xs63:91 -xs93:96",
	if (MERGE_STACK==1) " -ms",
	if (MERGE_STACK==2) " -xs62 -xs92 -ms",
	if (MERGE_STACK==3) " -xs66 -xs96 -xs76 -ms",
	if (MERGE_STACK==5) " -xs62 -xs92 -xs66 -xs76 -xs96 -ms",
	" -ms66,76",			# If not already merged or excluded
	if (TIME_SHIFT) paste0(" -oS", TIME_SHIFT),
	if (SHUFFLE==1) " -os-1",	# -1: method 1 (better than 2)
					# if (SHUFFLE==2) add arguments later
	if (RM_EVOKED) " -oe1",
	if (NUM_SPIKES) paste0(" -oN", 	# -N  2:500 - use 500 or more spikes
			      ifelse(NUM_SPIKES<1, 2, 1), ":", abs(NUM_SPIKES)))

if (CC_INACT > 10)
	ARGS = paste(ARGS, "-xs196 -xs195")

outDirectory	= paste0(
	"/data/coord/grab/spike-lfp/data/data/",
	switch(2+CHRONUX, "PPC", "wavelet", "chronux"),
	"/",
	if (SACONLY)   "saconly",
	if (MIXED2)    "mixed2",
	if ((SACONLY | MIXED2) & CC_INACT) ".",
	if ((CC_INACT%%10)==1)  "cc",
	if ((CC_INACT%%10)==2)  "ccc",
	if (CC_TIME_COMBINE)    "pre+post",
	if (CC_INACT>10)        "_memory",
	"/",
	if (MERGE_STACK) 
	   switch(MERGE_STACK, "All","All-sac","All-apart","", "All-sac-apart"),
	if (EXCLUSIVE_SACS) "SacOnly",
        switch(ALIGN, target="Target", Target="Target",
	       	      gocue="GoCue", Gocue="GoCue", GoCue="GoCue",
		      saccade="Saccade", Saccade="Saccade",
		      "Unknown"),
	"_",
       	INTERVAL,
	"ms",
	if (RM_EVOKED) "_NoE",
	if (NUM_SPIKES) paste0(".N=", abs(NUM_SPIKES), if (NUM_SPIKES<0) "+"),
	if (CHRONUX==1) paste0("_TW=", round(TW,dig=1)),
	if (MERGE_CLASS>1) switch(MERGE_CLASS-9, 
				  "_pref", "_null", "_nulls", "_Hnull"),
	if (TIME_SHIFT) paste0("_shift/", TIME_SHIFT))
	

cat("Grab arguments:", ARGS, "\n")
cat("Data directory:", outDirectory, "\n")
cat("Set:  ",
   if (TIME_SHIFT) "TIME_SHIFT ",
   if (SACONLY) "SACONLY ",
   if (MIXED2) "MIXED2 ",
   if (CC_INACT) cat("CC_INACT ", CC_INACT, ""),
   if (CC_TIME_COMBINE) "COMBINE PRE + POST ",
   switch(2+CHRONUX, "PPC ", "IN-HOUSE ", "CHRONUX "),
   if (SHUFFLE) "SHUFFLE",
   if (SHUFFLE==2) "type 2",
   if (RM_EVOKED) " RM_EVOKED ",
   if (MERGE_CLASS) "MERGE_CLASS ",
   if (MERGE_CLASS>1) switch(MERGE_CLASS-9,
			 "PrefOnly ", "NullOnly ", "AllNulls ", "HalfNulls "),
   if (MERGE_STACK) paste0("MERGE_STACK=", MERGE_STACK),
   if (MERGE_STACK) 
       switch(MERGE_STACK, "(All)","(All-sac)","(All-apart)",
	      			"(what", "(All-sac-apart)"),
   if (EXCLUSIVE_SACS) "EXCLUSIVE_SACS ")

NEAR = 2

cat(INTERVAL, "\n", outDirectory, "\n")

options(stringsAsFactors = FALSE)
initwd = getwd()

a = NULL
if (!MIXED2 && !CC_INACT>10) {	# No zen data for MIXED2 or LIP lesions
 a = read.table(
	paste0("/data/coord/zen/zenunits", 
	       		 ifelse(SACONLY,"_saconly",""),
	       		 ifelse(MEMORY, "_memory", ""),
			 if (CC_INACT > 10) "_memory",
			 ifelse((CC_INACT%%10)==1,"_cc_inactivate", ""),
			 ifelse((CC_INACT%%10)==2,"_cc_control", "")),
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
 a = cbind(a, monk="zen")		# Append monkey name (as a column)
 }

b = read.table(
	paste0("/data/coord/tyr/tyrunits", 
	       		 ifelse(SACONLY,"_saconly",""),
	       	         ifelse(MIXED2, "_mixed2",""),
			 if (CC_INACT > 10) "_memory",
			 ifelse((CC_INACT%%10)==1,"_cc_inactivate", ""),
			 ifelse((CC_INACT%%10)==2,"_cc_control", "")),
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
b = cbind(b, monk="tyr") 		# Append monkey name (as a column)
base = rbind(a,b)
rm(a,b)

if (NEAR)
   source("/data/coord/grab/Nearest.r")

while (grepl("base", search()[2]))
      detach(2)
attach(data.frame(base, stringsAsFactors=FALSE))

base = cbind(base, lfp.hem=NA)	# track hemisphere of lfp (vs spike)

# if (CC_INACT)		# Restrict to just one period -- no, do them all!
#    base = base[grepl(CC_TIME+2, base[, "reach_file"]), ]
if (CC_TIME_COMBINE)	# Will combine *.1 and *.2, so take only .2 (rm .1)
    base = base[grepl("\\.2", base[, "reach_file"]), ]
	# There's a little magic here - grab will create output files based on
	# the LAST file, which is .2, so use that, not .1

###########################################################################
#  FOR SHUFFLES:

REPEATS = 1

Split = function(this_one, processes=4, total_reps=100) {
	if (this_one < 1 | this_one > processes)
	   stop("Bad split request")
	Return = this_one + (0 : (total_reps%/%processes)) * processes
	return(Return[Return<= total_reps])
	}		# Do total reps in processes parallel processes

if (SHUFFLE) {		# To use this, add a number as a parameter, will be passed to Split
   args = as.numeric(commandArgs(trailingOnly = TRUE))
   if (length(args)==0)
      args[1] = 1
   cat("Run part", args[1], "\n")
   offset = if (length(args)==2) args[2] else 0
      
   REPEATS =  offset + Split(args[1],8,50)

   cat("Shuffle from", min(REPEATS), "to", max(REPEATS), "\n")
   base_outDirectory = paste0(outDirectory, "_shuffle")
   if (SHUFFLE == 2)
      base_outDirectory = paste0(base_outDirectory, "2")
   if (!dir.exists(base_outDirectory))
      dir.create(base_outDirectory)

   cat("Shuffle from", min(REPEATS), "to", max(REPEATS), "\n")
   cat("Run part", args[1], "\n")
   }

###########################################################################
for (shuffle in REPEATS) {
 if (SHUFFLE) 
    outDirectory = paste0(base_outDirectory, "/", shuffle)


 if (TIME_SHIFT) {
    path = strsplit(outDirectory, '/')[[1]]	# elements of path
    path = path[1:(length(path)-1)]		# rm last element: "/TIME_SHIFT"
    baseDirectory = paste(path, collapse="/")	# rebuild parent
    if (!dir.exists(baseDirectory))		# if not there, create it
       dir.create(baseDirectory)		# (...._shift)
    }

 if (!dir.exists(outDirectory))
    dir.create(outDirectory)
 setwd(outDirectory)

 system(sprintf("rm -fr tyr zen"))	# remove old stuff
 
 if (!MIXED2)
  if (!dir.exists("zen"))
    dir.create("zen")
 if (!dir.exists("tyr"))
    dir.create("tyr")

 # Find all spike-LFP pairs recorded in LIP and/or PRR (on diff trodes)
 for (jj in 1:3)
  for (kk in (jj+1):4) {

   # Skip this step?  Faster with, but if change NEAR, might miss some
   index = base[,paste0("area",jj)] %in% c("LIP","PRR") &
           base[,paste0("area",kk)] %in% c("LIP","PRR")

   for (ordr in 0:1) {		# do spike-lfp and lfp-spike separately
      field = ifelse(ordr, jj, kk)
      spike = ifelse(ordr, kk, jj)

      indx = index &
                  (base[,paste0("lfp" , field)]==1) & 
	          (base[,paste0("unit", spike)]==1) 

      hemisphere.code = 2 +	# Map (field/unit LL,LR,RL,RR) to 2:5
	 		 1 * base[,paste0("hem", spike)] %in% c("R","RR") +
	 		 2 * base[,paste0("hem", field)] %in% c("R","RR")
			   
      # output file is monk/unit.run.lfp.spike
      for (idx in which(indx)) {
	 outFile = paste0("data_", 		# spike is 0:(n-1) !!
			   base[idx,"reach_file"], "_", field, "_", spike-1)

         if (exists("shift"))
	    cat(shift, "ms   ")

         cat(base[idx, "monk"], base[idx,"reach_file"],
	     " LFP:",field,
	     " Spike:",spike-1,
	     "\n")

	 if (MERGE_CLASS) {			# EXCLUDE IS FIRST!
	    if (MERGE_CLASS == 1) {			# put all together
	       MERGE_ARG = "-mc"
	     } else {
	       pref.class = as.numeric(base[idx,paste0("pd",spike)])
	       if (is.na(pref.class) || (pref.class==0)) {
		  cat("   No preferred class (skipping)\n")
		  next					# Skip if no PD
	          }
	       if (MERGE_CLASS == 10) {			# Pref only
		  MERGE_ARG = paste0("-xc", switch(pref.class,
			"2:8", "1 -xc3:8", "1:2 -xc4:8", "1:3 -xc5:8",
			"1:4 -xc6:8", "1:5 -xc7:8", "1:6 -xc8", "1:7"))
	        } else if (MERGE_CLASS == 11) {		# Null only
    		  null.class = (((pref.class-1)+4) %% 8) + 1 	# Opposite
		  MERGE_ARG = paste0("-xc", switch(null.class,
			"2:8", "1 -xc3:8", "1:2 -xc4:8", "1:3 -xc5:8",
			"1:4 -xc6:8", "1:5 -xc7:8", "1:6 -xc8", "1:7"))
	        } else if (MERGE_CLASS == 12) {		# All non-pref
		  MERGE_ARG = paste0("-xc", pref.class, " -mc")
	        } else if (MERGE_CLASS == 13) {		# Half non-pref
		  MERGE_ARG = paste0("-xc", switch(pref.class,
			"8 -xc1:2", "1:3", "2:4", "3:5",
			"4:6", "5:7", "6:8", "7:8 -xc1"), " -mc")
	          }
	       }
	    } else
	       MERGE_ARG = ""				# Nothing

	 SETWD = paste0("/data/coord/",base[idx,"monk"],"/",base[idx,"date"])
	 CALL =  paste(
	               "grab -ax -Xs62:96 -xs67:75 -xs77:91",
		       ARGS,
		       MERGE_ARG,
		       paste0("-o", switch(2+CHRONUX,14,13,213)),
		       if (CHRONUX==1) "-of3:130",
		       if (CHRONUX <1) "-of4:130:2",
		       if (CHRONUX==1) paste0("-oF", 10*TW), # time*freq
		       			# Times 10 so that not passing floats
		       # -ot defaults to -i(end minus start) for chronux

		       if (SHUFFLE==2) paste0("-os", shuffle),

		       paste0("-oh", hemisphere.code[idx]),
		       paste0("-d", field),
		       paste0("-u", spike-1),		# ugh: 0:(n-1)
		       if (CC_TIME_COMBINE) 
			  paste0("-mf s", # Replace '.2' with '.[12]' !
				 sub("\\.2", ".[12]", base[idx, "reach_file"]))
		        else
		          paste0("s", base[idx, "reach_file"]))
	 MOVE = sprintf("mv %s %s/%s", outFile, outDirectory, base[idx,"monk"])

	 if (verbose) {
	    cat("cd", SETWD, ";", CALL, "\n")
	    if (abs(verbose) > 1)
	       cat(MOVE, "\n")
	    }
	 if (verbose >= 0) {
	    setwd(SETWD)
	    system(CALL)
	    system(MOVE)
	    }
         }
     }
  }
###############################################
}  # End of REPEATS (shuffle loop)

detach(2)
setwd(initwd)
