# doN.r # LinePlot, diff areas -- CHRONUX 
SACONLY = 2	# 0=std  1=saconly
		# 2=saconly format for standard or 'mix' data
MIXED2  = 0
MERGE_CLASS = 1 # [1] 1:-mc 10:PrefOnly 11:NullOnly 
		# 12:AllNulls 13:HalfNulls 0:all

MERGE_STACK  = 0	# usully F; if set, prepends "All" to directory name
			# 1:All 2:All-sac 3:All-apart 5:All-sac-apart

CC_INACT = 0	# Inactivation data?  0:no 1:lesion 2:control 3:both 11-13:LIP
		#    15: pre & post combined at an early stage (CC_TIME_COMBINE)
	     # On 3-2019, added LIP inactivation and broke '3'
CC_TIME  = 1	# -1:pre  0:peri   1:post
CC_TIME_COMBINE = F	# The analysis combined pre and peri (See forces below)

ONE_PLOT = 0 	# Just show one plot? (give # of plot) [1:PRR-PRR  4:LIP-LIP]
TWO_PLOT = 25	# [25] Use 10's & 1's places (e.g., 12 means plots 1 and 2)
DIFFERENCE_PLOT = F

CHRONUX = 1     # [1] -- -1 is pairwise phase consistency (PPC) <0 is unused?>
TW = 5 # 1.5		# [12] [8 for PRR->LIP vs LIP->PRR]
SHUFFLE = T
WIDE = 0		# [F] [4] Frequency start at this value (vs 12 or 14 Hz)

if (CC_INACT & CC_TIME_COMBINE) {		# If COMBINE, force these:
    CC_INACT = 15
    CC_TIME = 0
    }

 TWO_SIDED = T					# [F] 1 or 2-sided test?
 SHUFFLE_INDI = F				# [F] Are >15% of cells sig?
	#  Indi: sig based on length, plot is vector sum, so may mismatch
 SHUFFLE_LIMIT = 1020		# [500] Do no more than this (speed up or diag)
 OBSELETE_SHUFFLE = F	# [F] Shuffled in C by trial, vs in matlab by spike 
 if (CC_INACT==0 && OBSELETE_SHUFFLE & SHUFFLE_LIMIT > 148)
    cat("Ought to set SHUFFLE_LIMIT to 148 (beyond that, too few trials)\n")
    # grab exits if shuffle is > # trials. "du -s -k" the directory to see it

TIME_SHIFT = 0					# [0] Time shift?

InitPar = par(mar=c(0,2,5,0), las=1, xpd=T)
if (ONE_PLOT | DIFFERENCE_PLOT) {
   par(mfrow=c(1,1), oma=c(5.5,4,2.5,1))
 } else if (TWO_PLOT) {
   par(mfrow=c(1,2), oma=c(5.2,3.3,2,1))
 } else
   par(mfrow=c(2,3), oma=c(5.5,4,3,2))

Plots = c("PRR","cross","crossX2","LIP", "cross","crossX2")
Units = c(  "",  "PRR",   "PRR",   "",    "LIP",  "LIP")
#  Names are hardwired elsewhere - do not change them !!

NEAR.OVERRIDE =  2

#  DELAY PERIOD
  DIR.OVERRIDE = "GoCue_-800:0ms.N=500+"	# chronux or PPC, std or saconly
#  DIR.OVERRIDE = "GoCue_-800:0ms.N=100+"	# PPC (let's you smaller N)
#  DIR.OVERRIDE = "GoCue_-600:0ms.N=100+"	# PPC (let's you smaller N)
#  DIR.OVERRIDE = "GoCue_-800:0ms.N=200+"	# PPC (let's you smaller N)
#  DIR.OVERRIDE = "GoCue_-1000:0ms.N=200+"
#  DIR.OVERRIDE = "GoCue_-650:-150ms.N=500+"	# Test interval length effect!

#  BASELINE
#  DIR.OVERRIDE = "Target_-500:0ms.N=500+" #
#  DIR.OVERRIDE = "Target_-500:0ms.N=100+" #	# For mis2 (with PPC)

#  TARGET or CUE
#  DIR.OVERRIDE = "Target_50:550ms.N=500+" #
#  DIR.OVERRIDE = "Target_50:550ms.N=100+" #
#  DIR.OVERRIDE = "Target_50:550ms.N=200+" #
#  DIR.OVERRIDE = "Target_50:550ms.N=300+" #
#  DIR.OVERRIDE = "Target_50:550ms.N=400+" #

# DIR.OVERRIDE = "Target_50:450ms.N=300+" #
# DIR.OVERRIDE = "Target_50:350ms.N=500+" #
# DIR.OVERRIDE = "Target_50:350ms.N=100+" #
# DIR.OVERRIDE = "Target_50:350ms.N=200+" #



   # DIR.OVERRIDE = "SacOnlyGoCue_-800:0ms"	# Use to compare w/ (SACONLY=2)
   # DIR.OVERRIDE = "Target_800:1300ms"
   # DIR.OVERRIDE = "Target_-500:0ms"		# Better to use 'All'
   # DIR.OVERRIDE = "Target_-500:0ms_NoE"
					# Comment out that one line for doMany.r

if (MERGE_STACK)
   DIR.OVERRIDE = paste0(switch(MERGE_STACK,
			   "All", "All-sac", "All-apart", "", "All-sac-apart"),
			 DIR.OVERRIDE)

if (SACONLY==2)
   DIR.OVERRIDE = paste0("SacOnly", DIR.OVERRIDE)

if (SACONLY && MERGE_STACK)
   stop("SACONLY and MERGE_STACK should not mix")

if ((CHRONUX>0) & exists("TW"))
   DIR.OVERRIDE = paste0(DIR.OVERRIDE, "_TW=", TW)

if (MERGE_CLASS != 1)
   DIR.OVERRIDE = paste0(DIR.OVERRIDE, 
		 switch(MERGE_CLASS-9, "_pref","_null","_nulls","_Hnull"))

if (TIME_SHIFT)
   DIR.OVERRIDE = paste0(DIR.OVERRIDE, "_shift/", TIME_SHIFT)

if (DIFFERENCE_PLOT & ONE_PLOT)
   stop("Need two plots to make a difference")

if (DIFFERENCE_PLOT)
   SHUFFLE = F					# Not relevant for shuffles

if ((WIDE > 0) && (WIDE < 4))
   WIDE = 4

# -300:0 -350:50 -500:0

LOOP = T

SaveLengths = 0

for (pl in 1:6) {
     #if ((SACONLY|MIXED2) & (pl != 2 & pl != 5) & !ONE_PLOT)
     #  next
     if (ONE_PLOT & (pl != ONE_PLOT))
       next
     if (TWO_PLOT & (pl != TWO_PLOT%%10) && (pl != TWO_PLOT %/% 10))
       next

    AREA.OVERRIDE = Plots[pl]
    UNIT.OVERRIDE = Units[pl]
    MONK.OVERRIDE = ifelse(MIXED2, "tyr", "both")	# both, zen, tyr
    MONK.OVERRIDE = "both"	# both, zen, tyr
    source("main.r")

    # This should move to the individual calls in main.r
    if (PLOT.TYPE == "SignifSync") {
       par(xpd=NA)
       if (par()$mfg[2] == 1) { # 1st column?
          axis(2, at=YLIM*c(0,.5,1),
               labels=paste0(round(YLIM*c(0,.5,1)/CellCount*100,dig=1), "%"))
          save = par(mgp=c(4-4*(SACONLY>0),1,0))
          title(ylab="Coherent pairs (%)")
          par(save)
          }
       if (par()$mfg[1] == par()$mfrow[1]) {    # bottom row?
          axis(1, at=if (par("xlog")) 2^(2:7) else (0:3)*50, labels=T)
          title(xlab="Frequency (Hz)")
          }
       par(xpd=F)
       }
    }

mtext(paste0(MONK, if (NEAR) paste0("+",NEAR," mm"), "    ",
	     if (!CHRONUX) "Paired phase ",
	     round(ifelse(exists("MIN_FREQ"), MIN_FREQ, min(BANDS.SEQ)),dig=1),
	     " to ",
	     round(ifelse(exists("MAX_FREQ"), MAX_FREQ, max(BANDS.SEQ)),dig=1),
	     "Hz",
	     "\n",
	     directory,
	     "\n",
	     if (SACONLY == 1) "saconly block   ", 
	     if (SACONLY == 2) " (sac trials only)   ",
	     if (MIXED2) "mixed2 ",
      	     if (SHUFFLE) paste(MAX_SHUFFLE, "shuffles"),
	     if (SHUFFLE & CC_INACT) "   ",
	     switch(CC_INACT %% 10,
		    "cc_lesion", "cc_control", "cc_lesion+control"),
	     if (CC_INACT > 10) "_memory",
             if (CC_INACT)    c("Pre", "Peri", "Post")[2+CC_TIME]),
      side = 3, line = -1.5-(ONE_PLOT!=0)-(SACONLY>0), outer = T)

LOOP = F
rm(PLOT.TYPE)
if (exists("MIN_FREQ")) rm(MIN_FREQ)
if (exists("MAX_FREQ")) rm(MAX_FREQ)
par(InitPar)

# dev.off()

if (exists("MAX_SHUFFLE"))
   rm(MAX_SHUFFLE)
rm(SACONLY, MIXED2, CHRONUX, SHUFFLE, InitPar, Plots, Units, 
   NEAR.OVERRIDE, DIR.OVERRIDE, LOOP, pl, AREA.OVERRIDE, 
   UNIT.OVERRIDE, MONK.OVERRIDE)

# See individual differences
# cat(round(unname(
#	apply(amplitude[13:18,4,]-amplitude[13:18,5,], 2, mean)*1000)), "\n")

# readline("Enter to see histograms")
# par(mfrow=c(3,1))
# hist(colMeans(amplitude[14:18,4,]), nclass=50)
# hist(colMeans(amplitude[14:18,5,]), nclass=50)
# hist(colMeans(amplitude[14:18,4,]-amplitude[14:18,5,]), nclass=50)
# par(mfrow=c(1,1))
