# VectorLengthDiff.r
# (-mc)  (chronux)

#   called by main


if (!exists("OVERRIDE"))
   METHOD = ifelse(CHRONUX == -1, 1,
          2)    #   1:mean ampl -- Ignores cell alignment *with each other*
                #   * use '1' for PRR-PRR and for all  PC
                #   2:true vector sum (chronux & in-house may differ)
		#   * use '2' for LIP-PRR
                #   3:vector sum but of direction only (ditto on differ)
                #   4:percent signif cells in #3
                #   5:direction of vector sum of directions
                #   6: 


LOG = T		# [T]

		# Smoothing can do crazy things; avoid when possible
SHUFFLE.SMOOTH = .07	# [.07] [.1] [.001] [.15]  (.03 or lower has no effect?)
DATA.SMOOTH = 0.07	# [.07] [.1] [.001]   (for  data)

SEE.STARS  = 1		# 2: anova on stacks (needs shuffles)
PVAL.STAR = .001	# [.001]Tries for 2-sided
PVAL.PLUS = .01		#

PVAL.GRAY = "01"	# [".01"] shade based on SHUFFLing

SPAN = 0		# [0] or [10] ? Must be even  (used in 3 places)

if ((PVAL.GRAY != "05") && (PVAL.GRAY != "01") && (PVAL.GRAY != "001"))
   stop("Illegal Pval!")

THREE_TRACES = F	# [T]  T:together,apart,uni  F:all 5  -1:together,apart
AVERAGE_REACHES = F	# [0] show each [1] avg 4 reach tasks [2] all but apart
if (AVERAGE_REACHES & THREE_TRACES)
   stop("Cannot do average_reach AND three_traces!")

SHOW_INDI_99 = F	# [F]  Show the mean 99th %tile, or one per stack
PRINT_DIFFS = F		# [F]  Works for in-house but not chronux (non-int freq)
PRINT_STARS = F	# Report the frequencies with sig effects in text

PRINT_DATA_FOR_FIGURE = F	# Journal wants it?

if (DIFFERENCE_PLOT) {
   YLOW = ifelse(CHRONUX==-1, -.01, -.04) -.04
   YLIM = ifelse(CHRONUX==-1,  .01,  .04) +.04
 } else if (grepl("Target", DIR.OVERRIDE)) {
   if (CHRONUX == -1) {
      YLOW = -0.007 + ifelse(WIDE<8,.002, ifelse(MIXED2,.002, 0))
      YLIM =  0.008 + ifelse(WIDE<8,.028, ifelse(MIXED2,.002, 0))
    } else if (WIDE) {
      YLOW = ifelse(TW<3, 0.05, 0.00)
      YLIM = ifelse(TW<3, 0.35, 0.20)
    } else if (SACONLY) {
      YLOW = 0.04 + ifelse(TW>2, -.02, 0)
      YLIM = 0.08 + ifelse(TW>2, -.02, 0)

    } else if (MERGE_CLASS > 9) {
      YLOW = 0.03
      YLIM = 0.15
    } else {
      YLOW = 0	   + ifelse(TW<=1, 0.03, ifelse(TW<=1.5, .02, 0))
      YLIM = 0.09  + ifelse(TW<=1, 0.03, ifelse(TW<=1.5, .02, 0))
      if (MERGE_STACK == 0) {
         YLOW = YLOW + .03
         YLIM = YLIM + .01
         }
      }

 } else if (CHRONUX == -1) {
   YLOW = ifelse(MIXED2, -0.003, -0.002)		# -0.001
   YLIM = ifelse(MIXED2,  0.010,  0.007)		#  0.005

 } else if (SACONLY == 1) {
   YLOW = switch(METHOD, .02, .00, .00, 00, -3.15, -3.15) + .02*(TW<2)
   YLIM = switch(METHOD, .06, .03, .36, 20,  3.15,  3.15) + .02*(TW<2)

 } else if (CHRONUX==1) {
   YLOW = switch(METHOD, .025 + .01*(TW<8) - .025*(CC_INACT!=0),
					    .00, .00, 00, -3.15, -3.15)
   YLIM = switch(METHOD, .095, ifelse(ONE_PLOT,.03,.03),
				   		 .60, 20,  3.15,  3.15)
   if (METHOD==2 && OBSELETE_SHUFFLE & THREE_TRACES)
      YLIM =  0.02		#  DIAG: good for OBSELETE, THREE_TRACES
   if (METHOD==3 && OBSELETE_SHUFFLE)
      YLIM =  0.35
   if (METHOD==1 && MERGE_STACK) {
      YLOW = 0.01  + .02 * (MERGE_CLASS>1) + .02 * (TW<=1.5)
      YLIM = 0.075 + .02 * (MERGE_CLASS>1) + .02 * (TW<=1.5)
      }
   if ((METHOD==1) && (TW==2.5)) {
      YLOW = YLOW + .01
      YLIM = YLIM + .03
      if (MERGE_STACK) YLIM = YLIM - .02
      }
 } else {
   YLOW = -.5
   YLIM =  .5
   }


LoX = if (LOG) 14 else 12		# [8 or 14] [12?]
if (MERGE_STACK>0 & TW<3)
   LoX = 12
if (WIDE)
   LoX = WIDE

# if ((CHRONUX == -1) & !((METHOD == 5) | (METHOD == 6)))
#    stop("For PPC, use methods 5 or 6") -- WRONG!

Colors  = c("black","green","red","blue","purple")
Colors2 = c("black","green2","red","darkblue","purple")
if (stacks==3) {
   Colors  = Colors[c(1,4,5)]
   Colors2 = Colors2[c(1,4,5)]
   }
   

PLOT.TYPE = "VectorLength"

if (!exists("LOOP")) LOOP = F

# library(circular, warn.conflicts=F)

EffectSum = function(freq, stack, method=METHOD) {        # Pass it an index
        amp = c(amplitude[freq, stack, ])
        ang = c(angle    [freq, stack, ])

        if (length(amp) < 3) {
	   return(NA)
	   }

        if (method == 1) {      # Scalar mean of amplitude; ignore direction
           return(mean(amp, na.rm=T))
           }
        if (method == 2) {      # Vector sum of vectors -- return its *length*
           x = mean(amp * cos(ang), na.rm=T)
           y = mean(amp * sin(ang), na.rm=T)
           return(sqrt(x^2+y^2))
           }
        if (method == 3) {      # Vector sum of direction; ignore amplitude
           return(sqrt(mean(sin(ang), na.rm=T)^2 + mean(cos(ang), na.rm=T)^2))
           }
        if (method == 5) {      # Direction of vector sum (for ?)
           x = mean(amp * cos(ang), na.rm=T)
           y = mean(amp * sin(ang), na.rm=T)
           return(atan2(y,x));
           }
        if (method == 6) {      # Direction of unit vector sum (ignore ampl)
           x = mean(cos(ang), na.rm=T)		#  (for ?)
           y = mean(sin(ang), na.rm=T)
           return(atan2(y,x));
           }
        stop("Unknown METHOD")
        }

Lowess <- function(x, m) {
	Smoothed = matrix(NA, nrow=length(BANDS.SEQ), ncol=stacks)
		# Pick just the relevant stacks
	for (i in if (stacks==5) {	# stacks is 5 or 3
		      switch(2+THREE_TRACES, 4:5, 1:5, 2:5)
		   } else if (stacks==3) {
		      switch(2+THREE_TRACES, 2:3, 1:3, 2:3)
		   } else if (stacks==1)
		      1)
	   Smoothed[,i] = lowess(BANDS.SEQ, x[,i], f=SHUFFLE.SMOOTH)$y

        return(apply(Smoothed, 1, m, na.rm=T))
        }

# colnames = c("freq","cohere","c_rads","sync","s_rads","pval","type","unit")


lengthAng =
lengths = matrix(NA, nrow=length(BANDS.SEQ), ncol=5)

for (freq in 1:BANDS)			# Average over each site to get a single
 if (SACONLY) {
    lengths[freq,1] = EffectSum(freq, 1)
 } else if (AVERAGE_REACHES) {
    lengths[freq,1] = EffectSum(freq, 1)
    lengths[freq,2] = 
    if (AVERAGE_REACHES == 2) {
     (EffectSum(freq,2)+EffectSum(freq,3)+EffectSum(freq,4))/3
     } else   # AVERAGE_REACHES == 1
     (EffectSum(freq,2)+EffectSum(freq,3)+EffectSum(freq,4)+EffectSum(freq,5))/4
 } else {
    for (st in 1:stacks) {		#  length for each frequency and stack
      lengths[freq,st] = EffectSum(freq, st)
      lengthAng[freq,st] = EffectSum(freq, st, method=3) # Sum of unit vectors
      }
    }

if (PRINT_DIFFS) {
  # To use with Chronux, must rewrite to handle non-int freq
  FreqToIndex = function(freq) return(which(BANDS.SEQ %in% freq))
  # IndexToFreq = function(index) return(BANDS.SEQ[index])

  for (file in (1:dim(amplitude)[3]))
   cat(sprintf(" %4d %4d   %4d\n",
     1000*round(
	     mean(amplitude[FreqToIndex(24):FreqToIndex(38), 4, file]), dig=3),
     1000*round(
	     mean(amplitude[FreqToIndex(24):FreqToIndex(38), 5, file]), dig=3),
     1000*round(
	     mean(amplitude[FreqToIndex(24):FreqToIndex(38), 4, file]) -
             mean(amplitude[FreqToIndex(24):FreqToIndex(38), 5, file]), dig=3)))
  cat(sprintf(" %4.1f %4.1f   %4.1f\n",
     1000*round(
	     mean(amplitude[FreqToIndex(24):FreqToIndex(38), 4, ]), dig=4),
     1000*round(
	     mean(amplitude[FreqToIndex(24):FreqToIndex(38), 5, ]), dig=4),
     1000*round(
	     mean(amplitude[FreqToIndex(24):FreqToIndex(38), 4, ]) -
             mean(amplitude[FreqToIndex(24):FreqToIndex(38), 5, ]), dig=4)))
  }

if (DIFFERENCE_PLOT & (SHUFFLE <= 0) & all(SaveLengths==0)) {
   SaveLengths <<- lengths
   SaveAmplitude <- amplitude
   cat("N for 1st set:", CellCount, "\n")
} else
 if (SHUFFLE <= 0) {			# Shuffle loop:   Iteration number (1:N)
					# Done with loop: "-1"
					# No shuffling:   "0"
					# Really want to exit if > 0

 par(las=1, xpd=NA)
 plot(1,0,
     xlim=c(LoX, 128), 			# [150?]
     ylim=c(YLOW,YLIM),
     type='n', axes=F, log=ifelse(LOG,"x",""), xlab="", ylab="")

 if (par()$mfg[2] == 1) {	# 1st column?
   axis(2)
   save = par(mgp=c(4,1,0))
   title(ylab=
     if (CHRONUX==-1) "PPC statistic" else
     switch(METHOD, "Mean vector lengths (0 to 1)", "Coherence (vector sum)",
	    	    "Vector sum (angle only)", "Significant cells (%)",
		    "Direction of vector sum",
		    "Direction of unit vector sum"))
   par(save)
  } else
   axis(2, labels=F)

 if (par()$mfg[1] == par()$mfrow[1]) {	# bottom row?
   axis(1, at=if (par("xlog")) 2^(ceiling(log2(LoX)):7) else (0:4)*30, labels=T)
   title(xlab="Frequency (Hz)")
  } else
   axis(1, at=if (par("xlog")) 2^(4:7) else (0:4)*30, labels=F)
 par(las=0, xpd=F)


 if (SHUFFLE && !is.null(shuffle_50)) {		# Will be "-1"
    # signif = Lowess(shuffle_999, mean)
    # lines(BANDS.SEQ, signif, col=gray(.75), lwd=1) # , lty="dashed")
    signif = Lowess(get(paste0("shuffle_", 100-as.numeric(PVAL.GRAY))), mean)
    lines(BANDS.SEQ, signif, col=gray(.5), lwd=1) # , lty="dashed")
    if (TWO_SIDED) {
       signif = Lowess(get(paste0("shuffle_", PVAL.GRAY)), mean)
       lines(BANDS.SEQ, signif, col=gray(.5), lwd=1) # , lty="dashed")
       }
    rm(signif)

    for (st in 1:stacks) {			# Start with heavy lines
        if ((THREE_TRACES==T) & (st < 3))	# Skip sac, and meld unis?
	   next;
        if ((THREE_TRACES==-1) & st < 4)
	   next;
        if (THREE_TRACES & st == 3) {		# Meld unis
           observed = (lowess(BANDS.SEQ, lengths[,2], f=DATA.SMOOTH)$y +
                       lowess(BANDS.SEQ, lengths[,3], f=DATA.SMOOTH)$y) / 2
	   # errbar = 1000
	   st = 2	# Individual median will be wrong, but close enough
	 } else {
           observed = lowess(BANDS.SEQ, lengths[,st], f=DATA.SMOOTH)$y
           # errbar   = lowess(BANDS.SEQ, shuffle_95[,st], f=SMOOTH)$y
	   }
        lines(BANDS.SEQ, observed,
         	col=Colors[st],
	 	lwd=5)	# Non-sig parts will be masked by GRAY shading!
        }

     # 1- or 2-sided P < GRAY -- take mean OR extreme value of (relevant) stacks
     ShadeUp = Lowess(get(paste0("shuffle_", 100-as.numeric(PVAL.GRAY))), mean)
     if (TWO_SIDED) {
        ShadeDn = Lowess(get(paste0("shuffle_", PVAL.GRAY)), mean)
        polygon( c( BANDS.SEQ, rev(BANDS.SEQ), BANDS.SEQ[1]),
		 c( ShadeUp,   rev(ShadeDn),   ShadeUp[1]),
        	col=gray(.90),			# NOT transparent - a mask!
        	border="gray", lwd=.5)
      } else {
        polygon( c( BANDS.SEQ, max(BANDS.SEQ), min(BANDS.SEQ), BANDS.SEQ[1]),
		 c( ShadeUp, YLOW, YLOW, ShadeUp[1]),
        	col=gray(.90),			# NOT transparent - a mask!
        	border="gray", lwd=.5)
        }

     for (st in 1:stacks) {
        if ((THREE_TRACES==T) & (st < 3))	# Skip sac, and meld unis?
	   next;
        if ((THREE_TRACES==-1) & st < 4)
	   next;
        if (THREE_TRACES & (st == 3)) {	# Meld unis
           observed = (lowess(BANDS.SEQ, lengths[,2], f=DATA.SMOOTH)$y +
                       lowess(BANDS.SEQ, lengths[,3], f=DATA.SMOOTH)$y) / 2
	   st = 2	# Individual median will be wrong, but close enough

	   if (SHOW_INDI_99)
              lines(lowess(BANDS.SEQ, shuffle_99[,st], f=SHUFFLE.SMOOTH),
     	      	    col=Colors[st], lwd=1, lty="dashed")
	   # errbar = 1000
	 } else {
           observed = lowess(BANDS.SEQ, lengths[,st], f=DATA.SMOOTH)$y
           # errbar   = lowess(BANDS.SEQ, shuffle_95[,st], f=SMOOTH)$y
	   if (SHOW_INDI_99 && (st > 3))
              lines(lowess(BANDS.SEQ, shuffle_99[,st], f=SHUFFLE.SMOOTH),
     	      	    col=Colors[st], lwd=1, lty="dashed")
	   }

        lines(BANDS.SEQ, observed,
         	col=Colors[st],
	 	lwd=2.5)

        # EACH STACK'S INDIVIDUAL MEDIAN
        lines(lowess(BANDS.SEQ, shuffle_50[,st], f=SHUFFLE.SMOOTH),
         	col=Colors2[st],
                lwd=1, lty="dotted")
	if (st==2) {			# thin dashed green is hard to see
 	  widen = (YLIM-YLOW)/400
          lines(lowess(BANDS.SEQ, shuffle_50[,st]+widen, f=SHUFFLE.SMOOTH),
         	col=Colors2[st],
                lwd=1, lty="dotted")
          lines(lowess(BANDS.SEQ, shuffle_50[,st]-widen, f=SHUFFLE.SMOOTH),
         	col=Colors2[st],
                lwd=1, lty="dotted")
	  rm(widen)
          }

        if (PRINT_DATA_FOR_FIGURE) {
	   if (CHRONUX == 1)
               sink("Figure5c_Data.text", append=T)
             else if (CHRONUX == -1)
               sink("FigureS12_Data.text", append=T)
             else
               stop("Do not know which figure I am writing data for")

           cat("Task ", switch(st,
               "Saccade","Ipsi reach","Contra reach","Together","Apart"),"\n")
           print(lowess(BANDS.SEQ, lengths[,st], f=DATA.SMOOTH))

           sink()
           }
        }

     polygon(c(20, 20, 35, 35, 20),
	     c( YLOW, YLIM, YLIM, YLOW, YLOW),
	   col=adjustcolor("gray",alpha.f=.4),
	   border=NA)
     segments(25, YLOW, 25, YLIM*.98, lty="dashed",
	      			col=adjustcolor("gray", alpha.f=.8))
     segments(30, YLOW, 30, YLIM*.98, lty="dashed",
	     			 col=adjustcolor("gray", alpha.f=.8))

     if (SEE.STARS == 1) {
     # Signif stars: product of summed magnitudes and summed unit vectors
     #   p <.01, two-sided
     #   Stars are blue for both > apart, purple for apart > both, but this
     #   may not align with order of coherence *magnitude* (confusing!)
     #   Only done with shuffles, not sure why that is
     par(xpd=NA)
     if (METHOD == 2)
        Difff = lowess(BANDS.SEQ, lengths[,4], f=DATA.SMOOTH)$y -
                lowess(BANDS.SEQ, lengths[,5], f=DATA.SMOOTH)$y

     # if (THREE_TRACES && (stacks == 5))	# Stats are amplitude AND angle!
     if (!MERGE_STACK &&			# There is not stack 4!
	 (SACONLY == 0) &&
	 (METHOD < 5) &&			# Methods 5 & 6 have no angle?
	 (length(amplitude[11,4,]) > 2) &&	# Enough observations?
	 (CHRONUX != -1))			# PPC has no angle
       for (ii in (1+SPAN) : (BANDS-SPAN)) {	# Loop thru freq bands
	  span = (ii-SPAN/2):(ii+SPAN/2)
          ampl4 = apply(amplitude[span,4,], 2, mean)
          ampl5 = apply(amplitude[span,5,], 2, mean)

          AmpP  = t.test(ampl4, ampl5, pair=T, alt="g")$p.value
          AmpP2 = t.test(ampl4, ampl5, pair=T, alt="l")$p.value
          AmpP3 = t.test(ampl4, ampl5, pair=T)$p.value

          # These tests of angular difference do not jibe with method 3 results:
          # AngP = watson.williams.test(list(together = angle[i,4,],
          # 				     apart = angle[i,5,]))$p.value
          # AngP = watson.wheeler.test (list(together = angle[i,4,],
          #				     apart = angle[i,5,]))$p.value

	  # So do a permutation test instead.  Use vector sum of unit vectors

	  PermutedAngles4 = apply(AngleL4[span,], 2, mean)
	  PermutedAngles5 = apply(AngleL5[span,], 2, mean)
	  ObservedAngle4 = mean(lengthAng[span,4])
	  ObservedAngle5 = mean(lengthAng[span,5])
	  ampl4 = mean(ampl4)
	  ampl5 = mean(ampl5)

          AngP = sum(	# How many of the permuted vectors exceed the observed?
		 abs(PermutedAngles4 - PermutedAngles5) >  # permuted
		 abs(ObservedAngle4  - ObservedAngle5)	   # observed
		 ) / length(AngleL1[1,])	# convert to fraction

	  # Check signs. 
          AngSign = (ObservedAngle4 - ObservedAngle5) > 0
	  AmpSign = (ampl4 - ampl5) > 0
	  AmpAngSign = (ObservedAngle4*ampl4 - ObservedAngle5*ampl5) > 0
	   # For method 2, non-linear so use actual plotted line,too
	   # But if one is + and one minus, will get it wrong, so do
	   # the test of the plotted line instead (below).  Could do
	   # both, but gets messy, so why bother?

          if ((switch(METHOD, AmpP, AmpP*AngP, AngP) < PVAL.STAR/2) & 
              # (switch(METHOD, AmpSign, AmpAngSign & (Difff[ii]>0), AngSign)))
              (switch(METHOD, AmpSign, Difff[ii]>0, AngSign)))
             text(BANDS.SEQ[ii], YLIM*1.025,     "*", col="blue")
          if ((switch(METHOD, AmpP2, AmpP2*AngP, AngP) < PVAL.STAR/2) &
              ! (switch(METHOD, AmpSign, 
		# !((AmpAngSign<0) & (Difff[ii]<0)), # craziness needed for both
			  Difff[ii]>0,
			  AngSign)))
             text(BANDS.SEQ[ii], YLIM*1,         "*", col="purple")
          if (switch(METHOD, AmpP3, AmpP3*AngP, AngP) < PVAL.STAR)
             text(BANDS.SEQ[ii], YLIM*1.050,     "*", col="orange")
          }
         }					# End of 'if see stars'
       par(xpd=F)

    } else {					# If not a shuffle
       polygon(c(20, 20, 35, 35, 20),		# Used to be 20-38 Hz
	   c( YLOW, YLIM, YLIM, YLOW, YLOW),
	   col=adjustcolor("gray",alpha.f=.4),
	   border=NA)
       segments(25, YLOW, 25, YLIM*.98, col=adjustcolor("gray", alpha.f=.8))
       segments(30, YLOW, 30, YLIM*.98, col=adjustcolor("gray", alpha.f=.8))
       if (YLOW < 0) {
          segments(LoX, 0, 128, 0, col="black") # adjustcolor("gray", alpha.f=.8))
          # segments(LoX, 0, 128, 0, col=adjustcolor("gray", alpha.f=.8))
	  }
       for (st in 1:stacks) {
	  if (stacks > 4) {
             if ((THREE_TRACES==T) & (st < 3))	# Skip sac, and meld unis?
	        next;
             if ((THREE_TRACES==-1) & st < 4)
	        next;
             if (THREE_TRACES & st == 3) {	# Meld unis
	        lengths[,2] = (lengths[,2] + lengths[,3]) / 2
	        st = 2				# Not critical; makes it green
                }
	     }
          lines(lowess(BANDS.SEQ, 
		       if (DIFFERENCE_PLOT) 
			  SaveLengths[,st] - lengths[,st] else 
		          lengths[,st],
	               f=DATA.SMOOTH),
         	col=Colors[st],
	 	lwd=4)
          if (PRINT_DATA_FOR_FIGURE) {
	     if (CHRONUX == 1)
                sink("Figure5c_Data.text", append=T)
              else if (CHRONUX == -1)
                sink("FigureS12_Data.text", append=T)
              else
                stop("Do not know which figure I am writing data for")

             cat("Task ", switch(st,
                "Saccade","Ipsi reach","Contra reach","Together","Apart"),"\n")
             print(lowess(BANDS.SEQ, lengths[,st], f=DATA.SMOOTH))

             sink()
             }
	  }
       }

 if (DIFFERENCE_PLOT) {				# Statistics
    cat("N for 2nd set:", CellCount, "\n")
    for (ii in (1+SPAN) : (BANDS-SPAN)) {	# Loop thru freq bands
	 span = (ii-SPAN/2):(ii+SPAN/2)
         for (st in 1:stacks) {
	    if (length(span) > 1) {
	       PL = apply(SaveAmplitude[span,st,], 2, mean)
	       LP = apply(    amplitude[span,st,], 2, mean)
	     } else {
	       PL = SaveAmplitude[span,st,]
	       LP =     amplitude[span,st,]
	       }
	    LP = LP[!is.nan(LP)]
	    PL = PL[!is.nan(PL)]

            AmpP = t.test(PL, LP)$p.value
	    dif  = mean(PL) > mean(LP)

	    if (AmpP < PVAL.PLUS)
               text(BANDS.SEQ[ii], ifelse(dif,YLIM,YLOW)*(.8+.05*st),
		    "*", cex = 1 + (AmpP<PVAL.STAR), col=Colors[st])
	    }
	 }
    }


 if ((SEE.STARS==2) & (MERGE_STACK==0)) {	# Compare individual stacks
    par(xpd=NA)
    Hz = NULL
    Sigs = NULL
    Sig.no_sac = NULL
    for (ii in which(BANDS.SEQ > LoX)) {	# Loop thru freq bands
        d.values = c(amplitude[ii,,]) # stacks x files -> collapse
	d.stacks = as.factor(rep(StackList, each=length(files)))
	d.sets   = as.factor(rep(1:length(files),times=length(StackList)))

	Hz = c(Hz, ii)
	Sigs = c(Sigs,
	     summary(aov(d.values ~ d.stacks + Error(d.sets)))[[2]][[1]][1,5])

	no_sac = (d.stacks!=64)
	d.values = d.values[no_sac]
	d.stacks = d.stacks[no_sac]
 	d.sets   = d.sets[no_sac]
	Sig.no_sac = c(Sig.no_sac, 
	     summary(aov(d.values ~ d.stacks + Error(d.sets)))[[2]][[1]][1,5])
        }

    text(BANDS.SEQ[Hz], YLIM*1.030, 
	 ifelse(Sigs<PVAL.STAR, "*",
	 ifelse(Sigs<PVAL.PLUS, "+", "")), 
	 col="orange")
    text(BANDS.SEQ[Hz], YLIM*1.015, 
	 ifelse(Sig.no_sac<PVAL.STAR, "*",
	 ifelse(Sig.no_sac<PVAL.PLUS, "+", "")),
	 col="red")

    if (all(par()$mfg[1:2] == par()$mfrow[1:2])) {	# last panel?
       text(145, YLIM*1.035, "anova", col="orange", adj=1, cex=.8)
       text(140, YLIM*1.015, "no sacs",  col="red", adj=1, cex=.8)
       }
    }


 if ((METHOD == 1) && (SEE.STARS==1)) {		# Do various t-tests
    par(xpd=NA)
    TestStack = ifelse(AVERAGE_REACHES, 1,	# 1+2 (sac+reach)
		ifelse(CC_INACT %/% 10, 2, 4))	# 2+3 or 4+5 (together, apart)

    if (AVERAGE_REACHES & (pl==2)) {
	save_A = NULL
	save_B = NULL
	save_row = 1
        }

    for (i in (1+SPAN):(BANDS-SPAN)) {	# Loop thru freq bands
    	Hz = BANDS.SEQ[i]
        if (Hz < LoX) next
	if (SPAN) {
	     span = (i-SPAN/2):(i+SPAN/2)
             amplA = apply(amplitude[span,TestStack,], 2, mean)
	     if (!SACONLY)
             amplB = apply(amplitude[span,TestStack+1,], 2, mean)
          } else {
             amplA = amplitude[i,TestStack,]
	     amplA = amplA[!is.nan(amplA)]
	   	# a few in SACONLY data - have not tracked down LHS 2020-08-10
	     if (!SACONLY)
             amplB = amplitude[i,TestStack+1,]
	     amplB = amplB[!is.nan(amplB)]
	     }
         if (AVERAGE_REACHES & (pl==2)) {
	     save_A = rbind(save_A, amplA)
	     save_B = rbind(save_B, amplB)
	     }

         if (!AVERAGE_REACHES) {
            Pval = t.test(amplA, amplB, pair=T)$p.value
            if (Pval < PVAL.STAR) {
               text(Hz, YLIM*1.05,     "*", col="orange")
	     } else if (Pval < PVAL.PLUS)
               text(Hz, YLIM*1.05,     "+", col="orange")
	  } else if (pl == 5) {
            Pval = t.test(amplA, save_A[save_row,])$p.value
            if (Pval < PVAL.STAR) {
               text(Hz, YLIM *
		    ifelse(mean(amplA)<mean(save_A[save_row,]), 0.95, 1.04),
		    "*", col="black")
	       if (PRINT_STARS) cat(paste0(round(Hz), "s "))	# s = saccade
	     } else if (Pval < PVAL.PLUS)
               text(Hz, YLIM*1.03,     "+", col="black")
            Pval = t.test(amplB, save_B[save_row,])$p.value
            if (Pval < PVAL.STAR) {
               text(Hz, YLIM *
		    ifelse(mean(amplB)<mean(save_B[save_row,]), 0.94, 1.03),
		    "*", col="green")
	       if (PRINT_STARS) cat(paste0(round(Hz), "r "))	# r = reach
	     } else if (Pval < PVAL.PLUS)
               text(Hz, YLIM*1.02,     "+", col="green")
	    if (save_row == 1) {		# First time through
	       mtext("Stars compare the 2 diretions",
		     	side=1, line=4, outer=T, adj=1, cex=.6, font=2)
	       }
	    save_row = save_row + 1
	    }
	}
    if (AVERAGE_REACHES & (pl==5)) {
       if (PRINT_STARS) cat("-- Sac, Reach\n")
       text(9, YLIM * 0.93, "PRR>LIP", cex=.6)
       text(9, YLIM * 1.05, "LIP>PRR", cex=.6)
       }
    }


 if (DIFFERENCE_PLOT) {
   title(main = paste0("\n", AREA, "(difference)"),
	 cex.main=1.4, font.main=2)
   title(main = paste("\n\n\n\nn=", CellCount), cex.main=.9)
  } else if (LOOP) {
   title(main = paste0("\n", AREA, if (UNIT!="") paste0(" (units:", UNIT, ")")),
	 cex.main=1.4, font.main=2)
   title(main = paste("\n\n\n\nn=", CellCount), cex.main=.9)
  } else
   title(main = paste0(MONK, "  ", AREA, if (NEAR) paste0("+",NEAR),
                                           " (n=", CellCount, ")"))

 if (all(par()$mfg[1:2] == par()$mfrow[1:2])) {	# last panel?
   if (CHRONUX==1) {
      mtext(paste0(
        "Chronux, method ", METHOD, ": ",
        switch(METHOD, "Mean amplitude", "Weighted vector sum",
	    	    "Vector sum (angle only)", "% Significant cells",
		    "Direction of vector sum",
		    "Direction of unit vector sum"),
        if (DATA.SMOOTH > 0.03) paste0("; smooth=", DATA.SMOOTH), 
        ", TW=", TW,
	if (AVERAGE_REACHES) ", green=g+r+b", 
	if (AVERAGE_REACHES==1) "+p",
        if ((SEE.STARS==1) & SHUFFLE)
	    paste0(", ", 
		   ifelse(TWO_SIDED,"2","1"), "-sided", 
		   if (SPAN) paste0(", span=", SPAN),
		   ", P=", PVAL.STAR),
	if (SEE.STARS==2)
	    paste0(", P<", PVAL.STAR),
	if (SHUFFLE)
	    paste0(", gray=0.", PVAL.GRAY)
	),
	    side=1, line=4, outer=T, adj=-.2, cex=.6, font=2)
    } else if (CHRONUX==-1) {
      mtext(paste0(
        "Paired phase, method ", METHOD,
        if (DATA.SMOOTH > 0.03) paste0("; smooth=", DATA.SMOOTH), 
	if (AVERAGE_REACHES) ", green=g+r+b", 
	if (AVERAGE_REACHES==1) "+p",
        if (SHUFFLE)
	    paste0(", ", 
		   ifelse(TWO_SIDED,"2","1"), "-sided", 
		   if (SPAN) paste0(", span=", SPAN),
		   ", Pvals *=", PVAL.STAR, ", gray=0.",PVAL.GRAY)
	),
	    side=1, line=4, outer=T, adj=-.1, cex=.6, font=2)
    } else
      stop("Use either chronux (CHRONUX=1) or PPC (-1) in this file")

   if (SACONLY) {
    mtext("Saccade", col=1, side=3, line=-2.3, outer=T, adj=1, cex=.8, font=2)
   } else {
    if (MERGE_STACK != 2 && MERGE_STACK != 5)
       mtext("Saccade",  col=1, side=3, line= 0.9, outer=T,adj=1, cex=.8,font=2)
    if (AVERAGE_REACHES) {
      mtext("Reach",     col=3, side=3, line= 0.1, outer=T,adj=1, cex=.8,font=2)
     } else {
      mtext("Ipsi",      col=3, side=3, line= 0.1, outer=T,adj=1, cex=.8,font=2)
      mtext("Contra",    col=2, side=3, line=-0.7, outer=T,adj=1, cex=.8,font=2)
      mtext("Together",  col=4, side=3, line=-1.5, outer=T,adj=1, cex=.8,font=2)
      if (MERGE_STACK != 3 && MERGE_STACK != 5)
        mtext("Apart",col="purple",side=3,line=-2.3,outer=T,adj=1,cex=.8,font=2)
      }
    }
   }
 }

rm(PRINT_DIFFS)
