# Select.r
#   Pick the right files to run (using cell database)

UNIT_MUST_HAVE_PD = F
verbose = F
###########################################################################
if (verbose)
   cat("Enter Select\n")

options(stringsAsFactors = FALSE)

if (!exists("SACONLY"))
   SACONLY = F
if (!exists("MIXED2"))
   MIXED2 = F

if (!exists("UNIT_MUST_HAVE_PD"))
   UNIT_MUST_HAVE_PD = F

a = b = NULL
if (CC_INACT < 10)			#  no memory for zen
 if (MONK=="zen" || MONK=="both") {
   a = read.table(
	paste0("/data/coord/zen/zenunits", 
		if (SACONLY==1)    "_saconly",
		if (CC_INACT > 10) "_memory",
		if (CC_INACT)
		  ifelse((CC_INACT%%10) == 1, "_cc_inactivate", "_cc_control")),
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   if ((CC_INACT%%10) > 2)
      a = rbind(a,read.table(
	paste0("/data/coord/zen/zenunits",
	        if (CC_INACT > 10) "_memory",
	        		   "_cc_inactivate"),	# INACT is 3, 4 or 5
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE))
   a = cbind(a, monk="zen")		# Append monkey name (as a column)
   }
if (MONK=="tyr" || MONK=="both") {
   b = read.table(paste0("/data/coord/tyr/tyrunits", 
		if (SACONLY==1)    "_saconly",
	       	if (MIXED2  )      "_mixed2",
		if (CC_INACT > 10) "_memory",
		if (CC_INACT)
		 ifelse((CC_INACT%%10) == 1, "_cc_inactivate", "_cc_control")),
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   if (CC_INACT)
    if ((CC_INACT%%10) > 2)
      b = rbind(b,read.table(
	paste0("/data/coord/tyr/tyrunits",
	        if (CC_INACT > 10) "_memory",
	        		   "_cc_inactivate"),	# INACT is 3, 4 or 5
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE))
   b = cbind(b, monk="tyr") 		# Append monkey name (as a column)
   }
base = rbind(a,b)			# Required for 'both'
rm(a,b)

if (CC_INACT)				# Pick pre, peri or post-inject
   base = base[ grepl(paste0("\\.",CC_TIME+2), base[,"reach_file"]), ]


if (CC_INACT)
 if ((CC_INACT%%10)==4) {		# Do baseline ALONG WITH controls
   base.lesion = base
   if (MONK=="zen" || MONK=="both") {
      a = read.table(
	paste0("/data/coord/zen/zenunits"),
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
      a = cbind(a, monk="zen")		# Append monkey name (as a column)
      }
   if (MONK=="tyr" || MONK=="both") {
      b = read.table(
	paste0("/data/coord/tyr/tyrunits"),
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
      b = cbind(b, monk="tyr") 		# Append monkey name (as a column)
      }
   base = rbind(a, b)
   source("/data/coord/grab/Nearest.r")
   base = rbind(base, base.lesion)
   }

if (NEAR && (CC_INACT==0)) {
   # source("/data/coord/grab/spike-lfp/R/Nearest.r")
   if (verbose)
      cat("Call Nearest\n")
   source("/data/coord/grab/Nearest.r")
   }

base[is.na(base)] = "-1"		# Else get NA's when test if == AREA

if (verbose)
   cat(MONK, AREA, "\n")

FilesToDo = NULL
MonksToDo = NULL

while (grepl("base", search()[2]))
	        detach(2)
# attach(data.frame(base, stringsAsFactors=FALSE))

# base = cbind(base, lfp.hem=NA)		# track hemisphere of lfp (vs spike)	 Commented out end of May 2017 - ok?

for (jjj in 1:3)
 for (kkk in (jjj+1):4) {
   if (AREA=="cross" || AREA=="crossX2") {
      index = (
	(((base[,paste0("area",jjj)]=="LIP") &
	  (base[,paste0("area",kkk)]=="PRR")) |
	 ((base[,paste0("area",jjj)]=="PRR") &
	  (base[,paste0("area",kkk)]=="LIP"))) &
	if (AREA=="cross")
	 ((base[,paste0("hem", jjj)] == base[,paste0("hem",kkk)])) else
	 ((base[,paste0("hem", jjj)] != base[,paste0("hem",kkk)])))

      index.2 = index &
	 (base[,paste0("lfp",jjj)]==1) & (base[,paste0("unit",kkk)]==1)

      if (UNIT!="")			# specifies which area the unit is in
	 index.2 = index.2 & base[,paste0("area",kkk)]==UNIT

      if (UNIT_MUST_HAVE_PD)			# Only take tuned units?
	  index.2 = index.2 & (base[,paste0("pd",kkk)] > 0)
        
      if (any(index.2, na.rm=T)) {
	 #FilesToDo = c(FilesToDo, paste0(reach_file[index.2],"_",jjj,"_",kkk-1))
	 FilesToDo = c(FilesToDo, paste0(base[index.2,"reach_file"],"_",jjj,"_",kkk-1))
	 # MonksToDo = c(MonksToDo, monk[index.2])
	 MonksToDo = c(MonksToDo, base[index.2, "monk"])
	 }

      index.3 = index &
	 (base[,paste0("lfp",kkk)]==1) & (base[,paste0("unit",jjj)]==1)

      if (UNIT!="")
	 index.3 = index.3 & base[,paste0("area",jjj)]==UNIT

      if (UNIT_MUST_HAVE_PD)			# Only take tuned units?
	  index.3 = index.3 & (base[,paste0("pd",jjj)] > 0)
        
      if (any(index.3, na.rm=T)) {
	 # FilesToDo = c(FilesToDo, paste0(reach_file[index.3],"_",kkk,"_",jjj-1))
	 FilesToDo = c(FilesToDo, paste0(base[index.3,"reach_file"],"_",kkk,"_",jjj-1))
	 # MonksToDo = c(MonksToDo, monk[index.3])
	 MonksToDo = c(MonksToDo, base[index.3,"monk"])
	 }
      }

   # Just one area:
   if (AREA=="LIP" || AREA=="PRR") {
      index = (base[,paste0("area",jjj)]==AREA) & 
	      (base[,paste0("area",kkk)]==AREA)
      index = index &
    	      (base[,paste0("hem", jjj)] != base[,paste0("hem",kkk)])
      if (verbose) cat("Test: (", jjj, kkk, ")   ",
		sum(base[,paste0("area",jjj)]==AREA, na.rm=T), 
		sum(base[,paste0("area",kkk)]==AREA, na.rm=T),
		sum(base[,paste0("hem",jjj)]!=base[,paste0("hem",kkk)],na.rm=T),
       	        "\n")

      index.2 = index &
    		(base[,paste0("lfp",jjj)]==1) & (base[,paste0("unit",kkk)]==1)
      if (UNIT_MUST_HAVE_PD)			# Only take tuned units?
	  index.2 = index.2 & (base[,paste0("pd",kkk)] > 0)
      if (any(index.2, na.rm=T)) {
         FilesToDo = c(FilesToDo, 
		       paste0(base[index.2,"reach_file"],"_",jjj,"_",kkk-1))
         MonksToDo = c(MonksToDo, base[index.2,"monk"])
         }

      index.3 = index &
    		(base[,paste0("lfp",kkk)]==1) & (base[,paste0("unit",jjj)]==1)
      if (UNIT_MUST_HAVE_PD)			# Only take tuned units?
	  index.3 = index.3 & (base[,paste0("pd",jjj)] > 0)
      if (any(index.3, na.rm=T)) {
         FilesToDo = c(FilesToDo, 
		       paste0(base[index.3,"reach_file"],"_",kkk,"_",jjj-1))
         MonksToDo = c(MonksToDo, base[index.3,"monk"])
         }
      }
   }

# detach(2)
if (verbose)
   cat("Exit Select\n")
