# ManyShiftVsFreq.r
	# Use GoCue_-800:0msN=500+ unless PPC: -600:0ms.N=100+


PLOT_FREQ = T		# Print data OR plot versus freq

TW.LOOPS      = 8	# c(6,8,12)	# 2.5, 4, 5, 6, 8, 12
METHOD.LOOPS  = 1	# -1, 1, 2 (PPC - no!  Use CHRONUX, sum, vectors)
PL.LOOPS      = 2 	# 2 # c(2,5)	#  1:6

LOG	      = 1	# Log plot? (x axis)

CHRONUX.OVERRIDE =     -1		# -1 for PPC
MERGE_STACK.OVERRIDE = 1		# [0,1,2] Used in doShift.r !

DIRECTORY.OVERRIDE =			# Pick just one!
   #  "GoCue_-800:0ms.N=500+"  # Standard for delay period
   # "Target_-500:0ms.N=500+"  # ITI (with merge-stack = 1)
   # "Target_50:550ms.N=500+"  # Cue (merge-stack = 0 or 1)
   # "Target_50:550ms.N=300+"  # Cue (only merge_stack = 0)
   # "Target_50:450ms.N=300+"  # Cue (only merge_stack = 1)
   # "Target_50:350ms.N=300+"  # Cue (only merge_stack = 1)
    "Target_50:350ms.N=100+"  # Cue (only merge_stack = 1)


TIMES.OVERRIDE = c(seq(2,20,2),seq(24,40,4),48, 56, seq(64,128, by=16))
# TIMES.OVERRIDE = c(seq(2,20,2),seq(24,40,4),48,56) # DIAG

TIMES.OVERRIDE = c(-rev(TIMES.OVERRIDE), 0, TIMES.OVERRIDE)


FREQ_WIDTH = 2		# [10]  '2' works but not as good; just go for this!
FREQ_RANGE = seq(10,100,by=2)
if (LOG)
   # FREQ_RANGE = 2^seq(3.757, 7, by=.125)	# 13.5 - 128 Hz  27 values
   FREQ_RANGE = 2^seq(2, 7, by=.125)	# 13.5 - 128 Hz  27 values

# INCLUDE_DUAL_PEAKS = F			# See OneShiftVsFreq.r

# Some checks
if (any(METHOD.LOOPS == -1))
   stop("Set CHRONUS = -1 for PCC, not METHODS")


# DO THE EXPANSION, with TW changing most slowly (so can cache)
METHODS = length(METHOD.LOOPS)
PLS = length(PL.LOOPS)
TWS = length(TW.LOOPS)

METHOD.LOOPS = rep(METHOD.LOOPS, PLS)
PL.LOOPS =     rep(PL.LOOPS,  each=METHODS)

METHODS = length(METHOD.LOOPS)		# update (methods is same length)

METHOD.LOOPS = rep(METHOD.LOOPS, TWS)
PL.LOOPS =     rep(PL.LOOPS,  TWS)
TW.LOOPS =     rep(TW.LOOPS,  each=METHODS)


PLOT.OVERRIDE = F			# Don't make plots

LOOPS = length(METHOD.LOOPS)	# update again, sort of

while (sink.number())
    sink()
sink("temp.out")

graphics.off()

for (loop in 1:LOOPS) {

   TW.OVERRIDE = TW.LOOPS[loop]
   METHOD.OVERRIDE = METHOD.LOOPS[loop]
   PL.OVERRIDE = PL.LOOPS[loop]

   HZ_FROM.ITERS = FREQ_RANGE - FREQ_WIDTH/2
   HZ_TO.ITERS   = FREQ_RANGE + FREQ_WIDTH/2

   pdf(file = paste0("ShiftVs", if (LOG) "Log", "Freq_pl", PL.OVERRIDE, "_m",
		if (CHRONUX.OVERRIDE == -1) "PPC" else 
		     paste0(METHOD.OVERRIDE,
			    "_TW", TW.OVERRIDE),

		if (grepl("_50:", DIRECTORY.OVERRIDE)) { "_target"
		 } else if ( grepl("_-500:0", DIRECTORY.OVERRIDE)) "_baseline",

		switch(1+MERGE_STACK.OVERRIDE, 
			  "", "_merge", "_mergereach", "not_yet_coded"),

		if (FREQ_WIDTH==2) "_narrow",
		".pdf"))
   source("OneShiftVsFreq.r")
   dev.off()
   }

sink()
system("rm temp.out")

if (min(Times) > -64 || max(Times) < 64)
   cat("Warning: Times range of", range(Times), "could impact this plot!\n")

rm(TW.OVERRIDE,TW.LOOPS,METHOD.OVERRIDE,METHOD.LOOPS,PL.OVERRIDE,PL.LOOPS,
   MERGE_STACK.OVERRIDE,DIRECTORY.OVERRIDE,
   TIMES.OVERRIDE,
   HZ_FROM.ITERS,CHRONUX.OVERRIDE,
   PLOT.OVERRIDE, PLOT_FREQ,
   HZ_TO.ITERS,ITERATIONS)
