# FindOddCells.r
# Identify cells that have low spike-LFP, or rather, cells whose inclusion
# lowers the vector average.

#    Run doN.r first, to generate the data that this will read

E = function(freq=26:33, stack=4, cells=1:(dim(amplitude)[3]) ) {
  	amp = c(amplitude[freq, stack, cells])
        ang = c(angle    [freq, stack, cells])
	x = mean(amp * cos(ang), na.rm=T)
	y = mean(amp * sin(ang), na.rm=T)
	return(sqrt(x^2+y^2))
	}

All = E(stack=4) - E(stack=5)

cat("remove 1, rest are > W:   ")
bad = Bad = NULL
for (i in 1:38)
   if (((E(stack=4, cells=-i)) - E(stack=5, cells=-i)) > 1.1*All)
      cat("", i)
cat(bad, "\n")
Bad = bad

cat("remove 2, rest are > X:    ")
bad = NULL
for (i in 1:37)
  for (j in (i+1):38)
   if ((E(stack=4, cells=-c(i,j)) - E(stack=5, cells=-c(i,j))) > 1.3*All) {
      # cat(paste0("(", i,",", j, ") "))
      bad = c(bad, i, j)
      }
if (length(bad)>0)
   cat(unique(sort(bad)), "\n")
Bad = c(Bad, bad)

cat("remove 3, rest are > Y:    ")
bad = NULL
for (i in 1:36)
 for (j in (i+1):37)
  for (k in (j+1):38)
   if ((E(stack=4, cells=-c(i,j,k)) - E(stack=5, cells=-c(i,j,k))) > 1.45 * All) {
      # cat(paste0("(", i,",", j, ",", k, ") "))
      bad = c(bad, i, j, k)
      }
if (length(bad)>0)
   cat(unique(sort(bad)), "\n")
Bad = c(Bad, bad)

cat("remove 4, rest are > Z:    ")
bad = NULL
for (i in 1:35)
for (j in (i+1):36)
 for (k in (j+1):37)
  for (l in (k+1):38)
   if ((E(stack=4,cells=-c(i,j,k,l))-
	E(stack=5,cells=-c(i,j,k,l))) > 1.625*All) {
      # cat(paste0("(", i,",", j, ",", k, ",", l, ") "))
      bad = c(bad, i, j, k, l)
      }
if (length(bad)>0)
   cat(unique(sort(bad)), "\n")
Bad = c(Bad, bad)

Bad = unique(sort(Bad))
print(dimnames(amplitude)[[3]][Bad])

# cat(i, round(1000*(E(stack=4, cells=-i) - E(stack=5, cells=-i))), "\n")

