# shuffle.r
# (-mc)

if (SHUFFLE == 1) {
   Length1 = Length2 = Length3 = Length4 = Length5 = NULL
   AngleL1 = AngleL2 = AngleL3 = AngleL4 = AngleL5 = NULL
   shuffle_50 = NULL					# serves as a flag
   if (SHUFFLE_INDI)
      Amplitudes = array(NA, dim=c(BANDS,stacks,CellCount,MAX_SHUFFLE),
                   dimnames=list(
                        frequencies=round(BANDS.SEQ, dig=1),
                        stacks=62:66,
			cells = dimnames(Temp)[[4]][1:CellCount],
                        NULL))
   if (MAX_SHUFFLE > SHUFFLE_LIMIT) {
      cat("Truncating shuffles from", MAX_SHUFFLE, "to", SHUFFLE_LIMIT, "\n")
      MAX_SHUFFLE = SHUFFLE_LIMIT
      }
   }


source("VectorLength.r")
#  With method 2, the vector sum of each (2-D) coherence vector
Length1 = cbind(Length1, lengths[,1])
Length2 = cbind(Length2, lengths[,2])
Length3 = cbind(Length3, lengths[,3])
Length4 = cbind(Length4, lengths[,4])
Length5 = cbind(Length5, lengths[,5])
# lengths: one shuffle;  freq x stack (row x col)
# LengthN: all shuffles; freq x shuffle (one for each stack)

#  Ignores method; the length of the sum of the unit vectors (method=3)
AngleL1 = cbind(AngleL1, lengthAng[,1])
AngleL2 = cbind(AngleL2, lengthAng[,2])
AngleL3 = cbind(AngleL3, lengthAng[,3])
AngleL4 = cbind(AngleL4, lengthAng[,4])
AngleL5 = cbind(AngleL5, lengthAng[,5])
# lengthAng: one shuffle,  freq x stack (row x col)
# AngleLN:   all shuffles, freq x shuffle (one for each stack)

if (SHUFFLE_INDI)
   Amplitudes[,,1:CellCount,SHUFFLE] = amplitude[,,1:CellCount]

if (SHUFFLE == MAX_SHUFFLE) {			# At the end yet?
   # Compute pop-wide stats		(Note: 1- or 2-sided -- we chg'm)
   shuffle_50  = cbind(			# Build median (rowMedians)
		   apply(Length1, 1, quantile, .50, na.rm=T),
   		   apply(Length2, 1, quantile, .50, na.rm=T),
   		   apply(Length3, 1, quantile, .50, na.rm=T),
   		   apply(Length4, 1, quantile, .50, na.rm=T),
   		   apply(Length5, 1, quantile, .50, na.rm=T))
   shuffle_95  = cbind(			# Build the 95% conf limit
		   apply(Length1, 1, quantile, .95+.025*TWO_SIDED, na.rm=T),
   		   apply(Length2, 1, quantile, .95+.025*TWO_SIDED, na.rm=T),
   		   apply(Length3, 1, quantile, .95+.025*TWO_SIDED, na.rm=T),
   		   apply(Length4, 1, quantile, .95+.025*TWO_SIDED, na.rm=T),
   		   apply(Length5, 1, quantile, .95+.025*TWO_SIDED, na.rm=T))
   shuffle_05  = cbind(			# Build the 5% conf limit
		   apply(Length1, 1, quantile, .05-.025*TWO_SIDED, na.rm=T),
   		   apply(Length2, 1, quantile, .05-.025*TWO_SIDED, na.rm=T),
   		   apply(Length3, 1, quantile, .05-.025*TWO_SIDED, na.rm=T),
   		   apply(Length4, 1, quantile, .05-.025*TWO_SIDED, na.rm=T),
   		   apply(Length5, 1, quantile, .05-.025*TWO_SIDED, na.rm=T))
   shuffle_99  = cbind(			# Build the 99% conf limit
		   apply(Length1, 1, quantile, .99+.005*TWO_SIDED, na.rm=T),
   		   apply(Length2, 1, quantile, .99+.005*TWO_SIDED, na.rm=T),
   		   apply(Length3, 1, quantile, .99+.005*TWO_SIDED, na.rm=T),
   		   apply(Length4, 1, quantile, .99+.005*TWO_SIDED, na.rm=T),
   		   apply(Length5, 1, quantile, .99+.005*TWO_SIDED, na.rm=T))
   shuffle_01  = cbind(			# Build the 99% conf limit
		   apply(Length1, 1, quantile, .01-.005*TWO_SIDED, na.rm=T),
   		   apply(Length2, 1, quantile, .01-.005*TWO_SIDED, na.rm=T),
   		   apply(Length3, 1, quantile, .01-.005*TWO_SIDED, na.rm=T),
   		   apply(Length4, 1, quantile, .01-.005*TWO_SIDED, na.rm=T),
   		   apply(Length5, 1, quantile, .01-.005*TWO_SIDED, na.rm=T))
#   shuffle_999  = cbind(			# Build the 99% conf limit
#		   apply(Length1, 1, quantile, .999+.0005*TWO_SIDED, na.rm=T),
#   		   apply(Length2, 1, quantile, .999+.0005*TWO_SIDED, na.rm=T),
#   		   apply(Length3, 1, quantile, .999+.0005*TWO_SIDED, na.rm=T),
#   		   apply(Length4, 1, quantile, .999+.0005*TWO_SIDED, na.rm=T),
#   		   apply(Length5, 1, quantile, .999+.0005*TWO_SIDED, na.rm=T))
#   shuffle_001  = cbind(			# Build the 99% conf limit
#		   apply(Length1, 1, quantile, .001-.0005*TWO_SIDED, na.rm=T),
#   		   apply(Length2, 1, quantile, .001-.0005*TWO_SIDED, na.rm=T),
#   		   apply(Length3, 1, quantile, .001-.0005*TWO_SIDED, na.rm=T),
#   		   apply(Length4, 1, quantile, .001-.0005*TWO_SIDED, na.rm=T),
#   		   apply(Length5, 1, quantile, .001-.0005*TWO_SIDED, na.rm=T))
    rm(Length1, Length2, Length3, Length4, Length5)

   # Compute cell-by-cell stats
   if (SHUFFLE_INDI) {			# 1-sided tests!
      shuffle_indi_95 = apply(Amplitudes, 1:3, quantile, .95, na.rm=T)
      # shuffle_indi_90 = apply(Amplitudes, 1:3, quantile, .90, na.rm=T)
      # shuffle_indi_80 = apply(Amplitudes, 1:3, quantile, .80, na.rm=T)
      }		# Should not need na.rm, but occasionally one slips through
   }
