# main.r   Plot spike-lfp data for 5 stacks, ONE class

JUST.PRINT.FILES = F
if (!exists("SHUFFLE")) SHUFFLE = F
if (!exists("CHRONUX")) CHRONUX = -1

MONK = if(exists("MONK.OVERRIDE")) MONK.OVERRIDE else "zen"	# tyr,zen,both
NEAR = if(exists("NEAR.OVERRIDE")) NEAR.OVERRIDE else 2		# 	[1.25]
AREA = if(exists("AREA.OVERRIDE")) AREA.OVERRIDE else "PRR"
UNIT = if(exists("UNIT.OVERRIDE")) UNIT.OVERRIDE else ""
# PRR, LIP, cross (diff areas, same side), crossX2 (diff areas, diff sides)
# UNIT specifies which area the unit is (versus the LFP)
#      Can be PRR, LIP or "" (unspecified - take either)

# Never do these - just inherited
NORMALIZE = F			# [F] Any normalization?
NORMALIZE.TO.BASELINE = F	# [F] specific to non-target alignment

FilesToDo = NULL		# Ensure these are global variables
MonksToDo = NULL
source("Select.r")		# Ignore shuffle request (for now)

if (!JUST.PRINT.FILES) {
   MonksToDo = MonksToDo[!grepl("_96[78]", FilesToDo)]
   FilesToDo = FilesToDo[!grepl("_96[78]", FilesToDo)]
   # Maybe should also eliminate 870.1, 871.1, 919.2
   }

if (SHUFFLE) {
   MAX_SHUFFLE = 1			# Not set till last ReadAll call
   SHUFFLE = 1				# Insurance (should be 1 already)
   while (SHUFFLE <= MAX_SHUFFLE) {
      source("ReadAll.r")		# Read the shuffle directory
      source("shuffle.r")		# Save up the shuffle results
      SHUFFLE = SHUFFLE + 1
      }					# Last shuffle.r pass does computations
   SHUFFLE = -1				# Flag to ReadAll and VectorLength
   }

source("ReadAll.r")			# Ignores '-1' shuffle request

if (length(UsedFiles) && JUST.PRINT.FILES) {
   cat(switch(pl, "PRR - contra.PRR", 
	      	  "PRR.spikes - ipsi.LIP.lfp",
	      	  "PRR.spikes - contra.LIP.lfp",
		  "LIP - contra.LIP",
	      	  "LIP.spikes - ipsi.PRR.lfp",
	      	  "LIP.spikes - contra.PRR.lfp"), "   ", Plots[pl], "\n")
   print(files)		# Might comment out MonksToDo & FilesToDo, above
   PLOT.TYPE = "just print"	# Avoid error if no plot selected
   }

if (length(UsedFiles)) {
    source("VectorLength.r")	# Generate data plot
    # source("SignifSyncBar.r")	# Generate data plot
  } else {
   PLOT.TYPE = "just print"	# Avoid error if no plot selected
   plot(0,axes=F,type='n')	# No data: just draw an empty plot
   }

rm(NORMALIZE,NORMALIZE.TO.BASELINE,FilesToDo,MonksToDo)
