# doShift.r
	# 

# Overwritten by ManyShiftVsFreq:
 TW = 8

 Times = c(seq(2,20,2),seq(24,40,4),48, 56, seq(64,128, by=16))
 Times = c(-rev(Times), 0, Times)

 # __ A good choice for shifted data__
 # Times = c(-28,-24, seq(-20,20,2),24, seq(24,40,4), 48)

 # __ A good choice for symmetric data?__
#  Times = c(seq(-36,-24,4), seq(-20,20,2),24, seq(24,36,4))

 # __ Other choices__
 # Times = c(seq(2,20,2),seq(24,40,4),48, 56, 64, 80,96)
 # Times = c(seq(-40,-24,4), seq(-20,20, 2),seq(24,40,4), 48,56,64)
 # Times = c(-48, seq(-40,-24,4), seq(-20,20,2),24, seq(24,40,4), 48)


 METHOD = 1			# [2] 1 if PPC - normally set in VectorLength.r
 pl = 2				# [1] which plot? 0 ('all') not allowed
 HZ_FROM = 8			# [PRR-PRR:24] Freq range, exclusive [32-48?]
 HZ_TO = 18			# [PRR-PRR:38]  [18:32 for PRR-LIP?]
				# Making span less than 2 Hz can be bad
 MERGE_STACK = 1

 CHRONUX = -1			# [T]  -1: PPC
 PLOT = T

# DIR.OVERRIDE = "GoCue_-800:0ms.N=500+"	# GoCue_-800:0ms.N=500+ (600,1000 PPC)

 # DIR.OVERRIDE = "Target_-500:0ms.N=500+"	# merge-stack = 1
 # DIR.OVERRIDE = "Target_50:550ms.N=500+"	# merge-stack = 0 or 1
 # DIR.OVERRIDE = "Target_50:550ms.N=300+"	# only merge_stack=0
 # DIR.OVERRIDE = "Target_50:450ms.N=300+"	# only merge_stack=0
 # DIR.OVERRIDE = "Target_50:350ms.N=300+"	# only merge_stack=0
  DIR.OVERRIDE = "Target_50:350ms.N=100+"
######################################################################

# Not overwritten by ManyShiftVsFreq

# Just max value, or smooth the curve and check for doubles?
# StorePeaks = function(st) StorePlainPeaks(st)
StorePeaks = function(st) StoreFancyPeaks(st)

ALL_STACKS = T			# [F] Just bimanuals or all 5? (for PRR-PRR)

SHOW_DIFF = F			# [ ]
ADD_PEAK_LINES = T
HARD_CODE_LIMITS = F		# [ ]

CC_INACT = 0	# Inactivation data?  0: no   1:lesion   2:control   3:both
CC_TIME  = 0	# -1:pre  0:peri   1:post

######################################################################

if (exists("TIMES.OVERRIDE"))
   Times = TIMES.OVERRIDE
if (exists("TW.OVERRIDE"))
   TW = TW.OVERRIDE
if (TW==-1)
   CHRONUX = -1
if (exists("METHOD.OVERRIDE"))
   METHOD = METHOD.OVERRIDE
if (TW==-1)
   CHRONUX = -1
if (exists("PL.OVERRIDE"))
   pl = PL.OVERRIDE
if (exists("HZ_FROM.OVERRIDE")+exists("HZ_TO.OVERRIDE") == 2) {
   HZ_FROM = HZ_FROM.OVERRIDE
   HZ_TO = HZ_TO.OVERRIDE
 } else if (exists("HZ_FROM.OVERRIDE")+exists("HZ_TO.OVERRIDE") == 1)
   stop("Ambiguous frequency range override")
if (exists("CHRONUX.OVERRIDE"))
   CHRONUX = CHRONUX.OVERRIDE
if (exists("PLOT.OVERRIDE"))
   PLOT = PLOT.OVERRIDE

if (exists("MERGE_STACK.OVERRIDE"))
   MERGE_STACK = MERGE_STACK.OVERRIDE
if (exists("DIRECTORY.OVERRIDE"))
   DIR.OVERRIDE = DIRECTORY.OVERRIDE


# SELDOM CHANGE:
Y_BASE = -pi/4			# [-pi/4] lowest Y value for Methods 5 & 6
SHUFFLE = F			# [F]
NEAR =  2			# [2]
MIXED2  = 0			# [0]
SACONLY = 0	# 0=std  1=saconly:cross panels,sac stacks  
		# 2=saconly format for standard or 'mix' data
		# 3:just 'cross' panels, but for *all* stacks, not just sac

# Could bite you --
if ((CHRONUX==-1) & (DIR.OVERRIDE == "GoCue_-800:0ms.N=500+"))
   DIR.OVERRIDE = ifelse(MERGE_STACK,
      		"GoCue_-800:0ms.N=200+", "GoCue_-800:0ms.N=100+")

if ((CHRONUX==1) & exists("TW"))
   DIR.OVERRIDE = paste0(DIR.OVERRIDE, "_TW=", TW)

if (MERGE_STACK)
   DIR.OVERRIDE = paste0(switch(MERGE_STACK,
                           "All", "All-sac", "All-apart", "", "All-sac-apart"),
                         # if (EXCLUDE_SACS) "-sac",
                         DIR.OVERRIDE)
if (MERGE_STACK)
   ALL_STACKS = F
if (CHRONUX==0)
   stop("Use METHOD = -1 for PPC, or directory ../R for wavelet (CHRONUX 0)")

if (exists("iter") && (iter==1))
   warning(DIR.OVERRIDE) # DIAG


#  Names are hardwired elsewhere - do not change them !!
Plots = c("PRR","cross","crossX2","LIP", "cross","crossX2")
Units = c(  "",  "PRR",   "PRR",   "",    "LIP",  "LIP")
AREA = Plots[pl]
UNIT = Units[pl]

LFP   =  c("contra PRR","ipsi LIP","contra LIP",
	   "contra LIP","ipsi PRR","contra PRR")[pl]
Spikes = c("PRR", "PRR", "PRR",
	   "LIP", "LIP", "LIP")[pl]

MONK = ifelse(MIXED2, "tyr", "both")	# both, zen, tyr

# (Ignore these)
NORMALIZE = F			# [F] Any normalization?
NORMALIZE.TO.BASELINE = F	# [F] specific to non-target alignment

library(circular, warn.conflicts=F)

EffectSum = function(freq, stack, method=METHOD) {        # Pass it an index
        amp = c(amplitude[freq, stack, ])
        ang = c(angle    [freq, stack, ])

        if (length(amp) < 3) return(NA)

	# warning(length(amplitude[1,1,]))		# DIAG

        if (abs(method) == 1) {     # Scalar mean of amplitude; ignore direction
           return(mean(amp, na.rm=T))		# -1: PCC method (use method 1)
           }
        if (method == 2) {      # Vector sum of vectors -- return its *length*
           x = mean(amp * cos(ang), na.rm=T)
           y = mean(amp * sin(ang), na.rm=T)
           return(sqrt(x^2+y^2))
           }
        if (method == 3) {      # Vector sum of direction; ignore amplitude
           return(sqrt(mean(sin(ang), na.rm=T)^2 + mean(cos(ang), na.rm=T)^2))
           }
        if (method == 5) {      # Direction of vector sum
           x = mean(amp * cos(ang), na.rm=T)
           y = mean(amp * sin(ang), na.rm=T)
	   ang = atan2(y,x)
	   return(ifelse(ang< Y_BASE, ang+2*pi, ang))
           }
        if (method == 6) {      # Direction of unit vector sum
           x = mean(cos(ang), na.rm=T)
           y = mean(sin(ang), na.rm=T)
	   ang = atan2(y,x)
	   return(ifelse(ang< Y_BASE, ang+2*pi, ang))
           }
        stop("Unknown METHOD")
        }

Effect = NULL

SaveDirectory = DIR.OVERRIDE
for (time in Times) { 
   DIR.OVERRIDE = paste0(SaveDirectory, "_shift/", time)
   if (time == 0)
      DIR.OVERRIDE = SaveDirectory

   FilesToDo = NULL		# Ensure these are global variables
   MonksToDo = NULL
   source("Select.r")

   MonksToDo = MonksToDo[!grepl("_96[78]", FilesToDo)]
   FilesToDo = FilesToDo[!grepl("_96[78]", FilesToDo)]
   # Maybe should also eliminate 870.1, 871.1, 919.2

   source("ReadAll.r")
   if (!is.null(UsedFiles)) {
      if (!(stacks==1 || stacks==5))
        stop("Hardwired for 1 class and either 1 or 5 stacks")

      if (MERGE_STACK) {
         Effect = c(Effect, EffectSum(BANDS.SEQ>HZ_FROM & BANDS.SEQ < HZ_TO, 1))
       } else {
         Row = NULL
         for (i in 1:5)    # Wasteful: doing all stacks even if using only 2
             Row = c(Row, EffectSum(BANDS.SEQ>HZ_FROM & BANDS.SEQ < HZ_TO, i))
         Effect = rbind(Effect, Row)
         }
     } else {
      if (MERGE_STACK) {
         Effect = c(Effect, NA)
        } else
         Effect = rbind(Effect, c(NA,NA,NA,NA,NA))
      }
   }

# Effect is files x stacks.  If only one stack, it is a vector
if (MERGE_STACK) {
   In = !is.na(Effect)
   Effect = Effect[In]
 } else {
   In = !is.na(Effect[,4])
   Effect = Effect[In,]
   }
Times = Times[In]

# __ Get the peaks __

Peaks = matrix(NA, nrow=5, ncol=2)

StorePlainPeaks = function(st) {
   Yvalues = if (MERGE_STACK > 0) Effect else Effect[,st]
   peakY = max(Yvalues)
   peakX = Times[Yvalues == peakY]
   # if  (length(peakX) > 1) {
   #    stop("More than one peak - untested code! Check this out.")
   #    peakX = peakX[abs(peakX) == min(abs(peakX))]
   #    }
   Peaks[st,] <<- c(peakX, peakY)
   }

Multiplier = if (CHRONUX == -1) 3 else
	      switch(as.character(METHOD), 
		       "1"=3, "2"=1.25, "3"=1.25, 1.5)
	# Ran this at "1"=3 for the original figures (pre 2021-01-18)


StoreFancyPeaks = function(st) {
   if (all(is.na(Effect)))
      return

   for (task in 1:ifelse(MERGE_STACK,1,5)) {
       Smooth = if (MERGE_STACK) { 
	           predict(loess(Effect ~ Times, span=0.5), -128:128)
	         } else
	           predict(loess(Effect[,task] ~ Times, span=0.5), -128:128)
       LocalMaximaAt = which(diff(sign(diff(Smooth)))==-2)+1

       if (all(is.na(LocalMaximaAt))) {
	  ;
        } else if (length(LocalMaximaAt) == 1) {
	  Peaks[task,] <<- c(LocalMaximaAt-129, # Previously extrap'd to ±128 ms
			     Smooth[LocalMaximaAt])
	} else {
	  LocalMaximaValue = Smooth[LocalMaximaAt]
	  HighIndex = sort.list(LocalMaximaValue, decreasing=T)[1:2]
          LocalMaximaAt    = LocalMaximaAt   [HighIndex]	# 2 hi'est peaks
          LocalMaximaValue = LocalMaximaValue[HighIndex]	# 2 hiest values

          Base = mean(sort(
		           if (MERGE_STACK) { Effect } else Effect[,task]
		          )[1:4])		# baseline
          if ((LocalMaximaValue[1] - Base) > 
	      (LocalMaximaValue[2] - Base) * Multiplier) {
	     Peaks[task,] <<- c(LocalMaximaAt[1]-129,
			        Smooth[LocalMaximaAt[1]])
	    } # else
	    # if ((LocalMaximaAt[2] - LocalMaximaAt[1]) <= 8)
	    #   PeaksDual[iter, task] = mean(LocalMaximaAt)-129
	  }
      }
   }

if (MERGE_STACK || ALL_STACKS)
   StorePeaks(1)
if (ALL_STACKS) {
   StorePeaks(2)
   StorePeaks(3)
   }
if (MERGE_STACK==0) {
   StorePeaks(4)
   StorePeaks(5)
   }


if (PLOT) {
par(las=1, mar=c(5,6,4,2)+.1)
plot(0, 0, axes=F, type='n', 
		cex=2, cex.axis=2, cex.lab=2, cex.main=1.3,
     		main="Spikes/LFP temporal alignment",
		xlab = NA,
		ylab = NA,
     		xlim=if (HARD_CODE_LIMITS) c(-64,64) else range(Times),
		ylim=if (METHOD>4) c(Y_BASE,Y_BASE+2*pi) else 
		      if (HARD_CODE_LIMITS) {
			c(0, ifelse(ALL_STACKS,.025,.02))
		      } else 
		       if (MERGE_STACK) {
		      	range(Effect, na.rm=T)
		     } else 
			range(c(Effect[,ifelse(ALL_STACKS,1,4):5]), na.rm=T))
			# range(c(0,Effect[,ifelse(ALL_STACKS,1,4):5]),na.rm=T))

title(xlab="LFP lag re: spikes (ms)", mgp=c(2.5,.9,0), cex.lab=1.4)
title(ylab= if (CHRONUX==-1) "PPC statistic" else
     		switch(METHOD, 
		  "Mean vector lengths (0 to 1)", 
		  "Coherence (vector sum)",
                  "Vector sum (angle only)",
		  "Significant cells (%)",
                  "Direction of vector sum",
                  "Direction of unit vector sum"), mgp=c(4.5,1,0), cex.lab=1.5)



segments(0,par("usr")[3], 0, par("usr")[4], lwd=2, lty="solid", 
	 	col=ifelse(MERGE_STACK, "red", gray(.7)))

title(main=paste("\n\n\nSpikes from", Spikes, "   LFP from", LFP), cex.main=.8)

if (pl == 1) {					# For PRR versus PRR
  if (SHOW_DIFF) {
     segments(-8, max(Effect[,4]-Effect[,5]), 32, max(Effect[,4]-Effect[,5]),
						 col=gray(.6), lty="dashed")
   } else if (METHOD < 5 & !MERGE_STACK) {
     segments(-8,max(Effect[,4]), 32,max(Effect[,4]), col=gray(.6), lty="solid")
     segments(-4,min(Effect[,5]), 36,min(Effect[,5]), col=gray(.6), lty="solid")
     }
  }

if (MERGE_STACK) {
   points(Times, Effect, pch=19, col="blue", type='b', lwd=3)
   # StorePeaks(1)
   # points(Times, Effect, pch=19, col="blue", type='l')
 } else {
   points(Times, Effect[,4], pch=19, col="blue", type='b')
   points(Times, Effect[,5], pch=19, col="purple", type='b')
   # StorePeaks(4)
   # StorePeaks(5)
   }
if (SHOW_DIFF)
   points(Times, Effect[,4]-Effect[,5], pch=19, col="orange", type='b')

axis(1, at=Times, labels=F)
Tics = seq(-128,128,by=8)
axis(1, at= Tics[Tics %in% Times], lwd.tick=2, cex.axis=1.3, cex.lab=1.5)

if (HARD_CODE_LIMITS) {
   axis(2, at=if (ALL_STACKS) c(0,.012,.024) else c(0,.01,.02),
		cex=1.5, cex.axis=1.3, cex.lab=1.5)
 } else
   axis(2,
		cex=1.5, cex.axis=1.3, cex.lab=1.5)

if (ALL_STACKS) {
   points(Times, Effect[,1], pch=19, col="black", type='b')
   points(Times, Effect[,2], pch=19, col="green", type='b')
   points(Times, Effect[,3], pch=19, col="red", type='b')
   # StorePeaks(1)
   # StorePeaks(2)
   # StorePeaks(3)
   }

if (ADD_PEAK_LINES) {
   for (st in 1:5)
      segments(Peaks[st,1], Peaks[st,2],  
	       Peaks[st,1], par("usr")[3],
	       lwd=2, 
	       if (MERGE_STACK) lty="dotted",
	       col= if (MERGE_STACK) "blue" else
		    adjustcolor(
			c("black", "green", "red", "blue", "purple")[st],
			alpha.f=.4))
    Reorder = order(Peaks[,1])

    text(min(Peaks[,1],na.rm=T) - (max(Times)-min(Times))/100, #left of lowest X
	     par("usr")[3] + .025 * (par("usr")[4]-par("usr")[3]) * (5:1),
	     			# Spaced out vertically (2.5% of total height)
	     Peaks[,1][Reorder],	# In ascending order of peak time
	     col=if (MERGE_STACK) "blue" else 
		     c("black", "green", "red", "blue", "purple")[Reorder],
	     adj=1, font=2)

    text(min(Peaks[,1], na.rm=T) + (max(Times)-min(Times))/100, # to right
	     par("usr")[3] + .025 * (par("usr")[4]-par("usr")[3]) * 5, "ms",
	     col=if (MERGE_STACK) "blue" else "black",
	     adj=0)

    if (MERGE_STACK && abs(Peaks[,1]) > 2)
       arrows(0,                     
	   # par("usr")[3]+(par("usr")[4]-par("usr")[3])/2,
	   par("usr")[3] + .025 * (par("usr")[4]-par("usr")[3]) * 7,
           min(Peaks[,1],na.rm=T),
	   # par("usr")[3]+(par("usr")[4]-par("usr")[3])/2,
	   par("usr")[3] + .025 * (par("usr")[4]-par("usr")[3]) * 7,
	   length=0.15, lwd=3)
    }

mtext(paste0(MONK, if (NEAR) paste0("+",NEAR," mm"), "    ",
     round(ifelse(exists("MIN_FREQ"), MIN_FREQ, min(BANDS.SEQ)),dig=1),
     " to ",
     round(ifelse(exists("MAX_FREQ"), MAX_FREQ, max(BANDS.SEQ)),dig=1),
     "Hz",
     "\n",
     sub("_shift.*", "", directory),
     "\n",
     if (SACONLY == 1) "saconly ", 
     # if (SACONLY == 2) " (sac trials only)",
     if (MIXED2) "mixed2 ",
     if (SHUFFLE) paste(MAX_SHUFFLE, "shuffles"),
     if (SHUFFLE & CC_INACT) "   ",
     if (CC_INACT==1) "cc_lesion ",
     if (CC_INACT==2) "cc_control ",
     if (CC_INACT==3) "cc_lesion+control  ",
     if (CC_INACT==11) "cc_lesion_LIP ",
     if (CC_INACT==12) "cc_control_LIP ",
     if (CC_INACT==13) "cc_lesion+control_LIP  ",
     if (CC_INACT)    c("Pre", "Peri", "Post")[2+CC_TIME]),
	 side=1, line=-.2, outer=T, adj=.03, cex=.9, font=2)

mtext(paste0(
     switch(CHRONUX+2, "PPC", "wavelet", "Chronux"),
     ", method ", METHOD, ": ",
     switch(METHOD, "Mean amplitude", "Weighted vector sum",
	    	    "Vector sum (angle only)", "% Significant cells",
		    "Direction of vector sum",
		    "Direction of unit vector sum"),
     "  ", HZ_FROM, " to ", HZ_TO, " hz"),
      side = 1, line = -1.1, outer = T, adj=.98, cex=.8, font=2)

mtext("Saccade",   col=1, side=3, line=-0.7, outer=T,adj=.98, cex=.6,font=2)
mtext("Ipsi",      col=3, side=3, line=-1.3, outer=T,adj=.98, cex=.6,font=2)
mtext("Contra",    col=2, side=3, line=-1.9, outer=T,adj=.98, cex=.6,font=2)
mtext("Together",  col=4, side=3, line=-2.5, outer=T,adj=.98, cex=.6,font=2)
mtext("Apart",col="purple",side=3,line=-3.1, outer=T,adj=.98, cex=.6,font=2)
}

rm(NORMALIZE,NORMALIZE.TO.BASELINE,FilesToDo,MonksToDo,PLOT)

if (!exists("PLOT_FREQ"))
rm(SACONLY, MIXED2, Plots, Units, 
   NEAR, DIR.OVERRIDE, AREA, 
   UNIT, MONK)

if (!exists("TW.OVERRIDE"))
   rm(pl, CHRONUX)
