# ReadAll.r   Read in all the data -- CHRONUX

#  Called by main.r

verbose = 0
directory = "default"	# will fail unless overwritten

REMOVE_POWER_OUTLIERS = F

if (verbose)
   cat("Begin ReadAll\n")

if (exists("DIR.OVERRIDE"))
   directory = DIR.OVERRIDE
if (!exists("SACONLY"))
   SACONLY = F
if (!exists("MIXED2"))
   MIXED2 = F
if (SHUFFLE == F)
   OBSELETE_SHUFFLE = F

StackList =
	# if (SACSPLIT) {    .... <we don't use this here! ...
        # if (STIMULATE) {                c(32,35,62,65) }   else
	if (MERGE_STACK)	1		else
        if (SACONLY)		1		else
        if (CC_INACT > 10) 	c(92,95,96)	else
            62:66
# STACKS = length(StackList)		# We don't use this

# For LFP-LFP, PRR-PRR and crossX2, the class distinction depends on which
# For cross, do standard flip (written).

FLIP = 1	# 0: do not  1: by spike  2: by LFP  (2 is not used?)
	# Stacks: started recording on LEFT so left (stk 63) = ipsi arm
	#	  Flip STACKS if recorded on right
	# Classes named for RIGHT arm, so flip CLASSES if record on RIGHT

# if (MONK=="both")		# Try this!
    # MONK = "{tyr,zen}"

System = function(command) system(paste("tcsh -c '", command, "'"), intern=T)
Scan = function(...) scan(..., quiet=!verbose)

files = paste0("/data/coord/grab/spike-lfp/data/data/",
	       switch(2+CHRONUX, "PPC", "wavelet", "chronux"),
	       "/",
	       if (SACONLY ==1) "saconly",
	       if (MIXED2  ==1) "mixed2",
	       if ((SACONLY | MIXED2) & CC_INACT) ".",
	       if (CC_INACT)	# Insurance. No output for CC_INACT of 0 or 10
	         switch(CC_INACT%%10,
		      "cc", "ccc", "ccc", "4", "ccc_pre+post"),
	       if (CC_INACT > 10) "_memory",
	       "/",
		directory,
		if (SHUFFLE>0) 	"_shuffle",
		if (SHUFFLE>0 & OBSELETE_SHUFFLE) "2", 
		if (SHUFFLE>0) 	paste0("/", SHUFFLE),
	       "/",
		MonksToDo,
	       "/data_",
		FilesToDo)

if (CC_INACT%%10 == 3)					# Both _ccc and _cc
   files = c(files,
             paste0("/data/coord/grab/spike-lfp/data/data",
		switch(2+CHRONUX, "PPC", "wavelet", "chronux"),
						"/",
		if (SACONLY ==1)  		"saconly",
		if (MIXED2  ==1)   		"mixed2",
		if ((SACONLY|MIXED2) & CC_INACT) ".",
				  		"cc",	    # Did _ccc above
		if (CC_INACT > 10) 		"_memory",
               					"/",
                				directory,
		if (SHUFFLE>0) 			"_shuffle",
		if (SHUFFLE>0 & OBSELETE_SHUFFLE) "2", 
		if (SHUFFLE>0) 			paste0("/", SHUFFLE),
	       					"/",
						MonksToDo,
						"/data_",
						FilesToDo))

if (SHUFFLE==1)	{		#  Count subdirectories under 'shuffle' 
   SHUFFLE_FILES = list.files(
        path = sub(paste0("shuffle", if (OBSELETE_SHUFFLE) "2", "/.*"),
		   paste0("shuffle", if (OBSELETE_SHUFFLE) "2"),
		   files[1]),
		   pattern = "^[0-9]")	#  (only those starting with a digit)
   # Could just do length(SHUFFLE_FILES), but out-of-order files will kill us
   SHUFFLE_FILES = sort(as.numeric(SHUFFLE_FILES), na.last=NA)  # rm NA's
   MAX_SHUFFLE = sum( SHUFFLE_FILES == (1:length(SHUFFLE_FILES)) )
   rm(SHUFFLE_FILES)
   }


data = NULL
UsedFiles = NULL		# rarely, files are skipped
CellCount = 0
SkipCount = CannotFindCount = 0

if (verbose)
   cat("Number of files:", length(files), "\n")

for (file in files) {
   if (!file.exists(file)) {
      if ((CannotFindCount < 2 && !SHUFFLE) || verbose)
         cat(" Missing:", sub("/.*/data/data/", "", file), "\n")
      CannotFindCount = CannotFindCount + 1
      next
      }

   if (grepl("_919.2", file)) {
      cat("Skip (10", substring(file, 43), "\n")
      next
      }

   if (REMOVE_POWER_OUTLIERS) {
      if (grepl("_1006.2_2",file) ||
          grepl("_1033.2_2",file) ||
          grepl("_1036.2_2",file) ||
          grepl("_10929.2_2",file) ||
          grepl("_1100.4_1",file) ||
          grepl("_1106.1_1",file) ||
          grepl("_1106.1_2",file) ||
          grepl("_909.2_2",file) ||
          grepl("_917.2_1",file) ||
          grepl("_932.2_1",file) ||
          grepl("_1013.1_2",file) ||
          grepl("_1091.1_2",file) ||
          grepl("_1252.3_2",file) ||
          grepl("_1298.2_1",file)
          ) {
         if (verbose>0)
            cat("Skip (high power)",
                sub("[-a-zA-Z0-9_:/]*/cohLFP", "", file), "\n")
         next
         }
      if (grepl("_1099.3_1",file) ||
          grepl("_11112.4_2",file) ||
          grepl("_1111.4_2",file) ||
          grepl("_1116.1_1",file) ||
          grepl("_1117.1_1",file) ||
          grepl("_1257.2_1",file) ||
          grepl("_1258.2_1",file)
          ) {
         if (verbose>0)
            cat("Skip (low power)",
                sub("[-a-zA-Z0-9_:/]*/cohLFP", "", file), "\n")
         next
         }
      }

   if (verbose)
      cat("file", file, "\n")

   command = Scan(file, nlines=1, what="character")
   params  = Scan(file, skip=2, nlines=1)
   # 1: version
   # 2: interval_begin  3: interval_end
   # 4: time start      5: time end
   # 6: filter
   # 7: UnitOrLFP       8: UnitOrLFP2
   # 9: start freq      10: end freq    11: freq step size
   # 12: file type
   # 13: LFP hemisphere
   # 14: start high freq  or 10*'TW' (frequency window width)
   #     15: end hi freq  16: step size
   # 17: evoked flag
   # 18: spike limits (all, exactly mimimum)  19: spike N   20: random seed
   # 21: use chronux flag

   FROM = params[2]
   TO   = params[3]
   DURATION = TO - FROM + 1
   ZERO = -FROM

   Counts = Scan(file, skip=3, nlines=1)
   stacks = length(Counts)
   if (stacks == 1)     # If merged stacks, no point flipping classes, since
      FLIP = 0		# we do not know what stack they are from

   # Work out what frequencies were used
   if (params[1] == 1 | (CHRONUX==-1)) {
      BANDS = (params[10] - params[9]) / params[11] + 1
      BANDS.SEQ = seq(params[9], params[10], by=params[11])
      if (CHRONUX) {
         BANDS = round(BANDS)
         BANDS.SEQ = seq(from=params[9], by=params[11], length.out = BANDS)
         BANDS.SEQ = round(BANDS.SEQ, dig=1)
         }
    } else {                                    # version == 2+
      BANDS.SEQ = Scan(file, skip=4, nlines=1) # Get frequencies
      BANDS = length(BANDS.SEQ)
      }

   LFP.HEMI = params[13]
   TW =       params[14]/10

   if (abs(TO - FROM - 1 - DURATION) > 10)      # some tolerance!
      cat("Extracted 'zero' may be wrong because bounds were redone\n")

   rm(FROM, TO)		# Not sure why I remove these ... 


   temp = Scan(file, skip=4+(params[1]>1))		# Read all the data
   L = length(temp)
   if (L== 0) {
      cat("No data in ", sub(".*Data_","",file), "\n")
      next
      }

   if (abs(L - (BANDS * stacks * ifelse(CHRONUX==1, 2, 1))) > .0001)
      stop(paste0("Number of types seems off (", L, " = ", stacks, " x ", BANDS,
		 ")\n ", sub(".*Data_","",file), "\n"))

   CellCount = CellCount + 1
   UsedFiles = c(UsedFiles, file)	# Note which files are used
   if (verbose)
      cat("Cell", CellCount, file, "\n")

   if (length(UsedFiles) == 1) {	# First file?
      MsToX <- function(ms) return(1+(ZERO-WINDOW/2+ms)/(WINDOW/4))
      XtoMs <- function(ix) return( (ix-1)*WINDOW/4 - ZERO + WINDOW/2)

      save.stacks <- stacks
      save.bands <- BANDS
      Temp = array(NA, dim=c(2, BANDS, stacks, length(files)))
      	# Chronux has amplitude & angle; PPC uses only amplitude

      dimnames(Temp) = list(c("amp", "angle"), 	# Leave angle NA for PPC
			   BANDS.SEQ,
			   StackList,
			   files)
      if (CHRONUX!=1)
         Temp[1,,,1] = array(temp, dim=c(1, BANDS, stacks))
       else
         Temp[ ,,,1] = array(temp, dim=c(2, BANDS, stacks))
    } else {
      if (save.stacks != stacks)
	 cat("Stacks differ", save.stacks, stacks, file, "\n")
      if (save.bands != BANDS)
	 cat("Bands differ", save.bands, BANDS, file, "\n")
      if (CHRONUX!=1)
         Temp[1,,,length(UsedFiles)] = array(temp, dim=c(1, BANDS, stacks))
       else
         Temp[ ,,,length(UsedFiles)] = array(temp, dim=c(2, BANDS, stacks))
      }
   
   # mirror image if SPIKE recorded on right hemisphere
   # Only relevant if plotting two hands, or something like that.
   #   'UNIT' specifies which AREA the spike was in
   	#    spike LFP
   	# 2: left  left		# This is done in the matlab code
   	# 3: right left
   	# 4: left  right
   	# 5: right right
   if (params[13] < 2)
      stop("LHS 7-2017: seems like this was written for 2:5 (not 0/1)!")

   if (((FLIP == 1) & (params[13]==3 || params[13]==5)) ||
       ((FLIP == 2) & (params[13]==4 || params[13]==5))
       ) {
      if (verbose)
         cat("Mirror data on right\n")

      Temp2 = Temp[,,,length(UsedFiles),drop=F]
      LeftUni = match(3, (StackList%%10))
      RightUni = match(4, (StackList%%10))
      if (!is.na(LeftUni) || !is.na(RightUni)) {
         if (is.na(LeftUni) || is.na(RightUni))
             stop("Must write code for having just ONE unimanual stack!")

         if (stacks > 4) {	# Swap stacks 63 and 64 (left & right paws)
            Temp2[,,LeftUni,1] <- Temp[,,RightUni,length(UsedFiles)]
            Temp2[,,RightUni,1] <- Temp[,,LeftUni,length(UsedFiles)]
            }
         }
      # No classes, so no need to flip them.  If there *were*, then:
      # if (classes == 8) {	# Swap classes 8,1,2 with 6,5,4 (mirror image)
      #    Temp2[,,,c(8,1,2),,1] <- Temp[,,,c(6,5,4),,length(UsedFiles)]
      #    Temp2[,,,c(6,5,4),,1] <- Temp[,,,c(8,1,2),,length(UsedFiles)]
      #  } else if (classes == 2) {	# RL - change to contra/ipsi field
      #    cat("Warning: swapping classes -- bad if will sort on pref/null!\n")
      #    Temp2[,,,1,,1] <- Temp[,,,2,,length(UsedFiles)]
      #    Temp2[,,,2,,1] <- Temp[,,,1,,length(UsedFiles)]
      #  } else if (classes == 1) {
      #	   # No need to flip classes!
      #  } else
      #    cat(paste("   ", classes, "classes -- how do I flip them?\n"))

      Temp[,,,length(UsedFiles)] <- Temp2
      rm(Temp2)
      }
   }

# Used to do this:
# if (SHUFFLE && (CellCount == 0)) {
#    MAX_SHUFFLE = SHUFFLE
#  } else {

if (is.null(UsedFiles))
   cat("Found no files\n")

if (!is.null(UsedFiles)) {
 if (CannotFindCount > 2 && !SHUFFLE)
    cat(" and", CannotFindCount-2, "more\n")
 if (length(UsedFiles) < length(files)) {	# Rarely, we skip a file
    if (!SHUFFLE) # Shuffles with N=X spike requirement have MANY missing!
        cat("Skipped", length(files)-length(UsedFiles), "files,",
             "used ", length(UsedFiles), "\n")
    Temp = Temp[,,,1:length(UsedFiles), drop=F]	# Just keep the filled in slots
    dimnames(Temp)[[4]] = UsedFiles		# Give them the right names
    files = UsedFiles				# Forget about the unused ones!
    }

 dimnames(Temp)[[4]] = sub(".*/data_", "", dimnames(Temp)[[4]])

 amplitude = array(Temp["amp",,,],
		  dim=c(BANDS, stacks, length(files)))
 angle = array(Temp["angle",,,],
		  dim=c(BANDS, stacks, length(files)))
 dimnames(amplitude) =
 dimnames(angle) = dimnames(Temp)[-1]		# Throw out 1st dim (amp,angle)
 }

if (exists("params") && (params[1] > 1))  # Not version 1, which wrote radians
   angle = angle / 360 * 2 * 3.14159
   

if (verbose)
   cat("Done with read\n")
