# OneShiftVsFreq.r
	# Use GoCue_-800:0msN=500+ unless PPC: -600:0ms.N=100+

INCLUDE_DUAL_PEAKS = F

ITERATIONS = length(HZ_FROM.ITERS)

PeaksDual = 
PeaksEdge =
PeaksAt  = matrix(NA, nrow=ITERATIONS, ncol=5)

for (iter in 1:ITERATIONS) {
   HZ_FROM.OVERRIDE = HZ_FROM.ITERS[iter]
   HZ_TO.OVERRIDE   = HZ_TO.ITERS[iter]

   if ((iter %% 10) == 0)
       warning("DIAG: iter =", iter, "of", ITERATIONS)

   if (exists("BANDS.SEQ")) {	# Kluge: First time thru you won't have these
      if (HZ_FROM.OVERRIDE < BANDS.SEQ[1])
         next
      if (HZ_TO.OVERRIDE > BANDS.SEQ[length(BANDS.SEQ)])
         next
      }
      
   source("doShift.r")

   PeaksAt[iter, ] = Peaks[,1]	# Just the x value from doShift (all stacks)
   }	# Note that the stack dimension moves from rows to columns

par(las=1, mar=c(5,4.5,4,2)+.1)
X = rowMeans(cbind(HZ_FROM.ITERS, HZ_TO.ITERS))
YLIM = if (METHOD == 2) c(-40,45) else c(-16,24)
YLIM = c(-25,100)  # DIAG
plot(1,1, xlim=range(X), log=ifelse(LOG,"x",""),
     	cex=2, cex.axis=2, cex.lab=2, cex.main=2,
	ylim = YLIM,
	xlab="Frequency (Hz)", ylab="Peak shift (ms)",
	type='n', axes=F)
segments(X[1], 0,  X[length(X)], 0,  col="black")
# segments(X[1], 10, X[length(X)], 10, col="gray", lty="dashed")
polygon(c(20, 20, 35, 35, 20),
           c( YLIM[1], YLIM[2], YLIM[2], YLIM[1], YLIM[1]),
           col=adjustcolor("gray",alpha.f=.4),
           border=NA)

if (any(PeaksAt   >= YLIM[2], na.rm=T)) {
   PeaksEdge[PeaksAt >= YLIM[2]] = YLIM[2] + 1
   PeaksAt  [PeaksAt >= YLIM[2]] = NA
   }
if (any(PeaksAt   < YLIM[1], na.rm=T)) {
   PeaksEdge[PeaksAt <= YLIM[1]] = YLIM[1] - 1
   PeaksAt  [PeaksAt <= YLIM[1]] = NA
   }
if (INCLUDE_DUAL_PEAKS && any(PeaksDual   >= YLIM[2], na.rm=T)) {
   PeaksEdge[PeaksDual >= YLIM[2]] = YLIM[2] + 1
   PeaksDual[PeaksDual >= YLIM[2]] = NA
   }
if (INCLUDE_DUAL_PEAKS && any(PeaksDual   < YLIM[1], na.rm=T)) {
   PeaksEdge[PeaksDual <= YLIM[1]] = YLIM[1] - 1
   PeaksDual[PeaksDual <= YLIM[1]] = NA
   }

for (task in 1:ifelse(MERGE_STACK, 1,5)) {
    # Separate lines and points are better than type='b' 
    
    lines(X, PeaksAt[,task], #+(task-3)/4,
   	    col=c("black","green","red","blue","purple")[task],
   	    lwd=3)
    points(X, PeaksAt[,task], # +(task-3)/4, 
	    col=c("black","green","red","blue","purple")[task],
	    # cex=1.3,
	    pch=19)

    # dual or uncertain peaks
    if (INCLUDE_DUAL_PEAKS)
    points(X, PeaksDual[,task], # +(task-3)/4, 
	    col=c("black","green","red","blue","purple")[task],
	    pch=21,
	    lwd = .7,
	    cex = 1.3,
	    bg="white")

    # Now put in the points on the edges
    points(X, PeaksEdge[,task]+(task-3)/2, 
   	    col=c("black","green","red","blue","purple")[task],
   	    pch=19, cex=.5)

   }

if (LOG) {
   axis(1, at=2^(4:7), lwd.ticks=1.5, 
     	cex=2, cex.axis=2, cex.lab=2, cex.main=2)
    axis(1, at=2^seq(4.5,7.5,by=1), labels=F, tcl=-0.3)
 } else if (any(X%%10 == 0)) {
    axis(1, at=X[X%%10==0], lwd.ticks=1.5,
     	cex=2, cex.axis=2, cex.lab=2, cex.main=2)
    axis(1, at=X, labels=F, tcl=-0.3)
 } else
    axis(1, at=X,
     	cex=2, cex.axis=2, cex.lab=2, cex.main=2)

# axis(2, at=c(-40,-20,0,20,40), labels=c("-40","","0","","40"))
axis(2, at=c(-16,-8,0,8,16,24),
     	cex=2, cex.axis=2, cex.lab=2, cex.main=2)

title(main=paste("\n\n\nSpikes from", Spikes,
		          "   LFP from", LFP), cex.main=1.6)
mtext(paste0(MONK, if (NEAR) paste0("+",NEAR," mm"), "    ",
     round(ifelse(exists("MIN_FREQ"), MIN_FREQ, min(BANDS.SEQ)),dig=1),
     " to ",
     round(ifelse(exists("MAX_FREQ"), MAX_FREQ, max(BANDS.SEQ)),dig=1),
     "Hz",
     "\n",
     sub("_shift.*", "", directory),
     "\n",
     if (SACONLY == 1) "saconly ",
     # if (SACONLY == 2) " (sac trials only)",
     if (MIXED2) "mixed2 ",
     if (SHUFFLE) paste(MAX_SHUFFLE, "shuffles"),
     if (SHUFFLE & CC_INACT) "   ",
     if (CC_INACT==1) "cc_lesion ",
     if (CC_INACT==2) "cc_control ",
     if (CC_INACT==3) "cc_lesion+control  ",
     if (CC_INACT==11) "cc_lesion_LIP ",
     if (CC_INACT==12) "cc_control_LIP ",
     if (CC_INACT==13) "cc_lesion+control_LIP  ",
     if (CC_INACT)    c("Pre", "Peri", "Post")[2+CC_TIME]),
         side=1, line=-.5, outer=T, adj=.01, cex=.9, font=2)

mtext(paste0(
     switch(CHRONUX+2, "PPC", "wavelet", "Chronux"),
     if (CHRONUX != -1)
	     paste0(", method", METHOD, ": ",
     	     switch(METHOD, "Mean amplitude", "Weighted vector sum",
                    "Vector sum (angle only)", "% Significant cells",
                    "Direction of vector sum",
                    "Direction of unit vector sum")),
     "  mult=", Multiplier,
     "   ", round(HZ_FROM,dig=1), " to ", round(HZ_TO,dig=1), " hz"),
         side=1, line=-1, outer=T, adj=.98, cex=.8, font=2)

mtext("Saccade",   col=1, side=3, line=-0.7, outer=T,adj=.98, cex=.6,font=2)
mtext("Ipsi",      col=3, side=3, line=-1.3, outer=T,adj=.98, cex=.6,font=2)
mtext("Contra",    col=2, side=3, line=-1.9, outer=T,adj=.98, cex=.6,font=2)
mtext("Together",  col=4, side=3, line=-2.5, outer=T,adj=.98, cex=.6,font=2)
mtext("Apart",col="purple",side=3,line=-3.1, outer=T,adj=.98, cex=.6,font=2)

rm(HZ_FROM.OVERRIDE,HZ_TO.OVERRIDE)
