% COMPARE SPECTRAL METHODS
%   Compare Matlab's pmtm to Chuck's DFT method.
%

% Initialize
clear all; close all; clc
addpath(genpath('~chuck/code/matlab'));
prepOutput;
initDir = pwd;

%%%% PARAMS %%%%
grabArgs = 'grab -at2 -ms -mc -i-300:1300 -ot500 -of5:120:5 -d2';
sFile    = 's971.1';
appendix = '971.1_2'


%%%% RUN GRAB - GET FILES %%%%
cd('/data/coord/zen/12-11-25');
delete('DFTpowerData_*');
grabCmd = [grabArgs,' -o211 ',sFile];
disp(grabCmd);
system(grabCmd);
movefile(['DFTpowerData_',appendix],[initDir,'/output/DFTpowerData_',appendix]);

delete('PowerData_*');
grabCmd = [grabArgs,' -o11 ',sFile];
disp(grabCmd);
system(grabCmd);
movefile(['PowerData_',appendix],[initDir,'/output/PowerData_',appendix]);

cd(initDir);


%%%% COMPARE FILES %%%%

PowerData = readPowerData(['output/PowerData_',appendix]);
DFTpowerData = readPowerData(['output/DFTpowerData_',appendix]);

specgram    = meanSpecgram(PowerData,1);
specgramDft = meanSpecgram(DFTpowerData,1);
spectRef    = meanSpectrum(specgram,PowerData(1).timeAxis,[-Inf,0]);
spectDftRef = meanSpectrum(specgramDft,DFTpowerData(1).timeAxis,[-Inf,0]);

specgramNorm    = normSpecgram(specgram,spectRef,PowerData(1).freqAxis,'freq');
specgramDftNorm = normSpecgram(specgramDft,spectDftRef, ...
                               DFTpowerData(1).freqAxis,'freq');

spect    = meanSpectrum(specgramNorm,PowerData(1).timeAxis,[300,Inf]);
spectDft = meanSpectrum(specgramDftNorm,DFTpowerData(1).timeAxis,[300,Inf]);

% Display spectra
hfig = makeFigure([5,5]);
hold on;
plot(PowerData(1).freqAxis,spect,'b');
plot(DFTpowerData(1).freqAxis,spectDft,'r');
set(gca,'XScale','log');
xlim(PowerData(1).freqAxis([1,end]));
ylabel('Power');
xlabel('Freq (Hz)');
printFigure(hfig,'output/Spectra.eps');
close(hfig);
