close all; clear all; clc
addpath(genpath('/data/code/matlab'));
prepOutput;


%%%% PARAMETERS %%%%

% Database
database{1} = '/data/coord/tyr/tyrunits';
database{2} = '/data/coord/zen/zenunits';

% Data files
dataDir  = 'data/pow';

% Display
linProp.col   = {'k','g','r','b','m'};
linProp.width = 2;

% Save params
save('output/params.mat');


%%%% LOAD AND SELECT DATA %%%%

% Select data
DataList = listLfpData(dataDir,'PowerData','lfp');


%%%% LOAD DATA %%%%

% Load data
Data = loadLfpData(dataDir,DataList,11);

% Get mean ppc array
for iData = 1:length(Data)
    powAll(:,:,iData)  = mean(Data(iData).pow,2);
end
powMean  = mean(powAll,3);
powErr   = 0*sem(powAll,3); 

% Extract time and freq - verify they match across sites.
freq = Data(1).freq;

% Make figure. Define a constant
lineProp.col   = {'k','g','r','b','m'};
lineProp.width = 2;

% Plot pow
hfig = makeFig(5,4);
mseb(freq,powMean.',powErr.',lineProp);
set(gca,'XScale','log','YScale','log');
xlim(freq([1,end]));
xlabel('Freq (Hz)');
ylabel('Power');
print(hfig,'-dtiff','output/Spec.tiff');
print(hfig,'-depsc','-loose','output/Spec.eps');
close(hfig);
