function [hfig] = spectrogramFigure(spec,timeAxis,freqAxis,specLimits,smoothSpan,interpFactor,cLabel,specLabel);
%

% Plot based on the number of spectrograms
switch (length(spec))
case 1
   
    % Make Figure
    hfig = makeFigure([8,3]);

    % Plot
    plotSpectrogram(spec{1},freqAxis,timeAxis/1000,smoothSpan,interpFactor,cLabel);
    title(specLabel{1},'FontWeight','bold');
    caxis(specLimits);

case 2

    % Make figure
    hfig  = makeFigure([8,9]);

    % Plot case 1
    ax1 = subplot(311);
    plotSpectrogram(spec{1},freqAxis,timeAxis/1000,smoothSpan,interpFactor,cLabel);
    title(specLabel{1},'FontWeight','bold');
    caxis(specLimits);

    % Plot case 2
    ax2 = subplot(312);
    plotSpectrogram(spec{2},freqAxis,timeAxis/1000,smoothSpan,interpFactor,cLabel);
    title(specLabel{2},'FontWeight','bold');
    caxis(specLimits);

    % Plot difference
    ax3 = subplot(313);
    plotSpectrogram(spec{1}-spec{2},freqAxis,timeAxis/1000,smoothSpan,interpFactor,cLabel);
    title('Difference','FontWeight','bold');
    caxis(specLimits-mean(specLimits));

otherwise
    error('SPECTROGRAM_FIGURE can only handle 1 or 2 spectrograms!!')
end
