function [hfig] = signalFigure(signal,xAxis,plotProp)
%

% Open figure. Determine plot colors.
switch (length(signal))
case 1
    hfig   = makeFigure([8,3]);
    nPlots = 1;
case 2
    hfig = makeFigure([8,6]);
    nPlots = 2;
otherwise
    error('SIGNAL_FIGURE can only handle 1 or 2 signals!!');
end


%%%%%%%%%%%%
% ABSOLUTE %
%%%%%%%%%%%%

% Compute means and sems
signalMean = cellfun(@(x) mean(x,2),signal,'Un',0);
signalSem  = cellfun(@(x) sem(x,2),signal,'Un',0);

% Get line colors
switch (length(signal))
case 1
    lineProp.col{1} = 'k';   
case 2
    lineProp.col{1} = 'r';
    lineProp.col{2} = 'b';
otherwise
    error('SIGNAL_FIGURE can only handle 1 or 2 signals!!');
end

% Plot
subplot(nPlots,1,1)
lineProp.width = 4;
mseb(xAxis,cell2mat(signalMean).',cell2mat(signalSem).',lineProp);

% Format
if (strcmp(lower(plotProp.yLim),'auto'))
    axis tight
else
    ylim(plotProp.yLim(1,:));
end
xlim(xAxis([1,end]));
refLine('x',0,'LineWidth',3,'InBack',1);
refLine('y',1,'Color',[0.2,0.2,0.2]);

% Annotate
xlabel(plotProp.xLabel);
ylabel(plotProp.yLabel);
title(plotProp.title);


%%%%%%%%%%%%%%
% DIFFERENCE %
%%%%%%%%%%%%%%

if (length(signal)==2)

    % Compute mean and sem of diff
    signalDiff     = signal{1} - signal{2};
    signalDiffMean = mean(signalDiff,2);
    signalDiffSem  = sem(signalDiff,2);

    % Plot
    subplot(2,1,2);
    lineProp2.col{1} = 'k';
    lineProp2.width  = 4;
    mseb(xAxis,signalDiffMean.',signalDiffSem.',lineProp2);

    % Format
    if (strcmp(lower(plotProp.yLim),'auto'))
        axis tight
    else
        ylim(plotProp.yLim(2,:));
    end
    xlim(xAxis([1,end]));
    refLine('x',0,'LineWidth',3,'InBack',1);
    refLine('y',0,'Color',[0.2,0.2,0.2]);

    % Annotate
    xlabel(plotProp.xLabel);
    ylabel(plotProp.yLabel);
end
