function [outputFiles] = powerNorm(Analysis,output)
% NORM POWER
%   Analyze the mean power for and across LFP sites. Analyses include mean
%   spectrograms, mean spectra, and mean power traces.
%


%%%%%%%%
% PREP %
%%%%%%%%

% Make output
prepOutput(output);

% Save Analysis Params
save([output,'/AnalysisParams.mat'],'-struct','Analysis');


%%%%%%%%%%%%%
% LOAD DATA %
%%%%%%%%%%%%%

% List and select data
DataList         = listData(Analysis.dataDirectory);
SiteParams       = listSiteParams(DataList,Analysis.database,'coord');
selectedIdx      = selectData(DataList,SiteParams,Analysis.Filter);
DataSelect       = DataList(selectedIdx);
SiteParamsSelect = SiteParams(selectedIdx);

% Write selected data
writeDataList(DataSelect,[output,'/DataSelect']);

% Load data
PowerDataBaseline = loadPowerData(Analysis.dataDirectoryRef,DataSelect);
PowerData         = loadPowerData(Analysis.dataDirectory,DataSelect);


%%%%%%%%%%%%%%%%
% PROCESS DATA %
%%%%%%%%%%%%%%%%

% Get baseline spectra
spectrogramBaselineAll = meanSpectrogram(PowerDataBaseline,Analysis.classRef,'stack');
spectrumBaselineAll    = meanSpectrum(spectrogramBaselineAll,PowerDataBaseline(1).timeAxis,[-Inf,Inf]);

% Compute mean spectograms. 
specAll = cellfun(@(x) meanSpectrogram(PowerData,x,'stack'),Analysis.class,'Un',0);

% Normalize spectrogram by baseline. Compute means. Get freq and time info.
specNormAll = cellfun(@(x) normalizeBySpectrum(x,spectrumBaselineAll),specAll,'Un',0);
freqAxis    = PowerData(1).freqAxis;
timeAxis    = PowerData(1).timeAxis;


%%%%%%%%%%%%%%%%
% PRINT OUTPUT %
%%%%%%%%%%%%%%%%

% Plot spectrogram
specMean = cellfun(@(x) mean(x,3),specNormAll,'Un',0);
hfig     = spectrogramFigure(specMean,timeAxis,freqAxis,Analysis.specLimits,Analysis.smoothSpan,Analysis.interpFactor,'Normalized Power Denisty',Analysis.classLabel);
printFigure(hfig,[output,'/Spectrogram.ps']);
close(hfig);

% Print Each
if (Analysis.doEachSpectrogram)
    for iData = 1:length(PowerData)
        titleStr{1} = [PowerData(iData).reachCode,',#',num2str(PowerData(iData).electrode)];
        specIndv = cellfun(@(x) x(:,:,iData),specNormAll,'Un',0);
        hfig     = spectrogramFigure(specIndv,timeAxis,freqAxis,Analysis.specLimits,Analysis.smoothSpan,Analysis.interpFactor,'Normalized Power Density',titleStr);
        printFigure(hfig,[output,'/SpectrogramEach.ps'],iData>1);
        close(hfig);
    end
end
