function plotSpectrogram(spec,freqAxis,timeAxis,smoothSpan,interpFactor,cLabel)
%

% Smooth
C = smoothSignal(spec,smoothSpan);

% Interpolate
C = interp2(C,interpFactor);

% Plot
imagesc(timeAxis,freqAxis,C);
axis('xy');

%% Formatting
cbar = colorbar;
colormap(jet(512));
%caxis(specLimits);
xlim(timeAxis([1,end]));
ylim(freqAxis([1,end]));

if (timeAxis(1)<0 && timeAxis(end)>0)
    refLine('x',0,'LineWidth',3);
end

%% Annotation
xlabel('Time (s)');
ylabel('Freq (Hz)');
ylabel(cbar,cLabel);
