close all; clear all; clc
addpath(genpath('~chuck/code/matlab/'));
addpath('matlab');


%%%%%%%%%%%%%%%%%
% SCRIPT PARAMS %
%%%%%%%%%%%%%%%%%

% Site data
Analysis.database{1} = '/data/coord/tyr/tyrunits';
Analysis.database{2} = '/data/coord/zen/zenunits';

% Data
Analysis.dataDirectory = 'data/LIP';
Analysis.class{1}      = 62:66;
Analysis.classLabel    = {'All Classes'};

% Data
Analysis.dataDirectoryRef = 'data/LIP';
Analysis.classRef         = 62:66;

% Filter
Analysis.Filter      = struct;

% Display
Analysis.specLimits    = [0.75,1.25]; 
Analysis.smoothSpan    = [1,1];     % Freq x Time
Analysis.interpFactor  = 2;

% Print spectrum
Analysis.spectrumInterval{1} = [0,1200];

% Print each site
Analysis.doEachSpectrogram = 1;


%%%%%%%%%%%%%
% PROCEDURE %
%%%%%%%%%%%%%

% Prep output
prepOutput;

% Run - both monks
powerNorm(Analysis,'output');
