addpath(genpath('~chuck/code/matlab'));

DIST = 0.5;

DataList   = selectDataFromDatabase('/data/coord/zen/zenunits','LFP','coord');
SiteParams = listSiteParams(DataList,'/data/coord/zen/zenunits','coord');

coordinates(1,:) = [SiteParams.xCoord];
coordinates(2,:) = [SiteParams.yCoord];
coordinates(3,:) = [SiteParams.zCoord];
hemisphere       = {SiteParams.hemisphere};
area             = {SiteParams.area};

hasArea   = strcmp({SiteParams.area},'LIP') | strcmp({SiteParams.area},'PRR');
coordBase = coordinates(:,hasArea);
hemiBase  = hemisphere(hasArea);
areaBase  = area(hasArea);

for i = 1:length(DataList)
    diff  = repmat(coordinates(:,i),[1,size(coordBase,2)]) - coordBase;
    dists = sqrt(sum(diff.^2,1));
    dists(~strcmp(hemisphere(i),hemiBase)) = Inf;
    [minDist,minIdx] = min(dists);
    if (minDist < DIST)
        areaNN{i} = areaBase{minIdx};
    else
        areaNN{i} = 'NA';
    end
end
