# doPowerVsDistance.r 	(Seul Ah Kim)
# 
rm(list = ls())
AssumeLIP_PD = F
rundoPower = F


# Looping through monkey, NEAR, and Hemisphere 
for (monk in c('tyr','zen')) {
     for (NEAR in c(0)) {
	  for (Hemisphere in c('R','L')) {
## Section 1 - Nearest to sort all sites based on distance in monk and hemi
##-------------------------------------------------------------------
a = read.table(paste0("/data/coord/", monk, "/", monk, "units"),
	                       header=T,comment="/",stringsAsFactors=F, fill=TRUE)

base = cbind(a, monk=monk)    # Rename, add "monk" column
    source("/data/coord/grab/Nearest.r")
if (AssumeLIP_PD)
	source('/data/coord/grab/AssumeLIP_PD.r')

a = base     # Remove "monk" column
rm(base)
EucNorm <- function(x) sqrt(sum(x^2))	# Define a function that computes Euclidean norm of a vector. (vector magnitude)

colnames(a) = NULL                # else rbind complains about mismatches
a = rbind(cbind(a[, c(1:2, 3:10)],"channel"=1),
	  cbind(a[, c(1:2,11:18)],"channel"=2),
	  cbind(a[, c(1:2,19:26)],"channel"=3),
	  cbind(a[, c(1:2,27:34)],"channel"=4))

colnames(a) = c("date", "file",
                "hemi", "ML", "AP", "depth", "pd", "unit", "lfp", "area","channel")

# Exclude unusable LFP entries
a = a[ !is.na(a[,"hemi" ]), ]     # exclude NA hemisphere
a = a[ !is.na(a[,"ML" ]), ]       # exclude NA ml coord
a = a[ !is.na(a[,"lfp"]), ]       # exclude NA lfp
a = a[ a[,"ML"] != "", ]          # exclude blank ml coord
a = a[ a[,"lfp"] == "1", ]        # include only 'true' lfp

# Check entries (comment out, usually)
bad = a[,"depth"] == "?" | a[,"depth"] == "????"| is.na(a[,"depth"])
if (any(bad))
   a[bad, "depth"] = -1

# If all else checks out, convert NA area to the characters NA
a[is.na(a[,"area"]),"area"] = "-"

# Fix up coordinates - convert M of ml to -, and P of AP to -
substring(a[,"ML"],1,1) = ifelse(substring(a[,"ML"], 1, 1) == "M", "-", " ")
substring(a[,"AP"],1,1) = ifelse(substring(a[,"AP"], 1, 1) == "P", "-", " ")
a[,"ML"]    = as.integer(a[,"ML"])
a[,"AP"]    = as.integer(a[,"AP"])
a[,"depth"] = as.numeric(a[,"depth"])

#  5 maps to 4.5 mm, and -5 maps to -4.5 mm
a[,c("ML","AP")] = sign(a[,c("ML","AP")]) * (abs(a[,c("ML","AP")]) - .5)
# Split into hemispheres
for (hemi in c("R","L","RR","LL"))
	assign(paste0(monk, "_", hemi),a[ a[,"hemi"]==hemi,])
# Compute coordinate of center of mass for LIP and PRR and the main vector connecting these two points.
for (h in Hemisphere) {
	hem    = which(a[   ,"hemi"]==h    )
	PRRhem = which(a[hem,"area"]=="PRR")	# PRR sites in a given hemisphere
	LIPhem = which(a[hem,"area"]=="LIP")	# LIP sites in a given hemisphere
	if (length(PRRhem)>0 && length(LIPhem)>0 ) {
		PRRgroup = c(mean(a[hem[PRRhem],"ML"]),mean(a[hem[PRRhem],"AP"]),mean(a[hem[PRRhem],"depth"]))
	       					# Coordinate of PRR center of mass
		LIPgroup = c(mean(a[hem[LIPhem],"ML"]),mean(a[hem[LIPhem],"AP"]),mean(a[hem[LIPhem],"depth"]))
						# Coordinate of LIP c.o.m
		mainvector = LIPgroup - PRRgroup	# This is the main vector connecting PRR and LIP's c.o.m
		mag_mainvector = EucNorm(mainvector)	
						# magnitude of the main vector (Euclidean norm)
		mainvector = mainvector / mag_mainvector
						# Unit vector of the main vector
		everypoint = matrix(c(a[hem,"ML"], a[hem,"AP"], a[hem,"depth"]),
				  nrow = c(length(hem)), ncol = 3)
						# Matrix containing coordinates x,y,z of every site 
		everyvector = everypoint -t(matrix(PRRgroup, ncol = length(hem), nrow = 3))
						# Subtract PRR c.o.m from every site. Every site is described by a vector originating from PRR's c.o.m
		proj = everyvector %*% mainvector
						# Scalar projection of everyvector along the main vector
		mag_everyvector = apply(everyvector,c(1),EucNorm)	
						# Magnitudes of scalar projections.

		ortho = sqrt(mag_everyvector^2-proj^2)	
						# Computes magnitude of orthogonal direction of each site
		ortholimit = 3			# exclusion parameter (2 mm)
		excl = which(abs(ortho)>ortholimit) 
						# exclusion list (exclude ortho > limit)
		
		a1   = a[hem,]			# subset of matrix which only includes rows of a given hemisphere 
		a2   = a1[-excl,]		# exclude sites that exceed ortholimit
		proj = proj[-excl,]		# Do the same to the projection list

		a2["distance"] <- proj		# Add a projection column to the a2 matrix
		a2["ortho"] <- ortho[-excl]	# Add a ortho column to the a2 matrix
		a2 = a2[order(a2$distance),]	# sort the matrix in the order of increasing projection distance
		filelist= paste0(substring(a2[,'file'],1),'_',substring(a2[,'channel'],1))	
						# list of files in the matching order	
		distancelist = a2[,"distance"]	# list of proj distances in the matching order
	}
}						# End of hemisphere loop

## End of Section 1-------------------------------------------------------------------

## Section 2- Group and Run "doGroupPower"
##-------------------------------------------------------------------------------------

clusterPRR=which(a2$area =='PRR')		# All PRR sites in a2 matrix
clusterLIP=which(a2$area =='LIP')		# All LIP sites in a2 matrix

# (Optional) Use these variables if dividing into four groups with sulcus splitting second and third groups.
outPRR=which(distancelist<0)			# Group 1: negative distance sites (left of PRR c.o.m)
outLIP=which(distancelist>mag_mainvector)	# Group 4: positive & larger than magnitude of main vector sites (right of LIP c.o.m)
inPRR=seq(tail(outPRR,1)+1,tail(clusterPRR,1),1)# Group 2: from end of Group 1 to last PRR site along main vector
inLIP=seq(head(clusterLIP,1),head(outLIP,1)-1,1)# Group 3: from first LIP site along the main vector to start of Group 4.

EqIncrement = T					# If T, each group is equidistant from its neighboring groups along distance. (assume straight line) 
						# If F, each group has same number of sites, but distance incrementsmay not be consistent. 

splitnumb=list()
ActualGroupspan=list()
if (EqIncrement){
	divnumb=5				# define # of groups to divide up sites
	SC = mag_mainvector/2			# Sulcus location estimate
	SCbinwidth = 1				# Sulcus bin width
	SCrange = which(distancelist>=(SC-SCbinwidth/2) & distancelist< (SC+SCbinwidth/2))
	#incre = SC-SCbinwidth/2			# Compute increment of bins
	PRRmedian = floor(median(which(distancelist< (SC-SCbinwidth/2))))
	LIPmedian = floor(median(which(distancelist>=(SC+SCbinwidth/2))))	
	#dislist=c(-incre,0,incre,SC+SCbinwidth/2,mag_mainvector,mag_mainvector+incre)
						# Group boundaries
#	for (g in 1:(divnumb)) {		
#  	  	lowbound=dislist[g]		# Lower bound of a group
# 		upbound=dislist[g+1]		# Uppper bound of a group
# 		if (g<divnumb) {
# 			n=which(distancelist>=lowbound & distancelist<upbound)}	
# 						# Finds sites that are inbetween lower and upper bounds
# 		else if (g==divnumb){
# 			n=which(distancelist>=lowbound )
# 						# Final group includes all sites above its lower bound.
# 		}
# 		splitnumb[[g]]=n		# Sites are grouped. 
# 	}
	splitnumb = list(1		:	PRRmedian	,
			 (PRRmedian+1)	:	(min(SCrange)-1),
			 min(SCrange)	:	max(SCrange)	,
			(max(SCrange)+1):	LIPmedian	,
			 (LIPmedian+1)	:	length(distancelist))

	
	for (i in 1:length(splitnumb))		# Actual spans of the bins-- this is the span of minimum of one bin to minimum of the next bin (exception: last bin is simply range of its maximum minus minimum distance)
		if (i == length(splitnumb))
			ActualGroupspan[[i]] = diff(range(distancelist[splitnumb[[i]]]))
		else
			ActualGroupspan[[i]] = diff(c(min(distancelist[splitnumb[[i]]]),min(distancelist[splitnumb[[i+1]]]))) 

}
else {						# This grouping will 
	LIP2PRR=seq(1,length(distancelist))
	divnumb= 2		# number of groups to split the between area
	chunk = ceiling(length(LIP2PRR)/divnumb)
	splitnumb=split(LIP2PRR, ceiling(seq_along(LIP2PRR)/chunk))
}

#Groups = list(outPRR,inPRR,inLIP,outLIP)	# Use this option if you want 4 groups (2 groups per area) 
#Groups = list(clusterPRR,clusterLIP)		# Use this option if you want PRR and LIP groups 
Groups = splitnumb				# Use this option to group into the number of groups specified by "divnumb"

# Run doPower here
MONK.OVERRIDE = monk
FREQ.OVERRIDE = '4:240:2'
ALIGN.OVERRIDE = 'go' 				# "" (targ), "gocue", "go", "end", "EOT"
NEAR.OVERRIDE = NEAR				# [2] extend bounds of LIP and PRR
MERGE = 1					# MERGE options
		# 1: merge all  (standard; most commmon		
		# 2: pref & null
	        # 0: do not merge
                # 10: pref only
                # 20: right, left (skip if vertical only)
                # Usually use '1'; also '2' and '20' (and maybe 10)

SORT_BY_SACCADE = F				 # Split class 66 based on which arm sac goes with
PRINT = F					 # Print the calls
EXECUTE = T					 # Execute the calls

for (loop2 in 1:length(Groups)) {		 # Run doPower on individual groups
	loop = loop2
	totGroup = length(Groups)		 # Total number of groups
	base = a2[Groups[[loop]],]
	if (rundoPower) {	
	if (length(Groups[[loop]])>0)	 
		source('/data/coord/grab/power/doGroupPower.r')	# Power analysis using macro 11
}}	

## End of Section 2----------------------------------------------------------------------
	  }
     }
}
