# doPower.r

###########################################################################

# Set basic parameters #
########################
AREA = "LIP"
MONK = "tyr"	# zen, tyr, both (don't use both: R calls will merge monks)
MEMORY = F	# T or F - can only be run with Zen, LIP (have not tested...)
ALIGN = ""	# "" (targ), "gocue", "go", "end", "EOT"
NEAR = 2	# [1.25] extend bounds of LIP and PRR
AssumeLIP_PD = F	# Set all LIP pd's to contralateral

PRINT = F		# Print the calls?
PRINT.BRIEF = T		# Just the names of the cells
EXECUTE = T		# Excecute the calls?

SORT_BY_SACCADE = 0	# Split class 66 based on which arm sac goes with
     SAC_TYPE = 3.1	# SORT_TYPE.MINIMUM_TRIALS from ByterSplitInput.b
			# NOTE - MUST set this; not inherited !!!
		# *** Go to ByterSplit.b and set SORT_TYPE !!
		# Call byters; set PRINT_BY_SACCADE to TRUE in cunguosort.c
		#    (this is done thru an initiation call, i think)
		# MERGE should equal 1

PREV_TRIAL_ERROR = 0  # Split all the trials based on whether
			# previous trial is a success (PS) or a failure (PF)

MERGE = 1
		# 1: merge all	(standard; most commmon)
		# 2: pref & null
		# 0: do not merge
		# 10: pref only
		# 20: right, left (skip if vertical only)
		# Usually use '1'; also '2' and '20' (and maybe 10)

if (exists("OVERRIDE"))  {
   MONK  = ifelse(exists("MONK.OVERRIDE"),  MONK.OVERRIDE,  MONK)
   AREA  = ifelse(exists("AREA.OVERRIDE"),  AREA.OVERRIDE,  AREA)
   NEAR  = ifelse(exists("NEAR.OVERRIDE"),  NEAR.OVERRIDE,  NEAR)
   MERGE = ifelse(exists("MERGE.OVERRIDE"), MERGE.OVERRIDE, MERGE)
   ALIGN = ifelse(exists("ALIGN.OVERRIDE"), ALIGN.OVERRIDE, ALIGN)
   }

###########################################################################
# GRAB PARAMETERS #
###################
					# Max align determined by RESTRICT
ALIGN_CMD = switch( ifelse(ALIGN=="", "target", ALIGN),
  target = "-at2 -i-450:1350 -ot400 ",			# target
 # target = "-at2 -i-450:1900 -ot200 ",			# unusual version  
 gocue	= "-abt1 -i-1000:400 -ot200 ",			# Cue to move
 go	= "-a#62a3 -aKb1 -i-1450:200 -ot100 ",		# Start of the movement
 end	= "-a#65I1 -a#66I1 -aa$ -i-1200:250 -ot100 ",	# end of move (acquire)
 EOT	= "-aYRedraw -i-1200:240 -ot80 "		# 10 ms after 'end'
 )
 
 # Alignment notes:
   # -ot   	-ot100 will run more slowly (and be less smooth) than -ot400,
   #	   but only 50 ms will be truncated from each side, rather than 200,
   #	   and of course the time resolution will be higher
   # target	-i: 1250 + 100 + minimum of RESTRICT parameter
   # go		saccades (62) should be -asb1, but that sometimes fails
   # end	aligned on FIRST arm acquire for bimanual movements
   # EOT	aligned on LAST arm acquire for bimanual movements

FREQ =	#"-of10:120:10"	# Sparse freq range
	# "-of4:240:2"	# Fine gradiations
	 "-of4:120:4"	# Fine gradiations

RESTRICT = 
	""	# Fixed delay is 1250; can go 50 ms past that (visual latency)
#	"-XeDelay_300:1000,2 "  # minimum delay adds to max allowed

FILTER = "-ol0 "	# Implmented? -ol__ : low-pass filter -3dB point

MORE   = " -xs67 "	# Horizontals!

###########################################################################
System = function(command, print=PRINT, do=EXECUTE, intern=T) {
	if (print)
	   cat(paste(command, "\n"))
	if (do) {
	   system(paste("tcsh -c '", command, "'"), intern=intern)
	 } else
	   return(1)	# Occasionally helps
	}
	# Allows us to use "{"  (by default, sh is used; use tcsh)
	# But if no match you get ugly results

a = b = NULL
if (MONK=="zen" || MONK=="both") {
   a = read.table(
	paste0("/data/coord/zen/zenunits", ifelse(MEMORY, "_memory", "")),
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   a = cbind(a, monk="zen")		# Append monkey name (as a column)
   }
if (MONK=="tyr" || MONK=="both") {
   b = read.table("/data/coord/tyr/tyrunits",
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   b = cbind(b, monk="tyr") 		# Append monkey name (as a column)
   }
base = rbind(a,b)			# Required for 'both'
rm(a,b)

# ADD TO A FILE THAT IS CALLED EVERYWHERE THAT THE DATA BASES ARE READ!!!
base[base==""] = NA			# Else there are blanks!!!
base[is.na(base[,"pd1"]), "pd1"] = 0
base[is.na(base[,"pd2"]), "pd2"] = 0
base[is.na(base[,"pd3"]), "pd3"] = 0
base[is.na(base[,"pd4"]), "pd4"] = 0

base[is.na(base[,"area1"]), "area1"] = "?"
base[is.na(base[,"area2"]), "area2"] = "?"
base[is.na(base[,"area3"]), "area3"] = "?"
base[is.na(base[,"area4"]), "area4"] = "?"


if (NEAR)
   source("Nearest.r")

if (AssumeLIP_PD)
   source("AssumeLIP_PD.r")

SUFFIX =  ifelse(SORT_BY_SACCADE, ".split",
					ifelse(PREV_TRIAL_ERROR, ".pte", ""))

Convert = function(keep) {
	String = ""

	L = length(keep)
	# cat("\nDIAG:", L, keep, "\n")
	if (L == 0)
           stop("how could this be?")
	if (L == 1)
           return(paste0(" -Xt", keep, " "))
	
	from = keep[1:(L-1)] + 1
	to   = keep[2:L    ] - 1

	if (keep[1] > 1)
	   String = paste0(" -xt1:", keep[1]-1)

	for (j in 1:(L-1)) {
            if (to[j] > from[j])
               String = paste0(String, " -xt", from[j], ":", to[j])
            if (to[j] == from[j])
               String = paste0(String, " -xt", from[j])
	    }
	String = paste0(String, " -xt", keep[L]+1, ":", 10000)

	# cat("DIAG:", keep, "-->", String, "\n")
	return(paste(String, collapse=""))
	}


# Remove any old intermediate data files before you start (don't echo/print)
system("rm -fr /data/coord/[zt]??/[0-9][0-9]-*/PowerData*")
#system("rm -fr /data/coord/[zt]??/[0-9][0-9]-*/DFTpowerData*")

cat(MONK,AREA,
	if (NEAR) paste("+", NEAR),
	if (MERGE) paste(" merge=", MERGE),
	if (ALIGN != "") paste(" align on", ALIGN),
	"\n")

for (channel in 1:4)			# For each recording channel
  for (i in which(base[,paste0("area",channel)] == AREA)) {
    ## Do only a few cells:
    # if (!(base[i,"reach_file"]=="982.2" ||
    #       base[i,"reach_file"]=="1042.4"))
    #    next

    # For recording from the requested area, set i to the ROW of base
    pref.class = as.numeric(base[i,paste0("pd",channel)])
    null.class = (((pref.class-1)+4) %% 8) + 1	# Opposite of preferred
    
    if (MERGE==2 || MERGE==10 || SORT_BY_SACCADE)	# If PD is required,
       if (is.na(pref.class) || pref.class==0)
          next		# Skip if PD not specified or otherwise absent

    if (MERGE==20)	# Right+left only: skip if only verticals (class 3 & 7)
       if (System(paste0("grab -xc3 -xc7 -R ",		# -Report trials
                  "/data/coord/", base[i,"monk"],	#  -xclusive of classes
		  "/", base[i,"date"],			#  3 & 7 (the verticals)
		  "/s", base[i,"reach_file"],
		  SUFFIX,				# if SORT_BY_SACCADE
		  " | wc -l")) == "0")			# count the lines
	  next						# Skip if zero
          
    Command_cd = paste0(				# Go to the directory
	 "cd /data/coord/", base[i,"monk"], "/", base[i,"date"], "; ")
    Command_grab = paste0(				# Call grab
	 "grab ", ALIGN_CMD, RESTRICT, FILTER, FREQ, 	#  with options
	    " -d", channel,			# -d1, -d2, -d3, or -d4

	    		# From database, ask for just left or right hemisphere:
	    " -oh", ifelse(base[i, paste0("hem",channel)]=="R", 1, 0),

	    		# Pick the right classes (with appropriate merging):
	    if (MERGE == 2)
	        paste0(" -mc101,",pref.class," -mc102,",null.class," -xc1:8 ",
		      	sep="")
            else if (MERGE == 20)
	        " -mc1,2,8 -mc5,4,6 -xc3 -xc7"
            else if (MERGE == 10)
	        paste0(" -mc101,", pref.class, " -xc1:8 ")
            else if (MERGE == 1)
		" -mc ",
	    MORE,	# out here - else chg's -x versus -m order!

	    # " -od",				# Development flag
	    " -o11",				# Macro 11
	    " s", base[i,"reach_file"],		# File name
	    SUFFIX)				# if SORT_BY_SACCADE

    if (PRINT.BRIEF)
       cat(paste0(base[i,"date"], "  s", base[i,"reach_file"], "\n"))

    if (SORT_BY_SACCADE) {
       system("rm -f ByterSplitInput.b; echo Nf > ByterSplitInput.b")
       system(paste0("echo /data/coord/",
	     		base[i, "monk"], "/",
	     		base[i, "date"], "/",
		  	"/s",
		       	base[i,"reach_file"],
			" >> ByterSplitInput.b"))
       system(paste0("echo *", channel-1, ">> ByterSplitInput.b"))
       system(paste0("echo *C",  base[i, paste0("pd",channel)], 
		     				">> ByterSplitInput.b"))

       # byter output into "./ByterSplitOutput"
       system("rm -f ByterSplitOutput;m4 ByterSplit.b | byterps -f > /dev/null")
          # The byter call skips cells without the requested sac splits.
          # BUT: if split by class (PN, RL, etc), it does not know if one CLASS
          #      is entirely missing.  Have to handle that later.

       # read "./ByterSplitOutput" into a data structure ("A")
       A <- matrix(scan("ByterSplitOutput", skip=1, quiet=T), byrow=T, ncol=4)
       colnames(A) = c("unit", "run",  "trial", "code")
       if (length(A) == 0)
	  next					#  None to keep -- skip!
       if ((length(unique(A[,"unit"])) > 1) |	# quick sanity check
           (length(unique(A[,"run" ])) > 1))
	 stop("Mismatch")

       # Pull out the two types, so can be turned into unique stacks
       KEEP_1 = Convert(A[ A[,"code"]==sort(unique(A[,"code"]))[1], "trial"])
       KEEP_2 = Convert(A[ A[,"code"]==sort(unique(A[,"code"]))[2], "trial"])
       rm(A)	# ORDER: 01(P/P) 04(SacP/ArmN) 02(SacN/ArmP) 010(N/N)
       # So an 03 means that 66 is P/P and 67 is SacN/ArmP (arm = contra arm)

#       system("rm -f ByterSplitInput.b ByterSplitOutput")

       # Pull out stack 66, add back only those you want, split into 2 stacks
       Command_MakeFile = paste0(
	"rm -f s", base[i,"reach_file"], SUFFIX,			"\n",
	"grab -w-.none -xs66 -xs86 s", base[i,"reach_file"],		"\n",
   "grab -w-.split1 -ms661,66 -ms861,86 ",KEEP_1," s",base[i,"reach_file"],"\n",
   "grab -w-.split2 -ms662,66 -ms862,86 ",KEEP_2," s",base[i,"reach_file"],"\n",
	"cat s", base[i,"reach_file"], ".none s",
		 base[i,"reach_file"], ".split1 s",
		 base[i,"reach_file"], ".split2> s",
		 base[i,"reach_file"], SUFFIX)

	System(paste(Command_cd, "\n", Command_MakeFile))
      }

		if(PREV_TRIAL_ERROR) {
				cat("here and working on s", base[i,"reach_file"], "\n")
				system(paste0(" grab -R3 /data/coord/", base[i,"monk"], "/", base[i,"date"], "/s", base[i,"reach_file"], " > trialinfo.in"))
				system("awk '{gsub(/\\./,\"\t\",$0);gsub(/[\\(|\\)|:]/,\"\",$0); print}' trialinfo.in>trialinfo.out")
				A <- matrix(scan("trialinfo.out", quiet=T), byrow=T, ncol=4)
				colnames(A) = c("unit","run","trial","trialN")
				if (length(A) == 0 )
						next
				if ((length(unique(A[,"unit"])) > 1) |
						(length(unique(A[,"run" ])) > 1))
						stop("Mismatch")

				# determine previous trial correctness
				code = NULL
			  # first trial separately:	
				for(j in 1:dim(A)[1]) {
				    if(j == 1) {         
								if(A[j,"trialN"] > 1)  # for case when started with errors b4 first correct
										code = c(code,1)
								else
										code = c(code,0)
						} else {
						if(A[j,"trialN"] - A[j-1,"trialN"] == 1)
								code = c(code,1)
						else
								code = c(code,0)
						}
				}
				
				if(dim(A)[1] == length(code)) {
						A = cbind(A,code)
				    A = A[,-4]  # just to match format for SORT_BY_SACCADE
				}
				else {
					stop("Mismatch")
				}

				KEEP_1 = Convert(A[ A[,"code"]==sort(unique(A[,"code"]))[1], "trial"])
				KEEP_2 = Convert(A[ A[,"code"]==sort(unique(A[,"code"]))[2], "trial"])
				rm(A)

				Command_MakeFile = paste0(
					"rm -f s", base[i,"reach_file"], SUFFIX,      "\n",
					"grab -w-.none s", base[i,"reach_file"],    "\n",
		      "grab -w-.PF ",KEEP_1," s",base[i,"reach_file"],"\n",
		      "grab -w-.PS ",KEEP_2," s",base[i,"reach_file"],"\n",
	        "cat s", base[i,"reach_file"], ".none s",
			     base[i,"reach_file"], ".PF s",
		       base[i,"reach_file"], ".PS> s",
           base[i,"reach_file"], SUFFIX)

	  	  System(paste(Command_cd, "\n", Command_MakeFile))

		}

    # Here is were we make the actual call(s)
    System(paste(Command_cd, "\n", Command_grab))


    if (SORT_BY_SACCADE) {
	Command_RmFiles = paste0(
	  "rm s", base[i,"reach_file"], ".none s",
		  base[i,"reach_file"], ".split1 s",
		  base[i,"reach_file"], ".split2 s",
		  base[i,"reach_file"], SUFFIX)
	system(paste(Command_cd, "\n", Command_RmFiles))
	}
    if (PREV_TRIAL_ERROR) {
	Command_RmFiles = paste0(
	  "rm s", base[i,"reach_file"], ".none s",
		  base[i,"reach_file"], ".PF s",
		  base[i,"reach_file"], ".PS s",
		  base[i,"reach_file"], SUFFIX)
	system(paste(Command_cd, "\n", Command_RmFiles))
	}
    }

# cat("DIAG: processes =", 
#    system(paste(
#	 	"ps -a | grep `ps -a -o tty,ppid | grep",
#  		 Sys.getpid(),
#		"| awk '{ print $1 }'` | wc -l"), intern=T),
#    "\n")


# All done looping thru database; now TRANSFER the data and clean up any mess

# Save the data files to a new directory
Directory = paste0("/data/coord/grab/power/R/data/",
       AREA, 
       if (NEAR) paste0("+", NEAR),
       "_", 
       MONK, 
       if (MEMORY) "_memory",
       if (FREQ != "-of10:120:10") paste0("_", substring(FREQ, 4)),
       if (ALIGN != "") "_",
       ALIGN,
       if (MERGE==0)  "_all8",
       if (MERGE==10) "_pref",
       if (MERGE==2)  "_PN",
       if (MERGE==20) "_RL",
       # "_low.freq",
       if (SORT_BY_SACCADE) paste0("_SacSplit_",SAC_TYPE),
       if (AssumeLIP_PD) "_AssumeLIP_PD",
			 if (PREV_TRIAL_ERROR) paste0("_PrevTrialError") )

System(paste("mkdir -p", Directory))
System(paste("mv /data/coord/{zen,tyr}/[0-9][0-9]-*/PowerData* ", Directory))
#System(paste("mv /data/coord/{zen,tyr}/[0-9][0-9]-*/DFTpowerData* ", Directory))

# Clean up other files that the macro spat out (and if -od flag, did not rm)
#  To use {zen,tyr}, need tcsh, but when rm -od flag, this may cause trouble!
#    (if no match, may get ugly results)
# System("rm -f /data/coord/{zen,tyr}/[0-9][0-9]-*/power*ps")
System("rm -f /data/coord/{zen,tyr}/[0-9][0-9]-*/matlab.stdout.*", intern=F)
System("rm -f /data/coord/{zen,tyr}/[0-9][0-9]-*/{Parameters,TrialData}.temp",
       								   intern=F)
# if (SORT_BY_SACCADE)
# DIAG: uncomment prev and next lines:
#   System("rm -f ByterSplitInput.b ByterSplitOutput")
