# doPower.r
#   Cannot run simultaneous analyses if SPLIT_SACCADE !

###########################################################################

# Set basic parameters (override if DoAll) #
############################################
AREA = "PRR"
MONK = "tyr"	# zen, tyr, both (don't use both: R calls will merge monks)
MEMORY = F	# T or F - can only be run with Zen, LIP (have not tested...)
ALIGN = ""	# "" (targ), "gocue", "go", "sac" "end", "EOT"
NEAR = 2	# [2] extend bounds of LIP and PRR
AssumeLIP_PD = F	# Set all LIP pd's to contralateral
STIMULATE = F
SACONLY = F

MATCHING = F	# Matching pursuit?

PRINT = F		# Print the calls?
PRINT.BRIEF = T		# Just the names of the cells
EXECUTE = T		# Excecute the calls?

SORT_BY_SACCADE = 0	# Split class 66 based on which arm sac goes with
     SAC_TYPE = 3.1	# SORT_TYPE.MINIMUM_TRIALS from ByterSplitInput.b
		# Inherited by ByterSplitInputPre.b so byter sees it
		# Call byters; set PRINT_BY_SACCADE to TRUE in cunguosort.c
		#    (this is done thru an initiation call, i think)
		# MERGE should equal 1

MERGE = 1
		# 1: merge all	(standard; most commmon)
		# 2: pref & null
		# 0: all8: do not merge (all8)
		# 10: pref only
		# 20: right, left (skip if vertical only)
		# Usually use '1'; also '2' and '20' (and maybe 10)

SKIP_EARLY = 	0		# [0] 288?
DO_EARLY = 	0		# [0] 144?

if (exists("OVERRIDE"))  {
   MONK  = ifelse(exists("MONK.OVERRIDE"),  MONK.OVERRIDE,  MONK)
   AREA  = ifelse(exists("AREA.OVERRIDE"),  AREA.OVERRIDE,  AREA)
   NEAR  = ifelse(exists("NEAR.OVERRIDE"),  NEAR.OVERRIDE,  NEAR) 
   MERGE = ifelse(exists("MERGE.OVERRIDE"), MERGE.OVERRIDE, MERGE)
   ALIGN = ifelse(exists("ALIGN.OVERRIDE"), ALIGN.OVERRIDE, ALIGN)
   SAC_TYPE = ifelse(exists("SAC_TYPE.OVERRIDE"), SAC_TYPE.OVERRIDE, SAC_TYPE)
   SORT_BY_SACCADE = ifelse(exists("SORT_BY_SACCADE.OVERRIDE"), 
			    	SORT_BY_SACCADE.OVERRIDE, SORT_BY_SACCADE)
   STIMULATE = ifelse(exists("STIMULATE.OVERRIDE"),STIMULATE.OVERRIDE,STIMULATE)
   SACONLY   = ifelse(exists("SACONLY.OVERRIDE"),  SACONLY.OVERRIDE,  SACONLY)
   CC_INACT  = ifelse(exists("CC_INACT.OVERRIDE"), CC_INACT.OVERRIDE, CC_INACT)
   MATCHING  = ifelse(exists("MATCHING.OVERRIDE"), MATCHING.OVERRIDE, MATCHING)
   SKIP_EARLY  = ifelse(exists("SKIP_EARLY.OVERRIDE"), 
				SKIP_EARLY.OVERRIDE, SKIP_EARLY)
   DO_EARLY  = ifelse(exists("DO_EARLY.OVERRIDE"), 
				DO_EARLY.OVERRIDE, DO_EARLY)
   }

###########################################################################
# GRAB PARAMETERS #
###################
				# Max align can be determined by RESTRICT
FREQ =	# "-of10:120:10"	# Coarse gradations
	# "-of4:120:4"	# Medium gradiations
	  "-of4:240:2"	# Fine gradiations  - current standard
ALIGN_CMD = switch(ifelse(ALIGN=="", "target", 
		   ifelse(ALIGN=="go" & TimeWindow<201, "SHORT_GO",
			    ALIGN)),
  target = "-at2 -i-450:1350 ",			# target (400)
# target = "-at2 -i-450:1550 ",			# unusual version  
  gocue	= "-abt1 -i-1200:600 ",			# Cue to move (100,200,400)
  go	= "-a#62a3 -aKb1 -i-1500:300 ",		# Start of movement (100,200)
  SHORT_GO = 
	  "-a#62a3 -aKb1 -i-1500:250 ",		# Start of movement (100,200)
  sac	= "-avb1 -i-1500:300 ",			# Peak velocity of sac (100,200)
  end	= "-a#65I1 -a#66I1 -aa$ -i-1200:250 ",	# end of move (acquire) (100)
  EOT	= "-aYRedraw -i-1200:240 "		# 10 ms after 'end' (80)
  )
if (MATCHING) {
   FREQ = ""	# Unused
   ALIGN_CMD = switch( ifelse(ALIGN=="", "target", ALIGN),
   target = "-at2 -oi-600:1400 ",		# 2048 ms
   gocue  = "-abt1 -oi-1400:640 ",		# 2048 ms
   go	  = "-a#62a3 -aKb1 -oi-600:420 ",	# 1024 ms
   sac	  = "-avb1 -oi-600:420 ")		# 1024 ms
   }

# ALIGN_CMD = paste0(ALIGN_CMD, " -ms64:66 -xs62:63 ")	# DIAG
# cat("DIAG: Just 3 stacks\n")

ALIGN_CMD = paste0(ALIGN_CMD, " -ot", TimeWindow, " ")
 # Alignment notes:
   # -ot   	-ot100 will run more slowly (and be less smooth) than -ot400,
   #	   but only 50 ms will be truncated from each side, rather than 200,
   #	   and of course the time resolution will be higher
   # target	-i: 1250 + 100 + minimum of RESTRICT parameter
   # go		saccades (62) should be -asb1, but that sometimes fails
   # end	aligned on FIRST arm acquire for bimanual movements
   # EOT	aligned on LAST arm acquire for bimanual movements

RESTRICT = 
	 ""	# Fixed delay is 1250; can go 50 ms past that (visual latency)
	# "-XeDelay_0,2 "  # Use only zero random delay trials (0 ms)
	# "-XeDelay_300:500,2 "  # Use only random delay 300 to 500 ms trials

FILTER = "-ol0 "	# Implmented? -ol__ : low-pass filter -3dB point ???

# ** Merge 1st! **  67:Horiz 76:duplicate 190's:skip   skip if no align
#  exclude 67 (added LHS 2020-07-21)
MORE   = " -ms66,76 -Xs52:96 -xs57:61 -xs68:91 -xs67  -ax "	


###########################################################################
System = function(command, print=PRINT, do=EXECUTE, intern=T) {
	if (print)
	   cat(paste(command, "\n"))
	if (do) {
	   system(paste("tcsh -c '", command, "'"), intern=intern)
	 } else
	   return(1)	# Occasionally helps
	}
	# Allows us to use "{"  (by default, sh is used; use tcsh)
	# But if no match you get ugly results

a = b = NULL
if (MONK=="zen" || MONK=="both") {
   a = read.table(
	paste0("/data/coord/zen/zenunits", 
	       	if (MEMORY)       "_memory",
	       	if (SACONLY)      "_saconly",
	  	if (STIMULATE)    "_stim",
		if (CC_INACT>10)  "_memory",
		if (CC_INACT>0)   "_cc_",
	      	if ((CC_INACT%%10)==1)  "inactivate",
		if ((CC_INACT%%10)==2)  "control"),
	   header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   a = cbind(a, monk="zen")		# Append monkey name (as a column)
   }
if (MONK=="tyr" || MONK=="both") {
   b = read.table(paste0("/data/coord/tyr/tyrunits",
	       	if (SACONLY)      "_saconly",
		if (CC_INACT>10)  "_memory",
		if (CC_INACT>0)   "_cc_",
	      	if ((CC_INACT%%10)==1)  "inactivate",
		if ((CC_INACT%%10)==2)  "control"),
	   header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   b = cbind(b, monk="tyr") 		# Append monkey name (as a column)
   }
base = rbind(a,b)			# Required for 'both'
rm(a,b)

# ADD TO A FILE THAT IS CALLED EVERYWHERE THAT THE DATA BASES ARE READ!!!
base[base==""] = NA			# Else there are blanks!!!
base[is.na(base[,"pd1"]), "pd1"] = 0
base[is.na(base[,"pd2"]), "pd2"] = 0
base[is.na(base[,"pd3"]), "pd3"] = 0
base[is.na(base[,"pd4"]), "pd4"] = 0

base[is.na(base[,"area1"]), "area1"] = "?"
base[is.na(base[,"area2"]), "area2"] = "?"
base[is.na(base[,"area3"]), "area3"] = "?"
base[is.na(base[,"area4"]), "area4"] = "?"


if (NEAR)
   source("Nearest.r")

if (AssumeLIP_PD)
   source("AssumeLIP_PD.r")

SUFFIX =  if (SORT_BY_SACCADE) ".split" else ""

Convert = function(keep) {
	String = ""

	L = length(keep)
	# cat("\nDIAG:", L, keep, "\n")
	if (L == 0)
           stop("how could this be?")
	if (L == 1)
           return(paste0(" -Xt", keep, " "))
	
	from = keep[1:(L-1)] + 1
	to   = keep[2:L    ] - 1

	if (keep[1] > 1)
	   String = paste0(" -xt1:", keep[1]-1)

	for (j in 1:(L-1)) {
            if (to[j] > from[j])
               String = paste0(String, " -xt", from[j], ":", to[j])
            if (to[j] == from[j])
               String = paste0(String, " -xt", from[j])
	    }
	String = paste0(String, " -xt", keep[L]+1, ":", 10000)

	# cat("DIAG:", keep, "-->", String, "\n")
	return(paste(String, collapse=""))
	}


# Remove any old intermediate data files before you start (don't echo/print)
# system("rm -fr /data/coord/[zt]??/[0-9][0-9]-*/PowerData*")
# system("rm -fr /data/coord/[zt]??/[0-9][0-9]-*/DFTpowerData*")

cat(MONK,AREA,
	if (NEAR) paste("+", NEAR),
	if (MERGE) paste(" merge=", MERGE),
	if (ALIGN != "") paste(" align on", ALIGN),
	"\n")

# Make the new directory
Directory = paste0("/data/coord/grab/power/R/data",
       if (CHRONUX) ".chronux",
       "/",
       if (SORT_BY_SACCADE) "splits/",
       if (CC_INACT) "cc_inact/",
       if (CC_INACT) paste0(TimeWindow, "ms/"),
       AREA, 
       if (NEAR) paste0("+", NEAR),
       "_", 
       MONK, 
       if (MEMORY) "_memory",
       if (SACONLY) "_saconly",
       if (STIMULATE) "_stim",
       switch((CC_INACT+1) %% 10, "", "_cc", "_ccc"),
       if (CC_INACT>10)  "_memory",
       if (FREQ != "-of10:120:10" && FREQ != "") paste0("_",substring(FREQ, 4)),
       if (ALIGN != "") "_",
       ALIGN,
       if (MERGE==0)  "_all8",
       if (MERGE==10) "_pref",
       if (MERGE==2)  "_PN",
       if (MERGE==20) "_RL",
       if (SKIP_EARLY) paste0("_xt1:",SKIP_EARLY), 
       if (DO_EARLY)   paste0("_Xt1:",DO_EARLY), 
       # if (MATCHING) paste0("_", TimeWindow, "ms"),
       if (SORT_BY_SACCADE) paste0("_SacSplit_",SAC_TYPE),
       if (AssumeLIP_PD) "_AssumeLIP_PD",
       if (MATCHING) "_mp")

if (file.exists(Directory))
   System(paste("rm -fr", Directory))
System(paste("mkdir -p", Directory))

cat("DIAG: Directory is", Directory, "\n")

for (channel in 1:4)			# For each recording channel
  for (i in which(base[,paste0("area",channel)] == AREA)) {
    cat("DIAG: ")
  
    LocalDirectory = paste0("/data/coord/", base[i,"monk"], "/", base[i,"date"])
    cat(LocalDirectory, "\n")  # DIAG

    if (is.na(base[i,paste0("lfp",channel)]))
	   next
    if (base[i,paste0("lfp",channel)] != 1)
	   next
    # Do only a few cells:
      # cat("@")  # clear sign that something is odd, but only one line
      # if (!(base[i,"reach_file"]=="1226.2" ||  #  && channel==1)) # ||
      #       base[i,"reach_file"]=="1231.2"))
      #    next

    # For recording from the requested area, set i to the ROW of base
    pref.class = as.numeric(base[i,paste0("pd",channel)])
    null.class = (((pref.class-1)+4) %% 8) + 1	# Opposite of preferred
    
    if (MERGE==2 || MERGE==10 || SORT_BY_SACCADE)	# If PD is required,
       if (is.na(pref.class) || pref.class==0)
          next		# Skip if PD not specified or otherwise absent

    if (MERGE==20)	# Right+left only: skip if only verticals (class 3 & 7)
       if (System(paste0("grab -xc3 -xc7 -R ",		# -Report trials
		  LocalDirectory,  # -xclusive of classes, 3 & 7: the verticals
		  "/s", base[i,"reach_file"],
		  SUFFIX,				# if SORT_BY_SACCADE
		  " | wc -l")) == "0")			# count the lines
	  next						# Skip if zero

          
    Command_cd = paste0("cd ", LocalDirectory, "; ")	# Go to the directory

    if ((MERGE==0) &
        (system(paste0("cd ", LocalDirectory, ";",
	             "grab -R42 s", base[i,"reach_file"]), intern=T) != 8)) {
       cat("Less than 8 classes - skip\n")
       System(paste0("rm -f ", LocalDirectory, "/LFP_lockfileR.temp"))
       next					# Just one class (i think)
       }

    Command_grab = paste0(				# Call grab
	 "grab ",
	    MORE,	# First - sets "merge" before "exclude"
	    ALIGN_CMD, RESTRICT, FILTER, FREQ, 	#  with options
	    " -d", channel,			# -d1, -d2, -d3, or -d4

	    	# From database, ask for just left or right hemisphere:
	    	# (either "R" or "RR"; but moot - "RR" has no LIP or PRR units)
	    " -oh", ifelse(substr(base[i,paste0("hem",channel)],1,1)=="R",1,0),

	    if (SKIP_EARLY)
	 	paste0(" -xt1:",SKIP_EARLY, " "), 
	    if (DO_EARLY)
	 	paste0(" -Xt1:",DO_EARLY, " "), 

	    		# Pick the right classes (with appropriate merging):
	    if (MERGE == 2)
	        paste0(" -mc101,",pref.class," -mc102,",null.class," -xc1:8 ",
		      	sep="")
            else if (MERGE == 20)
	        " -mc1,2,8 -mc5,4,6 -xc3 -xc7"
            else if (MERGE == 10)
	        paste0(" -mc101,", pref.class, " -xc1:8 ")
            else if (MERGE == 1)
		" -mc ",


	    paste0(" -oC", ifelse(CHRONUX,1,0)),

	    ifelse(MATCHING, " -o311", " -o11"),
	    " s", base[i,"reach_file"],		# File name
	    SUFFIX)				# if SORT_BY_SACCADE


    if (PRINT.BRIEF)
       cat(paste0(base[i,"date"], "  s", base[i,"reach_file"], "\n"))

    while (file.exists(paste0(LocalDirectory, "/LFP_lockfileR.temp"))) {
      cat("Waiting for LFP_lockfileR to go away", LocalDirectory, "\n")
      Sys.sleep(5)
      }
    System(paste0("touch ", LocalDirectory, "/LFP_lockfileR.temp"))

    if (SORT_BY_SACCADE) {
       system("rm -f ByterSplitInput.b ByterSplitInputPre.b")

       Set_String = paste0("'define(SORT_TYPE, ", round(SAC_TYPE %/% 1), ")'")
       system(paste("echo", Set_String, "> ByterSplitInputPre.b"))
       Set_String = paste0("'define(MINIMUM_TRIALS, ", round(10*(SAC_TYPE %% 1)), ")'")
       system(paste("echo", Set_String, ">> ByterSplitInputPre.b"))
       rm(Set_String)

       # If add 
       #    *^C`'eval(1000+1000+SORT_TYPE*10+MINIMUM_TRIALS)
       # to input right here, then can do it all in one file.

       system("echo Nf > ByterSplitInput.b")
       system(paste0("echo ", LocalDirectory,
		  	"/s",
		       	base[i,"reach_file"],
			" >> ByterSplitInput.b"))
       system(paste0("echo *", channel-1, ">> ByterSplitInput.b"))
cat("DIAG: Add explict hemisphere call here\n")  # DIAG: 2017-3-30
       system(paste0("echo *C",  base[i, paste0("pd",channel)], 
		     				">> ByterSplitInput.b"))

       # byter output into "./ByterSplitOutput"
       system("rm -f ByterSplitOutput;m4 ByterSplit.b | byterps -f > /dev/null")
          # The byter call skips cells without the requested sac splits.
          # BUT: if split by class (PN, RL, etc), does not know if one CLASS is
          #  entirely missing. Have to handle that later. (See 2016-9-1 note)

       # read "./ByterSplitOutput" into a data structure ("A")
       A <- matrix(scan("ByterSplitOutput", skip=1, quiet=T), byrow=T, ncol=4)
       colnames(A) = c("unit", "run",  "trial", "code")
       if (length(A) == 0) {
          System(paste0("rm -f ", LocalDirectory, "/LFP_lockfileR.temp"))
	  next					#  None to keep -- skip!
          }
       if (length(unique(A[,"code"])) == 1) {
	  # Added this 2016-9-1 -- unsure how lived without it!
	  cat("Just one class - skip\n")
          System(paste0("rm -f ", LocalDirectory, "/LFP_lockfileR.temp"))
	  next					# Just one class (i think)
          }
       if ((length(unique(A[,"unit"])) > 1) |	# quick sanity check
           (length(unique(A[,"run" ])) > 1))
	 stop("Mismatch")

       # Pull out the two types, so can be turned into unique stacks
       KEEP_1 = Convert(A[ A[,"code"]==sort(unique(A[,"code"]))[1], "trial"])
       KEEP_2 = Convert(A[ A[,"code"]==sort(unique(A[,"code"]))[2], "trial"])
       rm(A)	# ORDER: 01(P/P) 04(SacP/ArmN) 02(SacN/ArmP) 010(N/N)
       # So an 03 means that 66 is P/P and 67 is SacN/ArmP (arm = contra arm)

       system("rm -f ByterSplitInput.b ByterSplitInputPre.b ByterSplitOutput")

       # Pull out stack 66, add back only those you want, split into 2 stacks
       Command_MakeFile = paste0(
	"rm -f s", base[i,"reach_file"], SUFFIX,			"\n",
	"grab -w-.none -xs66 -xs86 s", base[i,"reach_file"],		"\n",
   "grab -w-.split1 -ms661,66 -ms861,86 ",KEEP_1," s",base[i,"reach_file"],"\n",
   "grab -w-.split2 -ms662,66 -ms862,86 ",KEEP_2," s",base[i,"reach_file"],"\n",
	"cat s", base[i,"reach_file"], ".none s",
		 base[i,"reach_file"], ".split1 s",
		 base[i,"reach_file"], ".split2> s",
		 base[i,"reach_file"], SUFFIX)

	System(paste(Command_cd, "\n", Command_MakeFile))
      }

    # Here is were we make the actual call(s)
    System(paste(Command_cd, "\n", Command_grab))

    if (SORT_BY_SACCADE) {
	Command_RmFiles = paste0(
	  "rm s", base[i,"reach_file"], ".none s",
		  base[i,"reach_file"], ".split1 s",
		  base[i,"reach_file"], ".split2 s",
		  base[i,"reach_file"], SUFFIX)
	system(paste(Command_cd, "\n", Command_RmFiles))
	}

   # TRANSFER the data and clean up any mess
   System(paste0("mv ", LocalDirectory, "/data* ", Directory))
   # System(paste(Command_cd, "\n mv DFTpowerData* ",Directory))
   # Clean up other files that the macro wrote (and if -od flag, did not rm)
   # To use {zen,tyr}, need tcsh, but if no match, may get ugly results
   # System(Command_cd, "\n rm -f power*ps")
   # System(paste0("rm -f ", LocalDirectory, "/matlab.stdout.*"), intern=T)
   #   Generates "rm: No match."
   System(paste0("rm -f ", LocalDirectory, "/Parameters.temp"), intern=F)
   System(paste0("rm -f ", LocalDirectory, "/TrialData.temp"), intern=F)
   System(paste0("rm -f ", LocalDirectory, "/LFP_lockfileR.temp"))
   }

if (SORT_BY_SACCADE)
 System("rm -f ByterSplitInput.b ByterSplitInputPre.b ByterSplitOutput",
	      intern=F)

# cat("DIAG: processes =", 
#    system(paste(
#	 	"ps -a | grep `ps -a -o tty,ppid | grep",
#  		 Sys.getpid(),
#		"| awk '{ print $1 }'` | wc -l"), intern=T),
#    "\n")
