# doIndiPower.r

###########################################################################

# Set basic parameters #
########################
MONK = "zen"	# zen, tyr, both (don't use both: R calls will merge monks)
AREA = "LIP"

PRINT = F		# Print the calls?
PRINT.BRIEF = T		# Just the names of the cells
EXECUTE = T		# Excecute the calls?

MERGE = 2	
		# 1: merge all	(standard; most commmon)
		# 2: pref & null
		# 0: do not merge
		# 10: pref only
		# 20: right, left (skip if vertical only)
		# Usually use '1'; also '2' and '20' (and maybe 10)

if (exists("OVERRIDE"))  {
   MONK = MONK.OVERRIDE
   AREA = AREA.OVERRIDE
   MERGE = MERGE.OVERRIDE
   }

###########################################################################
# GRAB PARAMETERS #
###################
ALIGN =					# Max align determined by RESTRICT
#	"-at2 -i-450:1650 -ot400 "	# sensory (1250 + 100 + min RESTRICT)
	"-at2 -i-450:1350 -ot400 "	# sensory (1250 + 100 + min RESTRICT)
#	"-abt1 -i-1300:350 -ot100 "	# go cue (ditto sensory, but negative)
#	"-aYRedraw -i-1200:240 -ot80 "	# end-aligned

FREQ = "-of10:120:10 "
       # "-of2:32:2 " # for low freq	(I don't think we can do 2; try 4:32:2)
                # 10:20:10 for fast low
                # 25:175:30 for hi freq

RESTRICT = 
	""	# Fixed delay is 1250; can go 50 ms past that (visual latency)
#	"-XeDelay_300:1000,2 "  # minimum delay adds to max allowed

FILTER = "-ol0 "	# Implmented? -ol__ : low-pass filter -3dB point

MORE   = " -xs67 "	# Horizontals!

###########################################################################
System = function(command, print=PRINT, do=EXECUTE, Intern=T) {
	if (print)
	   cat(paste(command, "\n"))
	if (do)
	   system(paste("tcsh -c '", command, "'"), intern=Intern)
	}
	# Allows us to use "{"  (by default, sh is used; use tcsh)
	# But if no match you get ugly results

a = b = NULL
if (MONK=="zen" || MONK=="both") {
   a = read.table("/data/coord/zen/zenunits",
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   a = cbind(a, monk="zen")		# Append monkey name (as a column)
   }
if (MONK=="tyr" || MONK=="both") {
   b = read.table("/data/coord/tyr/tyrunits",		# EFM changed a to b
	   		header=T,comment="/",stringsAsFactors=F, fill=TRUE)
   b = cbind(b, monk="tyr") 		# Append monkey name (as a column)
   }
base = rbind(a,b)			# Required for 'both'
rm(a,b)

# Remove any old intermediate data files before you start (don't echo/print)
System("rm -fr /data/coord/[zt]??/[0-9][0-9]-*/PowerData*")

System(paste("mkdir -p /data/coord/grab/power/R/indi"))
System(paste("mkdir -p /data/coord/grab/power/R/indi/data"))
System(paste("mkdir -p /data/coord/grab/power/R/indi/figs"))
System(paste("rm -fr /data/coord/grab/power/R/indi/data/*"))

setwd("R/indi")
Home = function() { setwd("/data/coord/grab/power") }

cat(MONK, AREA, MERGE, ":\n")

for (channel in 1:4)			# For each recording channel
  for (row in which(base[,paste("area",channel,sep="")] == AREA)) {

    ## Do only a few cells:
    # if (!(base[row,"reach_file"]=="1230.2" ||
    #       base[row,"reach_file"]=="1239.2" ||
    #       base[row,"reach_file"]=="1034.2" ||
    #       base[row,"reach_file"]=="1035.2" ||
    #       base[row,"reach_file"]=="1033.2"))
    # next

    # For recording from the requested area, set i to the ROW of base
    pref.class = as.numeric(base[row,paste("pd",channel,sep="")])
    null.class = (((pref.class-1)+4) %% 8) + 1	# Opposite of preferred
    
    if (MERGE==0 || MERGE==2 || MERGE==10)	# If PD is required,
       if (is.na(pref.class) || pref.class==0)
          next		# Skip if PD not specified or otherwise absent

    if (MERGE==20)	# Right+left only: skip if only verticals (class 3 & 7)
       if (System(paste("grab -xc3 -xc7 -R ",		# -Report trials
                  "/data/coord/", base[row,"monk"],	#  -xclusive of classes
		  "/", base[row,"date"],		#  3 & 7 (the verticals)
		  "/s", base[row,"reach_file"],
		  " | wc -l", sep="")) == "0")		# count the lines
	  next						# Skip if zero
          
    Command_cd = paste(					# Go to the directory
	 "cd /data/coord/", base[row,"monk"], "/", base[row,"date"],";",sep="")
    Command_grab = paste(				# Call grab
	 "grab ", ALIGN, RESTRICT, FILTER, FREQ, 	#  with options

	    " -d", channel,			# -d1, -d2, -d3, or -d4

	    		# From database, ask for just left or right hemisphere:
	    " -oh", ifelse(base[row, paste("hem",channel,sep="")]=="R", 1, 0),

	    		# Pick the right classes (with appropriate merging):
	    if (MERGE == 2)
	        paste(" -mc101,",pref.class," -mc102,",null.class," -xc1:8 ",
		      	sep="")
            else if (MERGE == 20)
	        " -mc1,2,8 -mc5,4,6 -xc3 -xc7"
            else if (MERGE == 10)
	        paste(" -mc101,", pref.class,
		      " -xc1:8 ", sep="")
            else if (MERGE == 1)
		" -mc ",
	    MORE,	# out here - else chg's -x versus -m order!

	    " -od",					# Development flag
	    " -o11",					# Macro 11
	    " s", base[row,"reach_file"], sep="")	# File name

    if (PRINT.BRIEF)
       cat(paste(base[row,"date"], "  s", base[row,"reach_file"], "\n", sep=""))

    # Here is were we make the actual call
    System(paste(Command_cd, "\n", Command_grab))

    # Save the data file (should be just one)
    # paste("cd /data/coord/",base[row,"monk"],"/",base[row,"date"],";",sep="")
    System(paste("rm -fr /data/coord/grab/power/R/indi/data/*"))
    System(paste("mv /data/coord/{zen,tyr}/[0-9][0-9]-*/PowerData* /data/coord/grab/power/R/indi/data"))
    source("power2.r")
    System(paste("mv StackPower.pdf figs/", MONK, "_", AREA, "/", 
	 base[row,"reach_file"], ".", channel, ".pdf", sep=""), Intern=F)
    }
setwd("../..")

# Clean up other files that the macro spat out (and if -od flag, did not rm)
#  To use {zen,tyr}, need tcsh, but when rm -od flag, this may cause trouble!
#    (if no match, may get ugly results)
System("rm -f /data/coord/{zen,tyr}/[0-9][0-9]-*/power*ps")
System("rm -f /data/coord/{zen,tyr}/[0-9][0-9]-*/matlab.stdout.*")
System("rm -f /data/coord/{zen,tyr}/[0-9][0-9]-*/{Parameters,TrialData}.temp")
