# doGroupPower.r (Seul Ah Kim)
# 
# This is a modified version of doPower.r to run with PowerVsDistance.r in R/ subdirectory. 
###########################################################################
# GRAB PARAMETERS #
###########################################################################
                                        # Max align determined by RESTRICT
ALIGN = ifelse(exists("ALIGN.OVERRIDE"), ALIGN.OVERRIDE, "")
ALIGN_CMD = switch( ifelse(ALIGN=="", "target", ALIGN),
		     target = "-at2 -i-450:1350 -ot400 ",                  # target
		      # target = "-at2 -i-450:1900 -ot200 ",                 # unusual version
		      gocue  = "-abt1 -i-1000:400 -ot200 ",                  # Cue to move
		       go     = "-a#62a3 -aKb1 -i-1450:200 -ot100 ",          # Start of the movement
		        end    = "-a#65I1 -a#66I1 -aa$ -i-1200:250 -ot100 ",   # end of move (acquire)
			 EOT    = "-aYRedraw -i-1200:240 -ot80 "                # 10 ms after 'end'
		      )
 # Alignment notes:
   # -ot        -ot100 will run more slowly (and be less smooth) than -ot400,
   #       but only 50 ms will be truncated from each side, rather than 200,
   #       and of course the time resolution will be higher
   # target     -i: 1250 + 100 + minimum of RESTRICT parameter
   # go         saccades (62) should be -asb1, but that sometimes fails
   # end        aligned on FIRST arm acquire for bimanual movements
   # EOT        aligned on LAST arm acquire for bimanual movements

FREQ =  #-of10:120:10"  # Sparse freq range
        # "-of4:240:2"  # Fine gradiations
         "-of4:120:4"   # Fine gradiations

RESTRICT =
        ""      # Fixed delay is 1250; can go 50 ms past that (visual latency)
#       "-XeDelay_300:1000,2 "  # minimum delay adds to max allowed

FILTER = "-ol0 "        # Implmented? -ol__ : low-pass filter -3dB point

MONK = ifelse(exists("MONK.OVERRIDE"), MONK.OVERRIDE, "tyr")
CLASS = ifelse(exists("CLASS.OVERRIDE"), CLASS.OVERRIDE, "RL")
MEMORY = ifelse(exists("MEMORY.OVERRIDE"), MEMORY.OVERRIDE, "F")
SACSPLIT = ifelse(exists("SACSPLIT.OVERRIDE"), SACSPLIT.OVERRIDE, 0)
NEAR = ifelse(exists("NEAR.OVERRIDE"), NEAR.OVERRIDE, 0)
FREQ = ifelse(exists("FREQ.OVERRIDE"), paste0('-of',FREQ.OVERRIDE), "")

###########################################################################
System = function(command, print=PRINT, do=EXECUTE, intern=T) {
	        if (print)
	           cat(paste(command, "\n"))
	        if (do) {
	           system(paste("tcsh -c '", command, "'"), intern=intern)
	         } else
	            return(1)    # Occasionally helps
}

System("rm -fr /data/coord/[zt]??/[0-9][0-9]-*/PowerData*")

for (i in 1:head(dim(base),1)) {
	pref.class = as.numeric(base[i,"pd"])
	null.class = (((pref.class-1)+4) %% 8) + 1  # Opposite of preferred
	channel = base[i,"channel"]
        if (MERGE==2 || MERGE==10 || SORT_BY_SACCADE)       # If PD is required,
		       if (is.na(pref.class) || pref.class==0)
		                next          # Skip if PD not specified or otherwise absent
	Command_cd = paste0(                                # Go to the directory
	        "cd /data/coord/",monk, "/", base[i,"date"], "; ")
	Command_grab = paste0(                              # Call grab
		"grab ", ALIGN_CMD, RESTRICT, FILTER, FREQ,    #  with options
		" -d", channel,                     # -d1, -d2, -d3, or -d4
		# From database, ask for just left or right hemisphere:
		" -oh", ifelse(base[i, "hemi"]=="R", 1, 0),
		# Pick the right classes (with appropriate merging):
		if (MERGE == 2)
			paste0(" -mc101,",pref.class," -mc102,",null.class," -xc1:8 ",sep="")
		else if (MERGE == 10)
		        paste0(" -mc101,", pref.class, " -xc1:8 ")
		else if (MERGE == 1)
			" -mc ",
			" -xs67",		# Horizontals  
			" -o11",
			" s",base[i,"file"]
			)
	cat(paste0(base[i,"date"], "  s", base[i,"file"], "\n"))
	
	# Here is were we make the actual call(s)
	System(paste(Command_cd, "\n", Command_grab))
}

# Save the data files to a new directory
Directory = paste0("/data/coord/grab/power/R/data/",
		          "Group",loop,'of',totGroup,
			  if (NEAR) paste0("+",NEAR),
			  if (ortholimit) paste0("ortho",ortholimit),
			  "_",MONK,
			  "_",
			  Hemisphere,
			 if (MEMORY) "_memory",
			 if (FREQ != "-of10:120:10") paste0("_", substring(FREQ, 4)),
			 if (ALIGN != "") "_",
			 ALIGN,
			 if (MERGE==0)  "_all8",
			 if (MERGE==10) "_pref",
			 if (MERGE==2)  "_PN",
			 if (MERGE==20) "_RL",
			 if (SORT_BY_SACCADE) paste0("_SacSplit_",SAC_TYPE))

System(paste("mkdir -p", Directory))
	
System(paste("mv /data/coord/{zen,tyr}/[0-9][0-9]-*/PowerData* ", Directory))

# Clean up other files that the macro spat out (and if -od flag, did not rm)
#  To use {zen,tyr}, need tcsh, but when rm -od flag, this may cause trouble!
#    (if no match, may get ugly results)
# System("rm -f /data/coord/{zen,tyr}/[0-9][0-9]-*/power*ps")
System("rm -f /data/coord/{zen,tyr}/[0-9][0-9]-*/matlab.stdout.*", intern=F)
System("rm -f /data/coord/{zen,tyr}/[0-9][0-9]-*/{Parameters,TrialData}.temp",
	                                                                          intern=F)
